#!/bin/sh
#
# Infoman Post Installaction Script
#
# Automaticly executed after an infoman remote update.
#
# Necessary cleanup, like remove unused files, can be placed in this script.
#
# Be careful! Don't add a "cleanup" that destroies the infoman!
#

# Remove Wonka (Old unused JavaVM)
if [ -f /bin/mika ]; then
    rm -rf /etc/wonka
    rm -rf /bin/wonka
    rm -rf /lib/wonka
fi
 
# Remove unused persistent logfiles
rm -rf /home/infoman/infoman.log.3
rm -rf /home/infoman/infoman.log.4
rm -rf /home/infoman/infoman.log.5
rm -rf /home/infoman/infoman.log.6

# Remove unused ppp's resolv.conf
rm -rf /etc/ppp/resolv.conf

# wpa_supplicant update
# move old files
mv /sbin/wpa_supplicant /sbin/wpa_supplicant.old
mv /sbin/wpa_passphrase /sbin/wpa_passphrase.old
mv /sbin/wpa_cli /sbin/wpa_cli.old

# not longer necessary
rm -rf /home/infoman/infoman-services.properties

# copy new files
cp /tmp/sbin/wpa_supplicant /sbin
cp /tmp/sbin/wpa_passphrase /sbin
cp /tmp/sbin/wpa_cli /sbin

# Remove useless wpa udev rule
rm -rf /etc/udev/rules.d/70-wpa.rules

#Upgrade Libertas Driver
#for 2.6.24.infoman #101 and higher
strUname="`uname -a`"

strKernelRelease="`uname -r`"
# 2.6.24.infoman

indexOfVersion=`expr index "$strUname" \#[0-9]*`
versionNumber=`echo | awk '{ print substr("'"${strUname}"'","'$indexOfVersion'")}'`
versionNumberCount=`expr match "$versionNumber" '\#[0-9]*'`
versionNumber=`echo | awk '{ print substr("'"${strUname}"'","'$(($indexOfVersion+1))'","'$versionNumberCount'")}'`


if [ $strKernelRelease == '2.6.24.infoman' ]; then
 if [ $(($versionNumber >= 101)) = 1 ]; then  
  echo upgrading libertas driver  
  # move new libertas
  mv /tmp/lib/modules/2.6.24.infoman/kernel/drivers/net/wireless/libertas/libertas.ko /lib/modules/2.6.24.infoman/kernel/drivers/net/wireless/libertas/libertas.ko
  mv /tmp/lib/modules/2.6.24.infoman/kernel/drivers/net/wireless/libertas/libertas_cs.ko /lib/modules/2.6.24.infoman/kernel/drivers/net/wireless/libertas/libertas_cs.ko
  depmod -a
  echo upgrading libertas driver finished
 fi
fi

rm -rf /home/infoman/plugins /bin/mxdemo2

# because of added CMUX module
depmod -a
