#!/bin/sh
#
# Powermanagement Firmware Update
#
# Usage: updatePMfirmware.sh PM_FIRMWARE
#
# PM_FIRMWARE:  gzip compressed pm firmware archive
#
# 1) upload/provide the compressed firmware archive and the checksum
# /tmp/pm.hex.gz
# /tmp/pm.hex.sha
#
# 2) call the update script
# updatePMfirmware.sh /tmp/pm.hex.gz
#

# path to compressed firmware file  (e.g. /tmp/pm.hex.gz)
PM_HEX_GZ=$1

# path to decompressed firmware file (e.g. /tmp/pm.hex)
PM_HEX=`basename $PM_HEX_GZ .gz`

# path of firmware update
PM_HEX_PATH=`dirname $PM_HEX_GZ`

# path to sha1 checksum of decompressed firmware file (e.g. /tmp/pm.hex.sha)
PM_HEX_SHA=$PM_HEX.sha

echo -n decompress...
gzip -d $PM_HEX_GZ
echo done

echo -n checking checksum...
cd $PM_HEX_PATH
sha1sum -c $PM_HEX_SHA
echo done

/sbin/stopInfoman.sh

echo -n start triggering watchdog...
/sbin/pmEndlessWatchdogTrigger.sh&
echo done

echo -n run IAP update...
iaptool.arm $PM_HEX && iaptool.arm -r
echo done

echo -n stopping watchdog triggering...
killall -KILL pmEndlessWatchdogTrigger.sh
echo done

/sbin/startInfoman.sh

# cleanup
rm -rf $PM_HEX_GZ $PM_HEX $PM_HEX_SHA