<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:template match="/">
        <html>
            <head>
                <title>Zebra Enterprise Solutions GmbH</title>
            </head>
            <script  language="JavaScript" src="/print.js" type="text/javascript"></script>
            <body>
                <xsl:apply-templates/>
            </body>
        </html>
    </xsl:template>

    <!-- Beginn Rahmen Tabelle -->
    <xsl:template match="table">
        <link href="/proveo.css" rel="stylesheet" type="text/css" />
        <table width="800" border="0" align="center" cellpadding="1" cellspacing="0" bgcolor="#cccccc">
            <tr>
                <td><table width="100%"  border="0" cellpadding="0" cellspacing="0" bgcolor="#FFFFFF">
                        <tr>
                            <td><table width="100%"  border="0" cellpadding="10">
                                    <tr>
                                        <td width="129"><img src="/img/proveo_logo.gif" width="152" height="85" alt="" /></td>
                                        <td><div align="right"><xsl:value-of select="customer" /><br />
                                                <xsl:value-of select="unitname" />, <xsl:value-of select="unitid" /><br />
                                        <xsl:value-of select="currentTime" /> </div></td>
                                    </tr>
                            </table></td>
                        </tr>
                        <tr>
                            <td bgcolor="#7AC142"><img src="/img/10pixTrans.gif" width="10" height="20" alt="" /></td>
                        </tr>
                        <tr>
                            <td>
                                <ul>
                                    <li>
                                        <xsl:element name="a">
                                            <xsl:attribute name="href">/cgi-bin/catport?8081</xsl:attribute>

                                            <xsl:if test="unitdata">
                                                <xsl:attribute name="class">active</xsl:attribute>
                                            </xsl:if>

                                            <xsl:text>Unit</xsl:text>
                                        </xsl:element>
                                    </li>

                                    <li>
                                        <xsl:element name="a">
                                            <xsl:attribute name="href">/cgi-bin/catport?8080</xsl:attribute>

                                            <xsl:if test="ios or states or communication or download or debug or config">
                                                <xsl:attribute name="class">active</xsl:attribute>
                                            </xsl:if>

                                            <xsl:text>Diagnostics</xsl:text>
                                        </xsl:element>
                                    </li>

                                    <li>
                                        <xsl:element name="a">
                                            <xsl:attribute name="href">/cgi-bin/catport?8087</xsl:attribute>

                                            <xsl:if test="documents">
                                                <xsl:attribute name="class">active</xsl:attribute>
                                            </xsl:if>

                                            <xsl:text>Documents</xsl:text>
                                        </xsl:element>
                                    </li>
                                </ul>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <ul class="sub">
                                    <li>
                                        <xsl:element name="a">
                                            <xsl:attribute name="href">/cgi-bin/catport?8080</xsl:attribute>

                                            <xsl:if test="ios">
                                                <xsl:attribute name="class">active</xsl:attribute>
                                            </xsl:if>

                                            <xsl:text>Digital I/O</xsl:text>
                                        </xsl:element>
                                    </li>

                                    <li>
                                        <xsl:element name="a">
                                            <xsl:attribute name="href">/cgi-bin/catport?8082</xsl:attribute>

                                            <xsl:if test="states">
                                                <xsl:attribute name="class">active</xsl:attribute>
                                            </xsl:if>

                                            <xsl:text>States</xsl:text>
                                        </xsl:element>
                                    </li>

                                    <li>
                                        <xsl:element name="a">
                                            <xsl:attribute name="href">/cgi-bin/catport?8083</xsl:attribute>

                                            <xsl:if test="communication">
                                                <xsl:attribute name="class">active</xsl:attribute>
                                            </xsl:if>

                                            <xsl:text>Communication</xsl:text>
                                        </xsl:element>
                                    </li>

                                    <li>
                                        <xsl:element name="a">
                                            <xsl:attribute name="href">/cgi-bin/catport?8085</xsl:attribute>

                                            <xsl:if test="debug">
                                                <xsl:attribute name="class">active</xsl:attribute>
                                            </xsl:if>

                                            <xsl:text>Internal/Debug</xsl:text>
                                        </xsl:element>
                                    </li>

                                    <li>
                                        <xsl:element name="a">
                                            <xsl:attribute name="href">/cgi-bin/catport?8084</xsl:attribute>

                                            <xsl:if test="download">
                                                <xsl:attribute name="class">active</xsl:attribute>
                                            </xsl:if>

                                            <xsl:text>Logging/Download</xsl:text>
                                        </xsl:element>
                                    </li>

                                    <li>
                                        <xsl:element name="a">
                                            <xsl:attribute name="href">/cgi-bin/catport?8086</xsl:attribute>

                                            <xsl:if test="config">
                                                <xsl:attribute name="class">active</xsl:attribute>
                                            </xsl:if>

                                            <xsl:text>Configuration</xsl:text>
                                        </xsl:element>
                                    </li>

                                </ul>
                            </td>
                        </tr>
                        <tr>
                            <td height="1" bgcolor="#7AC142"><img src="/img/10pixTrans.gif" width="10" height="1" alt="" /></td>
                        </tr>
                        <tr>
                            <td><table width="100%"  border="0" cellspacing="0" cellpadding="2">
                                    <tr>
                                        <td width="10"><img src="/img/10pixTrans.gif" width="10" height="255" alt="" /></td>
                                        <td valign="top">
                                            <!-- Einfügen der Diagsnostics Tabelle -->
                                            <xsl:apply-templates select="ios"/>
                                            <xsl:apply-templates select="unitdata"/>
                                            <xsl:apply-templates select="states"/>
                                            <xsl:apply-templates select="communication"/>
                                            <xsl:apply-templates select="download"/>
                                            <xsl:apply-templates select="debug"/>
                                            <xsl:apply-templates select="config"/>
                                            <xsl:apply-templates select="documents"/>
                                            <!-- EndeEinfügen der Diagsnostics Tabelle -->
                                        </td>
                                    </tr>
                            </table></td>
                        </tr>
                        <tr>
                            <td height="1" bgcolor="#7AC142"><img src="/img/10pixTrans.gif" width="10" height="1" alt="" /></td>
                        </tr>
                        <tr>
                            <td height="20" class="greyFont">Zebra Enterprise Solutions GmbH | Roßfelder Str.65/5 | 74564 Crailsheim | 2006-2010</td>
                        </tr>
                        <tr>
                            <td bgcolor="#7AC142"><img src="/img/10pixTrans.gif" width="10" height="20" alt="" /></td>
                        </tr>
                </table></td>
            </tr>
        </table>
    </xsl:template>
    <!-- Ende Rahmen Tabelle -->

    <!-- Beginn Diagnostics Tabelle -->
    <xsl:template match="ios">
        <table width="80%"  border="0" align="center" cellspacing="2">
            <tr>
                <td><img src="/img/10pixTrans.gif" width="10" height="20" alt=""/></td>
            </tr>
            <tr>
                <td>
                    <table width="60%"  border="0" cellspacing="0" cellpadding="2">
                        <tr>
                            <td>
                                <table>
                                    <tr>
                                        <td class="blue" colspan="5">Digital Input</td>
                                    </tr>
                                    <tr>
                                        <th align="left" colspan="5" class="blueSmall">Connector 1</th>
                                    </tr>

                                    <tr>
                                        <td>Pin</td>
                                        <td>Name</td>
                                        <td>Logical</td>
                                        <td>Electrical</td>
                                        <td>Description</td>
                                    </tr>
                                    <xsl:for-each select="connector1/pin">
                                        <tr>
                                            <td width="45"><xsl:value-of select="pinNo" /></td>
                                            <td width="45">in<xsl:value-of select="name" /></td>
                                            <td> <img src="/img/{valueLogic}.gif" border="0" title="{config}"/></td>
                                            <td> <img src="/img/{valueElectric}.gif" border="0" title="{config}"/></td>
                                            <td>
                                                <xsl:value-of select="description" />
                                            </td>
                                            <td width="20"><img src="/img/10pixTrans.gif" width="20" height="20" alt="" /></td>
                                        </tr>
                                    </xsl:for-each>
                                </table>
                            </td>
                            <td>
                                <table>
                                    <tr>
                                        <td class="blue" colspan="5">Digital Input</td>
                                    </tr>
                                    <tr>
                                        <th align="left" colspan="5" class="blueSmall">Connector 2</th>
                                    </tr>

                                    <tr>
                                        <td>Pin</td>
                                        <td>Name</td>
                                        <td>Logical</td>
                                        <td>Electrical</td>
                                        <td>Description</td>
                                    </tr>
                                    <xsl:for-each select="connector2/pin">
                                        <tr>
                                            <td width="45"><xsl:value-of select="pinNo" /></td>
                                            <td width="45">in<xsl:value-of select="name" /></td>
                                            <td> <img src="/img/{valueLogic}.gif" border="0" title="{config}"/></td>
                                            <td> <img src="/img/{valueElectric}.gif" border="0" title="{config}"/></td>
                                            <td><xsl:value-of select="description" /></td>
                                        </tr>
                                    </xsl:for-each>
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td><img src="/img/10pixTrans.gif" width="10" height="20" alt="" /></td>
            </tr>
            <tr>
                <td>
                    <!-- untere Tabellen -->
                    <table width="100%"  border="0" cellspacing="0" cellpadding="3">
                        <tr>
                            <td valign="top">
                                <table>
                                    <tr>
                                        <td class="blue" colspan="5">Digital Output</td>
                                    </tr>
                                    <tr>
                                        <th align="left" colspan="5" class="blueSmall">Connector 3</th>
                                    </tr>

                                    <tr>
                                        <td>Pin</td>
                                        <td>Name</td>
                                        <td>Logical</td>
                                        <td>Electrical</td>
                                        <td>Description</td>
                                    </tr>

                                    <xsl:for-each select="connector3/pin">
                                        <tr>
                                            <td width="45"><xsl:value-of select="pinNo" /></td>
                                            <td width="45">out<xsl:value-of select="name" /></td>
                                            <td> <img src="/img/{valueLogic}.gif" border="0" title="{config}"/></td>
                                            <td> <img src="/img/{valueElectric}.gif" border="0" title="{config}"/></td>
                                            <td><xsl:value-of select="description" /></td>
                                            <td width="20"><img src="/img/10pixTrans.gif" width="20" height="20" alt="" /></td>
                                        </tr>
                                    </xsl:for-each>
                                </table>
                            </td>
                            <td>
                                <img src="/img/10pixTrans.gif" width="215" height="20" alt="" />
                            </td>
                            <td>
                                <table>
                                    <tr>
                                        <td class="blue" colspan="5">Analog Input, Wakeup and Counter</td>
                                    </tr>
                                    <tr>
                                        <th align="left" colspan="5" class="blueSmall">Connector 4</th>
                                    </tr>

                                    <tr>
                                        <td>Pin</td>
                                        <td>Name</td>
                                        <td>Value</td>
                                        <td>Description</td>
                                    </tr>

                                    <xsl:for-each select="connector4/pin">
                                        <tr>
                                            <td width="45"><xsl:value-of select="pinNo" /></td>
                                            <td width="45"><xsl:value-of select="name" /></td>
                                            <td><xsl:value-of select="valueLogic" /></td>
                                            <td><xsl:value-of select="description" /></td>
                                        </tr>
                                    </xsl:for-each>

                                </table>
                                <!-- Sonstige -->
                                <table>
                                    <tr>
                                        <td class="blue" colspan="5">Miscellaneous</td>
                                    </tr>
                                    <tr>
                                        <th align="left" colspan="5" class="blueSmall">internal</th>
                                    </tr>

                                    <tr>
                                        <td>Pin</td>
                                        <td>Name</td>
                                        <td>Value</td>
                                        <td>Description</td>
                                    </tr>

                                    <xsl:for-each select="connector5/pin">
                                        <tr>
                                            <td width="45"><xsl:value-of select="pinNo" /></td>
                                            <td width="45"><xsl:value-of select="name" /></td>
                                            <td><xsl:value-of select="valueLogic" /></td>
                                            <td><xsl:value-of select="description" /></td>
                                        </tr>
                                    </xsl:for-each>
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td>
                    <table width="100%"  border="0" cellspacing="2">
                        <tr>
                            <td></td>
                            <td width="14"><div align="right"><a href="/cgi-bin/catport?8080"><img src="/img/refresh.gif" width="14" height="13" alt="" border="0" /></a></div></td>
                            <td width="17"><div align="right"><a href="#" onClick="printit()"><img src="/img/print.gif" width="17" height="13" alt="" border="0" /></a></div></td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td><img src="/img/10pixTrans.gif" width="10" height="20" alt="" /></td>
            </tr>
        </table>
    </xsl:template>
    <!-- Ende Diagnostics Tabelle -->



    <!-- Geraetedaten -->
    <xsl:template match="unitdata">
        <table width="80%"  border="0" align="center" cellspacing="2">
            <tr>
                <td><img src="img/10pixTrans.gif" width="10" height="20" alt=""/></td>
            </tr>
            <tr>
                <td><table width="100%"  border="0" cellspacing="2">
                        <tr>
                            <td width="21%" class="blue">User</td>
                            <td width="79%"><xsl:value-of select="user"/></td>
                        </tr>
                        <tr>
                            <td><img src="img/10pixTrans.gif" width="10" height="20" alt=""/></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="blue"><xsl:value-of select="unit/kind"/></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Type:</td>
                            <td><xsl:value-of select="unit/type"/></td>
                        </tr>
                        <tr>
                            <td>Manufacturer:</td>
                            <td><xsl:value-of select="unit/manufactor"/></td>
                        </tr>
                        <tr>
                            <td>Description:</td>
                            <td><xsl:value-of select="unit/description"/></td>
                        </tr>
                        <tr>
                            <td><img src="img/10pixTrans.gif" width="10" height="20" alt=""/></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="blue">Infoman</td>
                            <td></td>
                        </tr>

                        <tr>
                            <td>System Boot Time:</td>
                            <td><xsl:value-of select="infoman/runtime/systemBootTime"/></td>
                        </tr>

                        <tr>
                            <td>Uptime (OS):</td>
                            <td><xsl:value-of select="infoman/runtime/uptimeOS"/></td>
                        </tr>
                        <tr>
                            <td>Uptime (Application):</td>
                            <td><xsl:value-of select="infoman/runtime/uptimeApp"/></td>
                        </tr>
                        <tr>
                            <td>Load average:</td>
                            <td><xsl:value-of select="infoman/runtime/loadAverage"/><xsl:text>(1 min, 5 min, 15 min)</xsl:text></td>
                        </tr>
                        <tr>
                            <td>CPU:</td>
                            <td><xsl:value-of select="infoman/runtime/cpuLoadLastSecond"/><xsl:text>% (since systemstart: </xsl:text> <xsl:value-of select="infoman/runtime/cpuLoad"/> <xsl:text>%)</xsl:text></td>
                        </tr>
                        <tr>
                            <td>Memory:</td>
                            <td><xsl:text>free:  </xsl:text><xsl:value-of select="infoman/runtime/memoryFree"/><xsl:text> Bytes (total:  </xsl:text><xsl:value-of select="infoman/runtime/memoryTotal"/><xsl:text> Bytes)</xsl:text></td>
                        </tr>
                        <tr>
                            <td>Description:</td>
                            <td><xsl:value-of select="infoman/description"/></td>
                        </tr>
                        <tr>
                            <td>Hardware (Core):</td>
                            <td><xsl:value-of select="infoman/hw"/></td>
                        </tr>
                        <tr>
                            <td>Kernel:</td>
                            <td><xsl:value-of select="infoman/kernel"/></td>
                        </tr>
                        <tr>
                            <td>Power Management:</td>
                            <td><xsl:value-of select="infoman/pm"/></td>
                        </tr>
                        <tr>
                            <td>Infoman Software:</td>
                            <td><xsl:value-of select="infoman/sw-version"/></td>
                        </tr>
                        <tr>
                            <td>S/N:</td>
                            <td><xsl:value-of select="infoman/sn"/></td>
                        </tr>
                        <tr>
                            <td>Hardware (MAC) S/N:</td>
                            <td><xsl:value-of select="infoman/hwSN"/></td>
                        </tr>
                        <tr>
                            <td>Root FS:</td>
                            <td><xsl:value-of select="infoman/rootfs"/></td>
                        </tr>
                        <tr>
                            <td class="blue">Modem</td>
                            <td><xsl:value-of select="infoman/modem/Manufactor"/> - <xsl:value-of select="infoman/modem/ModelID"/></td>
                        </tr>
                        <tr>
                            <td>IMEI:</td>
                            <td><xsl:value-of select="infoman/modem/IMEI"/></td>
                        </tr>
                        <tr>
                            <td>IMSI:</td>
                            <td><xsl:value-of select="infoman/modem/IMSI"/></td>
                        </tr>
                        <tr>
                            <td>Firmware:</td>
                            <td><xsl:value-of select="infoman/modem/SWVersion"/></td>
                        </tr>
                </table></td>
            </tr>
            <tr>
                <td><table width="100%"  border="0" cellspacing="2">
                        <tr>
                            <td></td>
                            <td width="14"><div align="right"><a href="diagnostics.htm"><img src="img/10pixTrans.gif" width="14" height="13" alt="" border="0" /></a></div></td>
                            <td width="17"><div align="right"><a href="#" onclick="printit()"><img src="img/print.gif" width="17" height="13" alt="" border="0" /></a></div></td>
                        </tr>
                </table></td>
            </tr>
            <tr>
                <td><img src="img/10pixTrans.gif" width="10" height="20" alt="" /></td>
            </tr>
        </table>
    </xsl:template>
    <!-- End Geraetedaten -->

    <!-- Zustände -->
    <xsl:template match="states">
        <table width="80%"  border="0" align="center" cellspacing="2">
            <tr>
                <td><img src="../img/10pixTrans.gif" width="10" height="20" alt=""/></td>
            </tr>

            <xsl:for-each select="stateModel">

                <tr>
                    <td>
                        <table width="100%"  border="0" cellspacing="2">
                            <tr>
                                <td colspan="7" class="blue"><xsl:value-of select="name"/>:</td>
                            </tr>

                            <xsl:for-each select="state">
                                <tr>
                                    <td width="45"><xsl:value-of select="name"/></td>
                                    <td width="20"><img src="../img/{value}.gif" width="20" height="20" alt="" /></td>
                                    <td></td>
                                    <td width="20"></td>
                                    <td width="45"></td>
                                    <td width="20"></td>
                                    <td></td>
                                </tr>
                            </xsl:for-each>

                        </table>
                    </td>
                </tr>
                <tr>
                    <td><img src="../img/10pixTrans.gif" width="10" height="20" alt="" /></td>
                </tr>

            </xsl:for-each>



            <tr>
                <td class="blue">Current GPS Position:</td>
            </tr>
            <tr>
                <td>trusted: <img src="../img/{position/trusted}.gif" width="20" height="20" alt="" /></td>
            </tr>

            <xsl:for-each select="position/records/record">

                <tr>
                    <td><xsl:value-of select="name"/>: <xsl:value-of select="value"/></td>
                </tr>

            </xsl:for-each>

            <tr>
                <td><img src="../img/10pixTrans.gif" width="10" height="20" alt="" /></td>
            </tr>

            <tr>
                <td>
                    <table width="100%"  border="0" cellspacing="2">
                        <tr>
                            <td></td>
                            <td width="14"><div align="right"><a href="/cgi-bin/catport?8082"><img src="../img/refresh.gif" width="14" height="13" alt="" border="0" /></a></div></td>
                            <td width="17"><div align="right"><a href="#" onclick="printit()"><img src="../img/print.gif" width="17" height="13" alt="" border="0" /></a></div></td>
                        </tr>
                    </table>
                </td>
            </tr>

            <tr>
                <td><img src="../img/10pixTrans.gif" width="10" height="20" alt="" /></td>
            </tr>

        </table>
    </xsl:template>
    <!-- Ende Zustände -->
    <xsl:template match="communication">
        <table width="80%"  border="0" align="center" cellspacing="2">
            <tr>
                <td><img src="../img/10pixTrans.gif" width="10" height="20" alt=""/></td>
            </tr>

            <tr>
                <td><table width="100%"  border="0" cellspacing="2">
                        <tr>
                            <td colspan="7" class="blue">Communication</td>
                        </tr>
                        <tr>
                            <td width="230">Last transmit successful?</td>
                            <td width="20"><img src="../img/{lastSendSuccessful}.gif" width="20" height="20" alt="" /></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td width="20"></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td width="230">active</td>
                            <td width="20"><xsl:value-of select="active"/></td>
                        </tr>

                        <tr>
                            <td width="230">IPsec-Connection active? </td>
                            <td width="20"><img src="../img/{ipsecActive}.gif" width="20" height="20" alt="" /></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td width="20"></td>
                            <td></td>
                        </tr>

                        <tr>
                            <td colspan="7" class="blue">GPRS</td>
                        </tr>
                        <tr>
                            <td width="230">active</td>
                            <td width="20"><img src="../img/{pppActive}.gif" width="20" height="20" alt="" /></td>
                        </tr>
                        <tr>
                            <td width="230">quality</td>
                            <td width="20"><xsl:value-of select="gprs/parameters/quality"/> %</td>
                        </tr>
                        <tr>
                            <td width="230">address</td>
                            <td width="20"><xsl:value-of select="gprs/parameters/address"/></td>
                        </tr>

                </table></td>
            </tr>
            <!-- wlan block begin -->
            <tr>
                <td><img src="../img/10pixTrans.gif" width="10" height="20" alt="" /></td>
            </tr>
            <td><table width="100%"  border="0" cellspacing="2">
                    <tr>
                        <td colspan="7" class="blue">Wifi</td>
                    </tr>
                    <tr>
                        <td width="230">active</td>
                        <td width="20"><img src="../img/{wlan/parameters/active}.gif" width="20" height="20" alt="" /></td>
                    </tr>
                    <tr>
                        <td width="230">quality</td>
                        <td width="20"><xsl:value-of select="wlan/parameters/quality"/> %</td>
                    </tr>
                    <tr>
                        <td width="230">Signal Level:</td>
                        <td width="20"><xsl:value-of select="wlan/parameters/signal"/> dBm</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td width="20"></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td width="230">Noise Level:</td>
                        <td width="20"><xsl:value-of select="wlan/parameters/noise"/> dBm</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td width="20"></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td width="230">Link Quality:</td>
                        <td width="20"><xsl:value-of select="wlan/parameters/linkquality"/> %</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td width="20"></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td width="230">ESSID:</td>
                        <td width="20"><xsl:value-of select="wlan/parameters/essid"/></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td width="20"></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td width="230">Access Point:</td>
                        <td width="20"><xsl:value-of select="wlan/parameters/accessPoint"/></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td width="20"></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td width="230">Frequency:</td>
                        <td width="20"><xsl:value-of select="wlan/parameters/frequency"/> GHz</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td width="20"></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td width="230">Channel:</td>
                        <td width="20"><xsl:value-of select="wlan/parameters/channel"/></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td width="20"></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td width="230">Bit Rate:</td>
                        <td width="20"><xsl:value-of select="wlan/parameters/bitRate"/> MBit/s</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td width="20"></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td width="230">Address:</td>
                        <td width="20"><xsl:value-of select="wlan/parameters/address"/></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td width="20"></td>
                        <td></td>
                    </tr>


            </table></td>
            <!-- wlan block end-->
            <tr>
                <td><img src="../img/10pixTrans.gif" width="10" height="20" alt="" /></td>
            </tr>
            <tr>

                <td><table width="100%"  border="0" cellspacing="2">
                        <tr>
                            <td colspan="2" class="blue">Events:</td>
                        </tr>
                        <tr>
                            <td colspan="2">Events in Sendqueue: <xsl:value-of select="events/inQueue"/></td>
                        </tr>
                        <tr>
                            <td colspan="2">Events Queue State: <xsl:value-of select="events/queueState"/></td>
                        </tr>
                        <tr>
                            <td width="50"><img src="../img/10pixTrans.gif" width="10" height="20" /></td>
                            <td width="534"></td>
                        </tr>

                        <xsl:for-each select="events/event">

                            <tr>
                                <td width="50"><xsl:number level="single" count="events/event" format="1"/></td>
                                <td><xsl:value-of select="."/></td>
                            </tr>

                        </xsl:for-each>

                </table></td>
            </tr>
            <tr>
                <td><img src="../img/10pixTrans.gif" width="10" height="20" /><img src="../img/10pixTrans.gif" width="10" height="20" alt="" /></td>
            </tr>
            <tr>
                <td><table width="100%"  border="0" cellspacing="2">
                        <tr>
                            <td></td>
                            <td width="14"><div align="right"><a href="/cgi-bin/catport?8083"><img src="../img/refresh.gif" width="14" height="13" alt="" border="0" /></a></div></td>
                            <td width="17"><div align="right"><a href="#" onclick="printit()"><img src="../img/print.gif" width="17" height="13" alt="" border="0" /></a></div></td>
                        </tr>
                </table></td>
            </tr>
            <tr>
                <td><img src="../img/10pixTrans.gif" width="10" height="20" alt="" /></td>
            </tr>
        </table>
    </xsl:template>

    <xsl:template match="download">
        <table width="80%"  border="0" align="center" cellspacing="2">
            <tr>
                <td><img src="/img/10pixTrans.gif" width="10" height="20" alt=""/></td>
            </tr>

            <tr>
                <td>

                    <table width="100%"  border="0" cellspacing="0" cellpadding="2">
                        <tr>
                            <td>

                                <table>
                                    <tr>
                                        <td class="blue" colspan="3">Logging (/var/log)</td>
                                    </tr>

                                    <tr>
                                        <th align="left" class="blueSmall">File</th>
                                        <th align="left" class="blueSmall">last 100 Lines</th>
                                        <th align="left" class="blueSmall">last 50kByte</th>
                                        <th align="left" class="blueSmall">whole file</th>
                                    </tr>

                                    <tr>
                                        <td>infoman.log</td>
                                        <td><a href="/cgi-bin/tail.sh?-n%20100%20/var/log/infoman.log" target="_blank">view</a></td>
                                        <td><a href="/cgi-bin/tail.sh?-c%2050000%20/var/log/infoman.log" target="_blank">view</a></td>
                                        <td><a href="/cgi-bin/download.sh?/var/log/infoman.log">download</a></td>
                                    </tr>

                                    <tr>
                                        <td>messages</td>
                                        <td><a href="/cgi-bin/tail.sh?-n%20100%20/var/log/messages" target="_blank">view</a></td>
                                        <td><a href="/cgi-bin/tail.sh?-c%2050000%20/var/log/messages" target="_blank">view</a></td>
                                        <td><a href="/cgi-bin/download.sh?/var/log/messages">download</a></td>
                                    </tr>

                                    <tr>
                                        <td>syslog</td>
                                        <td><a href="/cgi-bin/tail.sh?-n%20100%20/var/log/syslog" target="_blank">view</a></td>
                                        <td><a href="/cgi-bin/tail.sh?-c%2050000%20/var/log/syslog" target="_blank">view</a></td>
                                        <td><a href="/cgi-bin/download.sh?/var/log/syslog">download</a></td>
                                    </tr>

                                    <tr>
                                        <td>critical</td>
                                        <td><a href="/cgi-bin/tail.sh?-n%20100%20/var/log/critical" target="_blank">view</a></td>
                                        <td><a href="/cgi-bin/tail.sh?-c%2050000%20/var/log/critical" target="_blank">view</a></td>
                                        <td><a href="/cgi-bin/download.sh?/var/log/critical">download</a></td>
                                    </tr>

                                    <tr>
                                        <td>info</td>
                                        <td><a href="/cgi-bin/tail.sh?-n%20100%20/var/log/info" target="_blank">view</a></td>
                                        <td><a href="/cgi-bin/tail.sh?-c%2050000%20/var/log/info" target="_blank">view</a></td>
                                        <td><a href="/cgi-bin/download.sh?/var/log/info">download</a></td>
                                    </tr>

                                    <tr>
                                        <td>debug</td>
                                        <td><a href="/cgi-bin/tail.sh?-n%20100%20/var/log/debug" target="_blank">view</a></td>
                                        <td><a href="/cgi-bin/tail.sh?-c%2050000%20/var/log/debug" target="_blank">view</a></td>
                                        <td><a href="/cgi-bin/download.sh?/var/log/debug">download</a></td>
                                    </tr>

                                    <tr>
                                        <td>mail</td>
                                        <td><a href="/cgi-bin/tail.sh?-n%20100%20/var/log/mail" target="_blank">view</a></td>
                                        <td><a href="/cgi-bin/tail.sh?-c%2050000%20/var/log/mail" target="_blank">view</a></td>
                                        <td><a href="/cgi-bin/download.sh?/var/log/mail">download</a></td>
                                    </tr>

                                </table>

                                <table>
                                    <tr>
                                        <td class="blue" colspan="3">Configuration</td>
                                    </tr>

                                    <tr>
                                        <th align="left" class="blueSmall">File(s)</th>
                                        <th align="left" class="blueSmall">whole File</th>
                                    </tr>

                                    <tr>
                                        <td>/etc</td>
                                        <td><a href="/cgi-bin/download.sh?/etc">download</a></td>
                                    </tr>

                                    <tr>
                                        <td>/home/infoman/infoman.properties</td>
                                        <td><a href="/cgi-bin/download.sh?/home/infoman/infoman.properties">download</a></td>
                                        <td><a href="/cgi-bin/cat.sh?/home/infoman/infoman.properties" target="_blank">(view)</a></td>
                                    </tr>

                                </table>

                            </td>
                        </tr>
                    </table>

                </td>
            </tr>

            <tr>
                <td><img src="../img/10pixTrans.gif" width="10" height="20" alt="" /></td>
            </tr>
        </table>
    </xsl:template>

    <xsl:template match="debug">
        <table width="80%"  border="0" align="center" cellspacing="2">
            <tr>
                <td><img src="/img/10pixTrans.gif" width="10" height="20" alt=""/></td>
            </tr>

            <tr>
                <td>

                    <table width="100%"  border="0" cellspacing="0" cellpadding="2">
                        <tr>
                            <td>
                                <table>
                                    <tr>
                                        <td class="blue" colspan="3">Date/Time</td>
                                    </tr>

                                    <tr>
                                        <th>current Time</th>
                                        <td><xsl:value-of select="time/current"/></td>
                                    </tr>
                                    <tr>
                                        <th>Timezone</th>
                                        <td><xsl:value-of select="time/timezone"/></td>
                                    </tr>
                                </table>


                                <table border="1">
                                    <tr>
                                        <td class="blue" colspan="3">Blackboard</td>
                                    </tr>

                                    <tr>
                                        <th/>
                                        <th align="left" class="blueSmall">Key</th>
                                        <th align="left" class="blueSmall">Value</th>
                                    </tr>

                                    <xsl:for-each select="blackboard/item">

                                        <tr>
                                            <td><xsl:number level="single" count="blackboard/item" format="1"/></td>
                                            <td><xsl:value-of select="name"/></td>
                                            <td><xsl:value-of select="value"/></td>
                                        </tr>

                                    </xsl:for-each>

                                </table>

                            </td>
                        </tr>
                    </table>

                </td>
            </tr>

            <tr>
                <td><img src="../img/10pixTrans.gif" width="10" height="20" alt="" /></td>
            </tr>
        </table>
    </xsl:template>

    <xsl:template match="config">
        <table width="80%"  border="0" align="center" cellspacing="2">
            <tr>
                <td><img src="/img/10pixTrans.gif" width="10" height="20" alt=""/></td>
            </tr>

            <tr>
                <td>

                    <table width="100%"  border="0" cellspacing="0" cellpadding="2">
                        <tr>
                            <td>
                                <table border="1">
                                    <tr>
                                        <td class="blue" colspan="3">Configuration</td>
                                    </tr>

                                    <tr>
                                        <th/>
                                        <th align="left" class="blueSmall">Key</th>
                                        <th align="left" class="blueSmall">Value</th>
                                    </tr>

                                    <xsl:for-each select="item">

                                        <tr>
                                            <td><xsl:number level="single" count="item" format="1"/></td>
                                            <td><xsl:value-of select="name"/></td>
                                            <td><xsl:value-of select="value"/></td>
                                        </tr>

                                    </xsl:for-each>

                                </table>

                            </td>
                        </tr>
                    </table>

                </td>
            </tr>

            <tr>
                <td><img src="../img/10pixTrans.gif" width="10" height="20" alt="" /></td>
            </tr>
        </table>
    </xsl:template>
    <xsl:template match="documents">
        <table width="80%"  border="0" align="center" cellspacing="2">
            <tr>
                <td><img src="/img/10pixTrans.gif" width="10" height="20" alt=""/></td>
            </tr>

            <tr>
                <td>
                    <iframe src="/download" width="600" height="450">
                        <a href="/download">click here to see the downloads</a>
                    </iframe>
                </td>
            </tr>

            <tr>
                <td><img src="../img/10pixTrans.gif" width="10" height="20" alt="" /></td>
            </tr>
        </table>
    </xsl:template>
</xsl:stylesheet>
