package tkchel;

import de.proveo.wwt.logic.ejb.dataIn.event.mapper.*;

import java.util.ArrayList;

import org.apache.commons.logging.LogFactory;

/**
 * Create Fuel Measurement by Liquid Level Sensor measurements.
 * Use LLS1 and LLS2.
 *
 * @author <a href="mailto:jbader@proveo.com">Joachim Bader</a>
 * $Rev: 21140 $
 */
class TKChelLLSFuelLevelMappingSVOwithThreshold extends BaseTKChelLLSFuelLevelMappingSVO implements EventMapper
{

	/**
	 * @return the threshold which must be exceeded to fire a new event
	 * a negative is disabling the threshold feature
	 */
	float getLiterEventThreshold()
	{
		return 10.0;
	}	
	
	ArrayList getLLS1Values()
	{
		return [0, 125, 242, 331, 440, 544, 650, 757, 871, 968, 1023];
	}
	
	ArrayList getLLS1Liters()
	{
		return [0, 70, 140, 210, 280, 350, 420, 490, 560, 630, 700];
	}
		
	public TKChelLLSFuelLevelMappingSVOwithThreshold()
	{
		super(LogFactory.getLog(TKChelLLSFuelLevelMappingSVOwithThreshold.class));
	}
}