package infomanLite.fmgtest;

import infomanLite.BaseInfomanLiteEventMapper;

import de.proveo.wwt.logic.ejb.dataIn.event.mapper.*;

import de.proveo.event.util.efm.EFMEventUtil;
import de.proveo.util.geo.GPSPosition;

import de.proveo.eventbase.EventConstants;

import java.util.*;

import java.text.*;

import de.proveo.event.util.raw.ByteUtil;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeStruct;


/**
 * Event Mapper Scripts for InfomanLite FMG Test GH801_GH689.
 *
 * Should be used for entry point <code>infoman.event.3rdparty.eventMapper</code>
 * 
 * io.digitalIn0: ignition
 * io.digitalIn1: motorD+
 * io.digitalIn2: switchElectroEngine
 * io.digitalIn3: gearForward
 * io.digitalIn5: gearBackward
 *
 * @author <a href="mailto:jbader@proveo.com">Joachim Bader</a>
 * $Rev: 22109 $
 */
class GH801_GH689 extends BaseInfomanLiteEventMapper 
{	
	protected static final int HYPRID_STATE_MODEL_ID = 2040;
	protected static final int DIESEL_STATE_ID = 2041;
	protected static final int ELECTRO_STATE_ID = 2042;	
	
	Boolean isEngineOnCondition(Map eventParameters)
	{
		// motorD+ and ignition
		return eventParameters.get("io.digitalIn1").equals(Boolean.TRUE) && eventParameters.get("io.digitalIn0").equals(Boolean.TRUE);
	}

	Boolean isHypridDieselCondition(Map eventParameters)
	{
		// switchElectroEngine
		return eventParameters.get("io.digitalIn2").equals(Boolean.TRUE);
	}
	
	Boolean isDriveCondition(Map eventParameters)
	{
		// gear forward or backward
		if(eventParameters.get("io.digitalIn3").equals(Boolean.TRUE) || eventParameters.get("io.digitalIn4").equals(Boolean.TRUE))
		{		
			// motorD+
			if(eventParameters.get("io.digitalIn1").equals(Boolean.TRUE))
			{
				return true;
			}
			// switchElectroEngine and ignition
			else if(eventParameters.get("io.digitalIn2").equals(Boolean.TRUE) && eventParameters.get("io.digitalIn0").equals(Boolean.TRUE))
			{
				return true;
			}
		}
		
		return false;
	}
	
	Integer getDistanceMeasurementType()
	{
		return 26;
	}
	
	/**
	 * @return new state or null if no update is necessary
	 */
	Integer evaluateHypridStatusModel(CurrentStateFacadeStruct currentState, Boolean hypridDieselCondition)
	{
		// we cannot determine anything
		if(hypridDieselCondition==null)
		{
			return null;
		}
		
		// status modell is not initialized yet
		if(currentState==null)
		{				
			if(hypridDieselCondition)
			{
				return DIESEL_STATE_ID;
			}
			else
			{
				return ELECTRO_STATE_ID;
			}
		}
		
		switch(currentState.getStateId())
		{
			case DIESEL_STATE_ID:
				if(!hypridDieselCondition)
				{
					return ELECTRO_STATE_ID;
				}
				break;
			
			case ELECTRO_STATE_ID:
				if(hypridDieselCondition)
				{
					return DIESEL_STATE_ID;
				}
				break;
		}
		
		return null;
	}
	
	void createStatusModelEvents(List<Properties> efmEvents, Map eventParameters, Map metainfo, FacadeWrapper facadeWrapper)
	{
		super.createStatusModelEvents(efmEvents, eventParameters, metainfo, facadeWrapper);
		
		List<Long> efmUnitIds = (List<Long>) metainfo.get("efm.unitIds");
		
		Boolean hypridDieselCondition = isHypridDieselCondition(eventParameters);
		CurrentStateFacadeStruct currentState = facadeWrapper.getCurrentStateFacade().getCurrentState(efmUnitIds.get(0), HYPRID_STATE_MODEL_ID);
		Integer newState = evaluateHypridStatusModel(currentState, hypridDieselCondition);
		
		if(newState!=null)
		{
			Properties event = new Properties();
			EFMEventUtil.addGeneralParameters(event, efmUnitIds, (Long) eventParameters.get("timestamp"));
			event.setProperty(EventConstants.ATTRIBUTE_STATEMODEL, Integer.toString(HYPRID_STATE_MODEL_ID));
			event.setProperty(EventConstants.ATTRIBUTE_STATEID, Integer.toString(newState));			
		}
	}
}