package infomanLite;

import de.proveo.wwt.logic.ejb.dataIn.event.mapper.*;

import de.proveo.event.util.efm.EFMEventUtil;
import de.proveo.util.geo.GPSPosition;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeStruct;

import de.proveo.eventbase.EventConstants;

import java.util.*;

import java.text.*;

/**
 * Generate a keep Alive event (if necessary).
 * 
 * Should be used for entry point <code>infoman.event.3rdparty.eventMapper</code>
 *
 * KeepAlive events are generated if
 * <ul>
 *	<li>if old keep alive event is old enough</li>
 *	<li>no keep alive event is found on the server</li>
 *	<li>if infoman is not in online state</li>
 * </ul>
 *
 * @author <a href="mailto:jbader@proveo.com">Joachim Bader</a>
 * $Rev: 22131 $
 */
class InfomanLiteKeepAliveEventMapper implements EventMapper 
{
	// 5 minute keep alive interval
	private static final int KEEP_ALIVE_EVENT_INTERVAL = 5*60*1000;
	
	
	private static final int SLEEP_STATE_MODEL = 2110;
	private static final int ONLINE_STATE_ID = 2112;
	
	public List createEFMevents(Map eventParameters, Map metainfo, FacadeWrapper facadeWrapper)
	{
		List<Properties> efmEvents = null;
		
		List<Long> efmUnitIds = (List<Long>) metainfo.get("efm.unitIds");
		
		Long lastKeepAlive = facadeWrapper.getKeepAliveOutFacade().getLastKeepAliveTimestamp(efmUnitIds.get(0));
		Long timestamp = eventParameters.get("timestamp");
		
		if(isNewKeepAliveNecessary(lastKeepAlive, timestamp, efmUnitIds, facadeWrapper))
		{				
			efmEvents = new ArrayList<Properties>();
			
			Properties event = new Properties();
			EFMEventUtil.addGeneralParameters(event, efmUnitIds, timestamp);
			efmEvents.add(event);
		}	
		
		return efmEvents;		
	}
	
	boolean isNewKeepAliveNecessary(Long lastKeepAlive, Long eventTimestamp, List<Long> efmUnitIds, FacadeWrapper facadeWrapper)
	{
		if((lastKeepAlive==null) || (eventTimestamp==null))
		{
			return true;
		}
		else if((eventTimestamp.longValue()-lastKeepAlive.longValue())>KEEP_ALIVE_EVENT_INTERVAL)
		{
			return true;
		}
		else
		{
			// if not in online state, create keep alive
			CurrentStateFacadeStruct infomanOnlineState = facadeWrapper.getCurrentStateFacade().getCurrentState(efmUnitIds.get(0), SLEEP_STATE_MODEL)
			return ((infomanOnlineState==null) || (infomanOnlineState.getStateId()!=ONLINE_STATE_ID));
		}		
	}	
}