package infomanLite;

import de.proveo.wwt.logic.ejb.dataIn.event.mapper.*;

import de.proveo.event.util.efm.EFMEventUtil;
import de.proveo.util.geo.GPSPosition;

import de.proveo.eventbase.EventConstants;

import java.util.*;

import java.text.*;

import de.proveo.event.util.raw.ByteUtil;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeStruct;


/**
 * Event Mapper Script for InfomanLite
 *
 * Should be used for entry point <code>infoman.event.3rdparty.eventMapper</code>
 *
 * Generate events:
 * <ul>
 *   <li>Position with distance measurement (derived from base script)</li>
 *   <li>Motorstatus: Engine on/off based on <code>io.digitalIn0</code></li>
 *   <li>
 *		Operationstatus: available, work and drive mode. Work mode is based on 
 *		<code>io.digitalIn1</code> and drive mode is based on <code>io.digitalIn2</code>
 *   </li>
 * </ul>
 *
 * @author <a href="mailto:jbader@proveo.com">Joachim Bader</a>
 * $Rev: 22136 $
 */
class InfomanLiteEventMapper extends BaseInfomanLiteEventMapper 
{
	Boolean isEngineOnCondition(Map eventParameters)
	{
		return eventParameters.get("io.digitalIn0").equals(Boolean.TRUE);
	}
	
	Boolean isWorkCondition(Map eventParameters)
	{
		return eventParameters.get("io.digitalIn2").equals(Boolean.TRUE);
	}
	
	Boolean isDriveCondition(Map eventParameters)
	{
		return eventParameters.get("io.digitalIn3").equals(Boolean.TRUE) && eventParameters.get("io.digitalIn2").equals(Boolean.FALSE);
	}
	
	Integer getDistanceMeasurementType()
	{
		return 26;
	}
}