#!/bin/sh
#
# Backup Infoman configuration
# - configuration: infoman.properties, gps.properties</li>
# - persistentBlackboard, infomanACL, geofencing.csv</li>
# - events
#
INFOMAN_PROPERTIES=infoman.properties
GPS_PROPERTIES=gps.properties

TMP_DIR=/tmp/configBackup
BACKUP_DESC=$TMP_DIR/desc.properties

rm -rf $TMP_DIR
mkdir -p $TMP_DIR
cd /home/infoman

if [ -h $INFOMAN_PROPERTIES ]; then #file exists and is a symbolic link -h
  echo "$INFOMAN_PROPERTIES is a symbolic link"
  echo -n "$INFOMAN_PROPERTIES=" >> $BACKUP_DESC
  echo `readlink $INFOMAN_PROPERTIES` >> $BACKUP_DESC
  cp `readlink $INFOMAN_PROPERTIES` $TMP_DIR
else
  if [ -f $INFOMAN_PROPERTIES ]; then #file exists and is a regular file
    echo "$INFOMAN_PROPERTIES is a regular file"
    cp $INFOMAN_PROPERTIES $TMP_DIR
  else
    echo "$INFOMAN_PROPERTIES does not exist and won't be part of the backup"
  fi
fi

if [ -h $GPS_PROPERTIES ]; then #file exists and is a symbolic link -h
  echo "$GPS_PROPERTIES is a symbolic link"
  echo -n "$GPS_PROPERTIES=" >> $BACKUP_DESC
  echo `readlink $GPS_PROPERTIES` >> $BACKUP_DESC
  cp `readlink $GPS_PROPERTIES` $TMP_DIR
else
  if [ -f $GPS_PROPERTIES ]; then #file exists and is a regular file -f
    echo "$GPS_PROPERTIES is a regular file"
    cp $GPS_PROPERTIES $TMP_DIR
  else
    echo "$GPS_PROPERTIES does not exist and won't be part of the backup"
  fi
fi

cp persistentBlackboard $TMP_DIR
cp infomanACL $TMP_DIR
cp geofencing.csv $TMP_DIR
cp events* $TMP_DIR

#Bus
TASK_MGMT_PLUGIN_NAME=bus
if [ -d /home/infoman/plugins/$TASK_MGMT_PLUGIN_NAME ]; then
    mkdir -p $TMP_DIR/$TASK_MGMT_PLUGIN_NAME
    cp /home/infoman/plugins/$TASK_MGMT_PLUGIN_NAME/config.properties $TMP_DIR/$TASK_MGMT_PLUGIN_NAME
    cp /home/infoman/plugins/$TASK_MGMT_PLUGIN_NAME/user.properties $TMP_DIR/$TASK_MGMT_PLUGIN_NAME
    cp /home/infoman/plugins/$TASK_MGMT_PLUGIN_NAME/initTouchd.sh $TMP_DIR/$TASK_MGMT_PLUGIN_NAME
fi

# Schlepp
TASK_MGMT_PLUGIN_NAME=schlepp
if [ -d /home/infoman/plugins/$TASK_MGMT_PLUGIN_NAME ]; then
    mkdir -p $TMP_DIR/$TASK_MGMT_PLUGIN_NAME
    cp /home/infoman/plugins/$TASK_MGMT_PLUGIN_NAME/config.properties $TMP_DIR/$TASK_MGMT_PLUGIN_NAME
    cp /home/infoman/plugins/$TASK_MGMT_PLUGIN_NAME/user.properties $TMP_DIR/$TASK_MGMT_PLUGIN_NAME
    cp /home/infoman/plugins/$TASK_MGMT_PLUGIN_NAME/initTouchd.sh $TMP_DIR/$TASK_MGMT_PLUGIN_NAME
fi

# compress
tar -czf /tmp/config.backup.tgz $TMP_DIR