/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

@Deprecated
public abstract class BackupFacility {
    private static BackupFacility defaultInstance;

    private BackupFacility() {
    }

    public abstract Handle backup(FileObject ... var1) throws IOException;

    public final Handle backup(Collection<? extends FileObject> fileObjects) throws IOException {
        return this.backup(fileObjects.toArray(new FileObject[fileObjects.size()]));
    }

    public abstract void clear();

    public static BackupFacility getDefault() {
        BackupFacility instance = (BackupFacility)Lookup.getDefault().lookup(BackupFacility.class);
        return instance != null ? instance : BackupFacility.getDefaultInstance();
    }

    private static synchronized BackupFacility getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new DefaultImpl();
        }
        return defaultInstance;
    }

    private static class DefaultHandle
    implements Handle {
        List<Long> handle;
        DefaultImpl instance;

        private DefaultHandle(DefaultImpl instance, List<Long> handles) {
            this.handle = handles;
            this.instance = instance;
        }

        @Override
        public void restore() throws IOException {
            for (long l : this.handle) {
                this.instance.restore(l);
            }
        }
    }

    private static class DefaultImpl
    extends BackupFacility {
        private long currentId = 0L;
        private Map<Long, BackupEntry> map = new HashMap<Long, BackupEntry>();

        private DefaultImpl() {
        }

        @Override
        public Handle backup(FileObject ... file) throws IOException {
            ArrayList<Long> list = new ArrayList<Long>();
            for (FileObject f : file) {
                list.add(this.backup(f));
            }
            return new DefaultHandle(this, list);
        }

        public long backup(FileObject file) throws IOException {
            try {
                BackupEntry entry = new BackupEntry();
                entry.file = File.createTempFile("nbbackup", null);
                this.copy(file, entry.file);
                entry.path = file.getURL().toURI();
                this.map.put(this.currentId, entry);
                entry.file.deleteOnExit();
                return this.currentId++;
            }
            catch (URISyntaxException ex) {
                throw (IOException)new IOException(file.toString()).initCause(ex);
            }
        }

        void restore(long id) throws IOException {
            BackupEntry entry = this.map.get(id);
            if (entry == null) {
                throw new IllegalArgumentException("Backup with id " + id + "does not exist");
            }
            File backup = File.createTempFile("nbbackup", null);
            backup.deleteOnExit();
            File f = new File(entry.path);
            if (this.createNewFile(f)) {
                backup.createNewFile();
                this.copy(f, backup);
            }
            FileObject fileObj = FileUtil.toFileObject((File)f);
            this.copy(entry.file, fileObj);
            entry.file.delete();
            if (backup.exists()) {
                entry.file = backup;
            } else {
                this.map.remove(id);
            }
        }

        private boolean createNewFile(File f) throws IOException {
            if (f.exists()) {
                return true;
            }
            File parent = f.getParentFile();
            if (parent != null) {
                this.createNewFolder(parent);
            }
            FileUtil.createData((File)f);
            return false;
        }

        private void createNewFolder(File f) throws IOException {
            if (!f.exists()) {
                File parent = f.getParentFile();
                if (parent != null) {
                    this.createNewFolder(parent);
                }
                FileUtil.createFolder((File)f);
            }
        }

        private void copy(FileObject a, File b) throws IOException {
            InputStream fs = a.getInputStream();
            FileOutputStream fo = new FileOutputStream(b);
            this.copy(fs, fo);
        }

        private void copy(File a, File b) throws IOException {
            FileInputStream fs = new FileInputStream(a);
            FileOutputStream fo = new FileOutputStream(b);
            this.copy(fs, fo);
        }

        private void copy(File a, FileObject b) throws IOException {
            FileInputStream fs = new FileInputStream(a);
            OutputStream fo = b.getOutputStream();
            this.copy(fs, fo);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copy(InputStream is, OutputStream os) throws IOException {
            try {
                FileUtil.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                is.close();
                os.close();
            }
        }

        @Override
        public void clear() {
            for (BackupEntry entry : this.map.values()) {
                entry.file.delete();
            }
            this.map.clear();
        }

        private class BackupEntry {
            private File file;
            private URI path;

            private BackupEntry() {
            }
        }
    }

    public static interface Handle {
        public void restore() throws IOException;
    }
}

