/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.licensing.impl;

import de.proveo.idm.licensing.api.PermissionHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultPermissionHandler
implements PermissionHandler {
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected final Map<Object, List<PropertyChangeListener>> pclMap = new HashMap<Object, List<PropertyChangeListener>>();
    protected final List<String> allPermissions = new ArrayList<String>();
    protected final Map<Object, List<String>> permissionsMap = new HashMap<Object, List<String>>();
    protected boolean superadmin = false;

    @Override
    public void addPropertyChangeListener(Object identifier, PropertyChangeListener listener) throws IllegalArgumentException {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier can't be null!");
        }
        if (listener == null) {
            throw new IllegalArgumentException("PropertyChangeListener can't be null!");
        }
        List<PropertyChangeListener> pclList = this.pclMap.get(identifier);
        if (pclList == null) {
            pclList = new ArrayList<PropertyChangeListener>();
        }
        pclList.add(listener);
        this.pclMap.put(identifier, pclList);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("PropertyChangeListener can't be null!");
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public List<String> getPermissions(Object identifier) throws IllegalArgumentException {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier can't be null!");
        }
        ArrayList<String> ret = new ArrayList<String>();
        List<String> perm = this.permissionsMap.get(identifier);
        if (perm != null) {
            ret = new ArrayList<String>(perm);
        }
        return ret;
    }

    @Override
    public List<String> getPermissions() {
        return new ArrayList<String>(this.allPermissions);
    }

    @Override
    public boolean hasPermissionForRoles(String ... roles) {
        if (roles == null) {
            throw new IllegalArgumentException("Roles can't be null!");
        }
        if (this.isSuperadmin()) {
            return true;
        }
        for (String role : roles) {
            if (!this.allPermissions.contains(role)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPermissionForRoles(Object identifier, String ... roles) throws IllegalArgumentException {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier can't be null!");
        }
        if (roles == null) {
            throw new IllegalArgumentException("Roles can't be null!");
        }
        if (this.isSuperadmin(identifier)) {
            return true;
        }
        List<String> permissions = this.getPermissions(identifier);
        if (permissions.isEmpty()) {
            return false;
        }
        for (String role : roles) {
            if (!permissions.contains(role)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSuperadmin() {
        return this.superadmin;
    }

    @Override
    public boolean isSuperadmin(Object identifier) throws IllegalArgumentException {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier can't be null!");
        }
        return this.isSuperadmin(this.getPermissions(identifier));
    }

    protected boolean isSuperadmin(List<String> permissions) {
        if (permissions == null) {
            return false;
        }
        return permissions.contains("superadmin");
    }

    @Override
    public void removePermissions(Object identifier) throws IllegalArgumentException {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier can't be null!");
        }
        ArrayList<String> oldAll = new ArrayList<String>(this.allPermissions);
        List<String> oldIdentifier = this.permissionsMap.get(identifier);
        if (oldIdentifier != null) {
            oldIdentifier = new ArrayList<String>(oldIdentifier);
        }
        this.permissionsMap.remove(identifier);
        this.updateAllPermissions();
        this.firePropertyChange(identifier, oldAll, oldIdentifier);
    }

    protected void firePropertyChange(Object identifier, List<String> oldAllPermissions, List<String> oldIdentifierPermissions) {
        List<PropertyChangeListener> pclList = this.pclMap.get(identifier);
        if (pclList != null && !pclList.isEmpty()) {
            List<String> identPerm = this.permissionsMap.get(identifier);
            if (identPerm != null) {
                identPerm = new ArrayList<String>(identPerm);
            }
            for (PropertyChangeListener pcl : pclList) {
                pcl.propertyChange(new PropertyChangeEvent(this, "PermissonHandler.permissionsChanged", oldIdentifierPermissions, identPerm));
            }
        }
        this.pcs.firePropertyChange("PermissonHandler.permissionsChanged", oldAllPermissions, new ArrayList<String>(this.allPermissions));
    }

    @Override
    public void removePropertyChangeListener(Object identifier, PropertyChangeListener listener) throws IllegalArgumentException {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier can't be null!");
        }
        if (listener == null) {
            throw new IllegalArgumentException("PropertyChangeListener can't be null!");
        }
        List<PropertyChangeListener> pclList = this.pclMap.get(identifier);
        if (pclList != null) {
            pclList.remove(listener);
            if (pclList.isEmpty()) {
                this.pclMap.remove(identifier);
            } else {
                this.pclMap.put(identifier, pclList);
            }
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("PropertyChangeListener can't be null!");
        }
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public void setPermissions(Object identifier, List<String> permissions) throws IllegalArgumentException {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier can't be null!");
        }
        if (permissions == null) {
            this.removePermissions(identifier);
            return;
        }
        ArrayList<String> oldAll = new ArrayList<String>(this.allPermissions);
        List<String> oldIdentifier = this.permissionsMap.get(identifier);
        if (oldIdentifier != null) {
            oldIdentifier = new ArrayList<String>(oldIdentifier);
        }
        this.permissionsMap.put(identifier, new ArrayList<String>(permissions));
        this.updateAllPermissions();
        this.firePropertyChange(identifier, oldAll, oldIdentifier);
    }

    protected synchronized void updateAllPermissions() {
        this.allPermissions.clear();
        for (List<String> perm : this.permissionsMap.values()) {
            this.allPermissions.addAll(new ArrayList<String>(perm));
        }
        this.superadmin = this.isSuperadmin(this.allPermissions);
    }
}

