/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.general.performanceCounter;

import de.proveo.wwt.logic.ejb.general.config.ConfigurationRemote;
import de.proveo.wwt.logic.ejb.general.performanceCounter.PerformanceCounterFacadeRemote;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerformanceCounterInitServlet
extends HttpServlet {
    private static final long serialVersionUID = -7661419787911178835L;
    private static final Log log = LogFactory.getLog(PerformanceCounterInitServlet.class);
    private transient ConfigurationRemote configuration;
    private transient PerformanceCounterFacadeRemote performanceCounter;
    private boolean performanceCounterEnabled = false;
    private static final String PERFORMANCE_COUNTER_ENABLED = "performanceCounter.enabled";

    public void init(ServletConfig config) throws ServletException {
        log.debug((Object)"Initializing...");
        super.init(config);
        try {
            InitialContext context = new InitialContext();
            this.configuration = (ConfigurationRemote)context.lookup("rts/Configuration/remote");
            this.performanceCounter = (PerformanceCounterFacadeRemote)context.lookup("rts/PerformanceCounterFacade/remote");
        }
        catch (Exception ex) {
            log.error((Object)"init", (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
        try {
            this.performanceCounterEnabled = this.configuration.getBoolean(PERFORMANCE_COUNTER_ENABLED, false);
            if (this.performanceCounterEnabled && this.performanceCounter.fullyCompatible()) {
                this.performanceCounter.initialize();
            }
        }
        catch (Exception e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
    }

    public void destroy() {
        log.debug((Object)"Shutting down...");
        if (this.performanceCounterEnabled) {
            this.performanceCounter.shutdown();
        }
    }
}

