/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.general.infoman.lite;

import de.proveo.util.servlet.ByteArrayServletResponseWrapper;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationRemote;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import javax.naming.InitialContext;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BinaryConverterACLFilter
implements Filter {
    private static final Log log = LogFactory.getLog(BinaryConverterACLFilter.class);
    private static final String CONTENT_TYPE = "application/vnd.proveo.acl.binary";
    private static final String ID_SIZE_HEADER_NAME = "prv-acl-id-size";
    protected int length;

    public void init(FilterConfig fc) throws ServletException {
        ConfigurationRemote configRemote;
        try {
            InitialContext context = new InitialContext();
            configRemote = (ConfigurationRemote)context.lookup("rts/Configuration/remote");
        }
        catch (Exception ex) {
            throw new ServletException("Cannot connect to ConfigurationFacade", (Throwable)ex);
        }
        this.length = Integer.parseInt(configRemote.getProperties().getProperty("infoman.event.infomanLite.acl.idLength"));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ByteArrayServletResponseWrapper wrappedResponse = new ByteArrayServletResponseWrapper((HttpServletResponse)response);
        chain.doFilter(request, (ServletResponse)wrappedResponse);
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.addHeader(ID_SIZE_HEADER_NAME, Integer.toString(this.length));
        httpResponse.setContentType(CONTENT_TYPE);
        BufferedReader br = new BufferedReader(new StringReader(new String(wrappedResponse.toByteArray())));
        this.parseAndWrite(br, this.length, (OutputStream)httpResponse.getOutputStream());
    }

    public void parseAndWrite(BufferedReader br, int length, OutputStream oout) {
        try {
            String line;
            do {
                if ((line = br.readLine()) == null) continue;
                if (line.equals("0000000000000000")) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Filter out unknown user ('" + line + "'" + ") for InfomanLite"));
                    continue;
                }
                if (line.length() / 2 == length) {
                    this.splitLineWrite(oout, line);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("'" + line + "' has the wrong length"));
            } while (line != null);
        }
        catch (Exception ex) {
            log.warn((Object)"parseAndWrite() runs into", (Throwable)ex);
        }
    }

    public void splitLineWrite(OutputStream oout, String line) {
        int endIndex = 2;
        int startIndex = 0;
        while (endIndex / 2 <= this.length) {
            block3: {
                try {
                    oout.write(this.convertByte(line, startIndex, endIndex));
                }
                catch (Exception ex) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)(line + "has wrong value"));
                }
            }
            startIndex += 2;
            endIndex += 2;
        }
    }

    public int convertByte(String line, int startIndex, int endIndex) {
        return Integer.parseInt(line.substring(startIndex, endIndex), 16);
    }

    public void destroy() {
    }
}

