/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataOut.rpc.infoman;

import de.proveo.util.unit.tree.UnitTreeNodeBean;
import de.proveo.wwt.datamodel.unit.identity.UnitIdentity;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleRPCHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCall;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.AbstractInfomanConfigurationRPCHandler;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeFacadeRemote;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;

public class GetUnitTreeHandler
extends AbstractInfomanConfigurationRPCHandler
implements SimpleRPCHandler {
    private UnitTreeFacadeRemote unitTreeFacade;

    @Override
    public Object execute(SimpleXMLRPCCall call) throws Exception {
        UnitTreeNode rootUnitNode = this.unitTreeFacade.getICCTreeModel();
        return this.buildUnitTree(rootUnitNode);
    }

    @Override
    public String getMethodName() {
        return "GetUnitTree";
    }

    @Override
    public void init() throws Exception {
        super.init();
        InitialContext context = new InitialContext();
        this.unitTreeFacade = (UnitTreeFacadeRemote)context.lookup("rts/UnitTreeFacade/remote");
    }

    private UnitTreeNodeBean buildUnitTree(UnitTreeNode unitNode) {
        UnitTreeNodeBean treeNodeBean;
        UnitDTO unitDTO = (UnitDTO)unitNode.getData();
        UnitModel unitModel = unitDTO.getUnitModel();
        UnitIdentity unitIdentity = unitDTO.getUnitIdentity();
        long unitId = unitModel.getUnitId();
        String name = unitIdentity.getName();
        if (!unitModel.getBasic()) {
            List children = unitNode.getChildren();
            ArrayList<UnitTreeNodeBean> childsList = new ArrayList<UnitTreeNodeBean>();
            if (children != null) {
                for (UnitTreeNode childUnitNode : children) {
                    UnitTreeNodeBean childTreeNode = this.buildUnitTree(childUnitNode);
                    childsList.add(childTreeNode);
                }
            }
            treeNodeBean = new UnitTreeNodeBean(unitId, name, null, false, childsList);
        } else {
            treeNodeBean = new UnitTreeNodeBean(unitId, name, unitDTO.getImage(), true, null);
            treeNodeBean.setDeviceType(unitModel.getDeviceType());
            treeNodeBean.setSerial(unitModel.getSerialNumber());
        }
        return treeNodeBean;
    }
}

