/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataOut.rpc.general;

import de.proveo.util.connection.LoginResponse;
import de.proveo.wwt.logic.app.security.LoginContextUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeRemote;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleRPCHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCall;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginHandler
implements SimpleRPCHandler {
    private static final Log log = LogFactory.getLog(LoginHandler.class);
    public static final String CLIENT_TYPE_AIRPORTMAP_GENERATOR = "apmg";
    public static final String LOGIN_FAILED_REASON_USER_BLOCKED = "userBlocked";
    public static final String PARAM_CLIENT_TYPE = "client";
    public static final String PARAM_USERNAME = "username";
    public static final String PARAM_PASSWORD = "password";
    protected static final String INIT_PARAM_USERADMIN_JNDI_NAME = "UserAdminJNDI";
    private UserAdminFacadeRemote userAdminFacade;

    @Override
    public Object execute(SimpleXMLRPCCall call) throws Exception {
        Object passwordHashParameter;
        String username = null;
        char[] passwordHash = null;
        Object usernameParameter = call.getParameter(PARAM_USERNAME);
        if (usernameParameter != null) {
            username = (String)usernameParameter;
        }
        if ((passwordHashParameter = call.getParameter(PARAM_PASSWORD)) != null) {
            passwordHash = (char[])passwordHashParameter;
        }
        if (username == null || username.length() == 0) {
            throw new ServletException("parameter 'username' missing or empty");
        }
        if (passwordHash == null || passwordHash.length == 0) {
            throw new ServletException("parameter 'password' missing or empty");
        }
        LoginContextUtil lcu = null;
        LoginResponse loginResponse = new LoginResponse(false);
        try {
            lcu = new LoginContextUtil(username, passwordHash);
            lcu.fetchPermissions();
            loginResponse = lcu.login();
        }
        catch (Throwable e1) {
            log.error((Object)"LoginContextUtil runs into", e1);
        }
        return loginResponse;
    }

    @Override
    public String getMethodName() {
        return "Login";
    }

    @Override
    public void init() throws Exception {
        InitialContext context = new InitialContext();
        this.userAdminFacade = (UserAdminFacadeRemote)context.lookup("rts/UserAdminFacade/remote");
    }

    @Override
    public boolean isDisabled() {
        return false;
    }
}

