/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataOut.rpc.airportmap.generator;

import de.proveo.rts.configuration.map.AirportMapGeneratorMBean;
import de.proveo.util.connection.UserNotInRoleException;
import de.proveo.util.service.ServiceFactory;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.area.AreaPoints;
import de.proveo.wwt.logic.app.security.LoginContextUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaInFacadeRemote;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleRPCHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCall;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetAreasHandler
implements SimpleRPCHandler {
    private static final Log log = LogFactory.getLog(GetAreasHandler.class);
    private AreaInFacadeRemote areaInFacadeLocal = null;
    private AirportMapGeneratorMBean airportMapGeneratorConfig;

    @Override
    public Object execute(SimpleXMLRPCCall call) throws Exception {
        List areaEntities;
        Object sendGeoFencingParameter;
        boolean admin;
        HashMap areasHashMap = new HashMap();
        String username = "";
        char[] password = new char[]{};
        Object usernameParameter = call.getParameter("username");
        Object passwordParameter = call.getParameter("password");
        if (usernameParameter != null) {
            username = usernameParameter.toString();
        }
        if (passwordParameter != null) {
            password = (char[])passwordParameter;
        }
        LoginContextUtil lcu = null;
        try {
            lcu = new LoginContextUtil(username, password);
            lcu.fetchPermissions();
            if (!lcu.isAccessPermitted()) {
                throw new LoginException("User '" + username + "' not permitted!");
            }
        }
        catch (LoginException ex) {
            log.warn((Object)("Login failed for user '" + username + "'!"));
            throw ex;
        }
        boolean bl = admin = lcu.isSuperAdmin() || lcu.isUserInRole("section.airportmapgenerator_admin");
        if (!(admin || lcu.isUserInRole("section.airportmapgenerator") || lcu.isUserInRole("section.airportmap"))) {
            throw new UserNotInRoleException("User '" + username + "' is not in role " + "section.airportmapgenerator" + " or " + "section.airportmap" + "!");
        }
        Long airportId = -1L;
        boolean sendDeleted = false;
        boolean sendGeoFencing = false;
        boolean sendNonGeoFencing = false;
        Object airportIdParameter = call.getParameter("airportId");
        if (airportIdParameter != null) {
            airportId = Long.parseLong(airportIdParameter.toString());
            log.debug((Object)("Found airportId '" + airportId + "' in parameters."));
        } else {
            airportId = null;
        }
        Object sendDeletedParameter = call.getParameter("sendDeleted");
        sendDeleted = sendDeletedParameter != null ? Boolean.parseBoolean(sendDeletedParameter.toString()) : lcu.isSuperAdmin() || lcu.isUserInRole("section.airportmapgenerator_admin");
        Object sendNonGeoFencingParameter = call.getParameter("sendAirportMapAreas");
        if (sendNonGeoFencingParameter != null) {
            sendNonGeoFencing = Boolean.parseBoolean(sendNonGeoFencingParameter.toString());
        }
        if ((sendGeoFencingParameter = call.getParameter("sendGeoFencingAreas")) != null) {
            sendGeoFencing = Boolean.parseBoolean(sendGeoFencingParameter.toString());
        }
        if (sendNonGeoFencing && sendGeoFencing) {
            log.error((Object)"Client wants to get both, geo fencing and airportmap areas. This isn't possible, will send only airportmap areas!");
            sendGeoFencing = false;
        } else if (!sendNonGeoFencing && !sendGeoFencing) {
            log.warn((Object)"Client wants to get none of the area types, neither geo fencing nor airportmap areas!?!");
        } else {
            if (!admin && sendNonGeoFencing && !lcu.isUserInRole("section.airportmapgenerator.airportmap") && !lcu.isUserInRole("section.airportmap.area_map")) {
                throw new UserNotInRoleException("User '" + username + "' is in none of the needed roles for this operation: " + "section.airportmapgenerator.airportmap" + " or " + "section.airportmap.area_map");
            }
            if (!admin && sendGeoFencing && !lcu.isUserInRole("section.airportmapgenerator.geofencing") && !lcu.isUserInRole("section.airportmap.area_geofencing")) {
                throw new UserNotInRoleException("User '" + username + "' is in none of the needed roles for this operation: " + "section.airportmapgenerator.geofencing" + " or " + "section.airportmap.area_geofencing");
            }
        }
        if (airportId != null) {
            log.debug((Object)("Fetching areas for airportId '" + airportId + "' ..."));
            areaEntities = this.areaInFacadeLocal.findOrderedByPriorityByAirport(airportId.longValue());
        } else {
            log.debug((Object)"Fetching areas which aren't allocated to any unit id ...");
            areaEntities = this.areaInFacadeLocal.findAreasNotAllocatedToUnit();
        }
        for (Area area : areaEntities) {
            int areaKey = area.getAreaId();
            String areaName = area.getArea();
            String areaDesc = area.getDescription();
            int areaPriority = area.getPriority();
            boolean areaDeleted = area.isDeleted();
            boolean areaGeoFencing = area.isGeofencing();
            Collection areaPoints = this.readPointsForArea(areaKey);
            if (!sendDeleted && areaDeleted || !sendGeoFencing && areaGeoFencing || !sendNonGeoFencing && !areaGeoFencing) continue;
            HashMap<String, Object> areaValues = new HashMap<String, Object>();
            areaValues.put("area_name", areaName);
            areaValues.put("area_desc", areaDesc);
            areaValues.put("area_prio", areaPriority);
            areaValues.put("area_del", areaDeleted);
            areaValues.put("area_geoFenc", areaGeoFencing);
            areaValues.put("area_points", areaPoints);
            areasHashMap.put(areaKey, areaValues);
        }
        log.debug((Object)("Send " + areasHashMap.size() + " area(s) to client."));
        return areasHashMap;
    }

    @Override
    public String getMethodName() {
        return "GetAreas";
    }

    @Override
    public void init() throws Exception {
        InitialContext context = new InitialContext();
        this.areaInFacadeLocal = (AreaInFacadeRemote)context.lookup("rts/AreaInFacade/remote");
        this.airportMapGeneratorConfig = (AirportMapGeneratorMBean)ServiceFactory.getInstance().getService(AirportMapGeneratorMBean.class);
    }

    private Collection readPointsForArea(int areaId) throws ServletException {
        ArrayList<Point> areaPoints = new ArrayList<Point>();
        try {
            for (AreaPoints areaPoint : this.areaInFacadeLocal.findAreaPointsByArea(areaId)) {
                areaPoints.add(new Point(areaPoint.getLongitude(), areaPoint.getLatitude()));
            }
        }
        catch (Exception ex) {
            throw new ServletException("Exception throwing during creating a points collection", (Throwable)ex);
        }
        return areaPoints;
    }

    @Override
    public boolean isDisabled() {
        return this.airportMapGeneratorConfig.isClientsDisabled();
    }
}

