/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.event.wherenet;

import de.proveo.util.ByteUtil;
import de.proveo.util.geo.GPSPosition;
import de.proveo.wwt.logic.servlet.dataIn.event.AbstractEventServlet;
import java.util.Date;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WherenetPosition24730Servlet
extends AbstractEventServlet {
    private static final Log log = LogFactory.getLog(WherenetPosition24730Servlet.class);
    private static final long serialVersionUID = -8172107992298417212L;

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/html;charset=UTF-8");
        int tagId = Integer.parseInt(request.getParameter("tagId"));
        long time = Long.parseLong(request.getParameter("time")) * 1000L;
        String data = request.getParameter("data");
        if (log.isTraceEnabled()) {
            log.trace((Object)("processRequest() " + new Date(time) + " tag: " + tagId + " data: '" + data + "'"));
        }
        int[] rawData = ByteUtil.convertToIntArray((String)data);
        Properties event = this.createPositionEvent(time, tagId, rawData);
        this.processEvent(request.getRemoteAddr(), event);
        log.trace((Object)"doGet() end");
    }

    protected Properties createPositionEvent(long time, int tagId, int[] rawData) {
        Properties properties = new Properties();
        properties.setProperty("u", Integer.toString(tagId));
        properties.setProperty("t", Long.toString(System.currentTimeMillis()));
        int latitudeMsec = rawData[10] + (rawData[9] << 8) + (rawData[8] << 16) + (rawData[7] << 24);
        int longitudeMsec = rawData[6] + (rawData[5] << 8) + (rawData[4] << 16) + (rawData[3] << 24);
        if (log.isTraceEnabled()) {
            StringBuilder buffer = new StringBuilder();
            for (int index = 0; index < rawData.length; ++index) {
                buffer.append(rawData[index]);
                buffer.append(", ");
            }
            log.trace((Object)("rawData: " + buffer.toString()));
            log.trace((Object)("latitudeMsec: " + latitudeMsec + " longitudeMsec: " + longitudeMsec));
        }
        String gga = GPSPosition.createGGA((int)longitudeMsec, (int)latitudeMsec, (String)"073047.000");
        String rmc = GPSPosition.createRMC((int)longitudeMsec, (int)latitudeMsec, (String)"0.09", (String)"29.52", (String)"073047.000", (String)"201107");
        properties.setProperty("r", rmc);
        properties.setProperty("g", gga);
        properties.setProperty("x", "t");
        properties.setProperty("v", "1");
        return properties;
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

