/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.event.udp;

import de.proveo.eventbase.EventResponse;
import de.proveo.eventbase.codec.ResponseEncoder;
import de.proveo.wwt.logic.servlet.dataIn.event.udp.ResponsePayloadFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class ASCIIResponsePayloadFormat
implements ResponsePayloadFormat {
    private static final byte[] responsePrefix = new byte[]{10, 27};
    private long eventId;
    private List<EventResponse> eventResponses;

    @Override
    public void clear() {
        this.eventId = 0L;
        this.eventResponses = null;
    }

    @Override
    public void setEventId(long eventId) {
        this.eventId = eventId;
    }

    @Override
    public void setEventResponses(List<EventResponse> eventResponses) {
        this.eventResponses = eventResponses;
    }

    protected void addLong(ByteArrayOutputStream out, long value) {
        out.write((int)(value >>> 56));
        out.write((int)(value >>> 48));
        out.write((int)(value >>> 40));
        out.write((int)(value >>> 32));
        out.write((int)(value >>> 24));
        out.write((int)(value >>> 16));
        out.write((int)(value >>> 8));
        out.write((int)(value >>> 0));
    }

    @Override
    public byte[] getPayload() throws IOException {
        if (this.eventResponses == null) {
            throw new IllegalStateException("eventResponses is not set");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.addLong(out, this.eventId);
        Iterator<EventResponse> it = this.eventResponses.iterator();
        while (it.hasNext()) {
            EventResponse eventResponse = it.next();
            ResponseEncoder responseEncoder = ResponseEncoder.create((EventResponse)eventResponse);
            if (eventResponse.isUserACLChanged()) {
                // empty if block
            }
            out.write(responseEncoder.encode());
            if (!it.hasNext()) continue;
            out.write(responsePrefix);
        }
        return out.toByteArray();
    }
}

