/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.event.udp;

import de.proveo.wwt.logic.servlet.dataIn.event.udp.RequestPayloadFormat;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ASCIIRequestPayloadFormat
implements RequestPayloadFormat {
    private static final Log log = LogFactory.getLog(ASCIIRequestPayloadFormat.class);
    private static final int EVENT_TYPE_GZIP_COMPRESSION = 1;
    private static final byte[] eolPattern = new byte[]{10};
    private long eventId;
    private long unitId;
    private List<Properties> events;

    @Override
    public long getEventId() {
        return this.eventId;
    }

    @Override
    public long getUnitId() {
        return this.unitId;
    }

    @Override
    public List<Properties> getEvents() {
        return this.events;
    }

    @Override
    public void parse(byte[] payload, int length) throws IOException {
        int index = this.parseEventId(payload, length, 0);
        index = this.parseUnitId(payload, length, index);
        byte eventType = payload[index];
        if (length > ++index) {
            byte[] rawData;
            if ((eventType & 1) > 0) {
                GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(payload, index, length - index));
                rawData = IOUtils.toByteArray((InputStream)gzip);
            } else {
                rawData = new byte[length - index];
                System.arraycopy(payload, index, rawData, 0, length - index);
            }
            this.events = this.readEvents(rawData, eolPattern);
        } else {
            this.events = new ArrayList<Properties>();
            this.events.add(new Properties());
        }
        this.addBorrowedKeys(this.events.get(0));
    }

    protected void addBorrowedKeys(Properties event) {
        event.setProperty("t", Long.toString(this.eventId));
        if (event.containsKey("u2")) {
            event.setProperty("u1", Long.toString(this.unitId));
        } else {
            event.setProperty("u", Long.toString(this.unitId));
        }
    }

    public Properties readEvent(String eventStr) {
        StringTokenizer tokenizer = new StringTokenizer(eventStr, ";");
        return this.readProperties(tokenizer);
    }

    public Properties readProperties(StringTokenizer tokenizer) {
        Properties event = new Properties();
        while (tokenizer.hasMoreTokens()) {
            String keyValue = tokenizer.nextToken();
            int index = keyValue.indexOf(61);
            String key = keyValue.substring(0, index);
            String value = keyValue.substring(index + 1);
            event.put(key, value);
        }
        return event;
    }

    public static int indexOf(byte[] src, byte[] pattern, int from) {
        if (src == null || pattern == null) {
            throw new IllegalArgumentException("byte array and pattern can't be null");
        }
        if (from > src.length - 1 || from < 0) {
            throw new IllegalArgumentException("search index must be less than byte array size and greater than 0");
        }
        if (pattern.length == 0) {
            throw new IllegalArgumentException("pattern can't be empty");
        }
        int patternIndex = 0;
        for (int index = from; index < src.length; ++index) {
            if (src[index] == pattern[patternIndex]) {
                if (patternIndex < pattern.length - 1) {
                    ++patternIndex;
                    continue;
                }
                return index - patternIndex;
            }
            patternIndex = src[index] == pattern[0] ? 1 : 0;
        }
        return -1;
    }

    public List<Properties> readEvents(byte[] content, byte[] lineBreak) throws IOException {
        int index;
        if (log.isTraceEnabled()) {
            log.trace((Object)("content:\n" + new String(content)));
        }
        ArrayList<Properties> parsedEvents = new ArrayList<Properties>();
        int start = 0;
        do {
            String eventStr = (index = ASCIIRequestPayloadFormat.indexOf(content, lineBreak, start)) == -1 ? new String(content, start, content.length - start) : new String(content, start, index - start);
            Properties event = this.readEvent(eventStr);
            if (index < content.length - 3 && content[index + 1] == 10 && content[index + 2] == 10) {
                int endOfHeaderIndex = ASCIIRequestPayloadFormat.indexOf(content, lineBreak, index + 3);
                if (endOfHeaderIndex > -1) {
                    StringTokenizer headerTokenizer = new StringTokenizer(new String(content, index + 3, endOfHeaderIndex - (index + 3)));
                    Properties payloadHeaderProperties = this.readProperties(headerTokenizer);
                    int payloadLength = Integer.parseInt(payloadHeaderProperties.getProperty("length"));
                    byte[] payload = new byte[payloadLength];
                    System.arraycopy(content, endOfHeaderIndex + 1, payload, 0, payloadLength);
                    event.put("binary", payload);
                    index = endOfHeaderIndex + payloadLength;
                } else {
                    log.error((Object)"payload start found but no payload header line found");
                }
            }
            parsedEvents.add(event);
            start = index + 1;
            if (start <= content.length - 1) continue;
            index = -1;
        } while (index > -1);
        return parsedEvents;
    }

    protected int parseEventId(byte[] payload, int length, int index) {
        this.eventId = this.parseLong(payload, length, index);
        return index + 8;
    }

    protected int parseUnitId(byte[] payload, int length, int index) {
        this.unitId = this.parseLong(payload, length, index);
        return index + 8;
    }

    protected long parseLong(byte[] payload, int length, int index) {
        if (length - index - 8 < 0) {
            throw new IllegalArgumentException("unexpected length");
        }
        long value = payload[index + 0] << 56;
        value += (long)(payload[index + 1] & 0xFF) << 48;
        value += (long)(payload[index + 2] & 0xFF) << 40;
        value += (long)(payload[index + 3] & 0xFF) << 32;
        value += (long)(payload[index + 4] & 0xFF) << 24;
        value += (long)(payload[index + 5] & 0xFF) << 16;
        value += (long)(payload[index + 6] & 0xFF) << 8;
        return value += (long)(payload[index + 7] & 0xFF) << 0;
    }
}

