/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.event;

import de.proveo.eventbase.EventPayload;
import de.proveo.eventbase.EventResponse;
import de.proveo.eventbase.EventUtil;
import de.proveo.eventbase.codec.ResponseEncoder;
import de.proveo.rts.configuration.infoman.InfomanEventInterfaceMBean;
import de.proveo.rts.configuration.infoman.InfomanEventServiceMBean;
import de.proveo.rts.configuration.monitor.MonitoringMBean;
import de.proveo.util.service.ServiceFactory;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeRemote;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AbstractEventServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(AbstractEventServlet.class);
    private EventFacadeRemote eventFacade;
    protected InfomanEventInterfaceMBean config;
    private InfomanEventServiceMBean infomanEventService;
    private MonitoringMBean monitoringMBean;

    public void destroy() {
        this.eventFacade = null;
        this.monitoringMBean = null;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        log.error((Object)"missing implementation of doGet() in extending class !");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.error((Object)"missing implementation of doPost() in extending class !");
    }

    public void init(ServletConfig config) throws ServletException {
        log.debug((Object)"init()");
        super.init(config);
        try {
            InitialContext initialContext = new InitialContext();
            this.eventFacade = (EventFacadeRemote)initialContext.lookup("rts/EventFacade/remote");
            this.config = (InfomanEventInterfaceMBean)ServiceFactory.getInstance().getService(InfomanEventInterfaceMBean.class);
            this.infomanEventService = (InfomanEventServiceMBean)ServiceFactory.getInstance().getService(InfomanEventServiceMBean.class);
            this.monitoringMBean = this.createMonitoringMBean();
        }
        catch (Exception ex) {
            throw new ServletException("Cannot connect to EventFacade", (Throwable)ex);
        }
    }

    public MonitoringMBean getMonitoringMBean() {
        return this.monitoringMBean;
    }

    protected MonitoringMBean createMonitoringMBean() throws Exception {
        return null;
    }

    protected EventResponse handleEvent(Properties event) {
        try {
            return this.eventFacade.handleEvent(event);
        }
        catch (Exception e) {
            log.error((Object)"handleEvent() EventFacade.handleEvent() runs into", (Throwable)e);
            EventResponse eventResponse = new EventResponse();
            long[] unitIds = null;
            try {
                unitIds = EventUtil.getUnitIds((Properties)event);
            }
            catch (Exception ex) {
                log.error((Object)"handleEvent() runs during parse unitIds into", (Throwable)ex);
            }
            if (unitIds != null && this.infomanEventService.isAcceptErrorAndReset(unitIds)) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("accept error event " + event));
                }
                eventResponse.setEventResponse(true);
            } else {
                eventResponse.setEventResponse(false);
            }
            return eventResponse;
        }
    }

    public EventResponse processEvent(String remoteAddr, Properties event) {
        if (event.size() > 0) {
            String ping;
            if (log.isDebugEnabled()) {
                log.debug((Object)("processEvent() " + event + " from " + remoteAddr));
            }
            if ((ping = event.getProperty("p")) != null && ping.equals("servlet")) {
                EventResponse eventResponse = new EventResponse();
                eventResponse.setEventResponse(true);
                return eventResponse;
            }
            if (event.containsKey("u")) {
                long unitId = Long.parseLong(event.getProperty("u"));
                this.infomanEventService.putIpAddress(unitId, remoteAddr);
            }
            return this.handleEvent(event);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("processEvent() illegel request " + event + " from " + remoteAddr));
        }
        EventResponse eventResponse = new EventResponse();
        eventResponse.setEventResponse(false);
        return eventResponse;
    }

    protected ResponseEncoder encodeReturnMessage(EventResponse eventResponse, Properties event) {
        ResponseEncoder responseEncoder = ResponseEncoder.create((EventResponse)eventResponse);
        if (event.size() > 0 && eventResponse.isUserACLChanged()) {
            for (EventPayload payload : eventResponse.getPayloads()) {
                responseEncoder.addPayload(payload);
            }
        }
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder("sendResponse() [");
            long[] unitIds = EventUtil.getUnitIds((Properties)event);
            if (unitIds.length > 0) {
                msg.append("u=");
            } else {
                msg.append("hwsn=");
                msg.append(event.getProperty("hwsn"));
            }
            for (int index = 0; index < unitIds.length; ++index) {
                msg.append(unitIds[index]);
                if (index + 1 >= unitIds.length) continue;
                msg.append(",");
            }
            msg.append(" t=");
            msg.append(event.getProperty("t"));
            msg.append("]: ");
            msg.append(responseEncoder);
            log.debug((Object)msg.toString());
        }
        return responseEncoder;
    }

    protected void sendResponse(EventResponse eventResponse, Properties event, HttpServletResponse response) {
        ResponseEncoder responseEncoder = this.encodeReturnMessage(eventResponse, event);
        try {
            ServletOutputStream out = response.getOutputStream();
            out.write(responseEncoder.encode());
            out.close();
        }
        catch (IOException ex) {
            log.error((Object)"sendResponse() sending response runs into", (Throwable)ex);
            return;
        }
        this.resetFlags(eventResponse, event);
        log.debug((Object)"sendResponse() leave");
    }

    public void resetFlags(EventResponse eventResponse, Properties event) {
        if (event.size() > 0 && eventResponse.isVPN()) {
            this.eventFacade.resetCallback(event);
        }
    }

    protected boolean isRequestCompressed(HttpServletRequest request) {
        Enumeration e = request.getHeaders("Content-Encoding");
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.indexOf("uncompressed") <= -1) continue;
            return false;
        }
        return true;
    }

    protected boolean isPipeLineBreak(HttpServletRequest request) {
        Enumeration e = request.getHeaders("Content-Encoding");
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.indexOf("pipeLineBreak") <= -1) continue;
            return true;
        }
        return false;
    }
}

