/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.web.map.management;

import de.proveo.web.map.components.cache.DataCache;
import de.proveo.web.map.components.event.MapProxy;
import de.proveo.web.map.components.event.MapProxyFactory;
import de.proveo.wwt.logic.ejb.general.jms.JMSClient;
import de.proveo.wwt.logic.ejb.general.jms.JMSMessageListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapManagement
extends JMSMessageListener {
    private static final Log log = LogFactory.getLog(MapManagement.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        try {
            if (message instanceof ObjectMessage) {
                ObjectMessage oMessage = (ObjectMessage)message;
                Serializable _object = oMessage.getObject();
                if (_object != null) {
                    String maintenanceMsg = _object.toString();
                    log.debug((Object)"Message received!");
                    this.handleMsg(maintenanceMsg);
                } else {
                    log.error((Object)"Could not handle message. Object of ObjectMessage was null.");
                }
            } else {
                log.error((Object)("Could not handle message. Message isn't an instance of ObjectMessage. Message=" + message));
            }
        }
        catch (JMSException e) {
            log.error((Object)"onMessage runs into: ", (Throwable)e);
        }
        finally {
            message = null;
        }
    }

    private void handleMsg(String maintenanceMsg) {
        if (maintenanceMsg.startsWith("CloseSingleConnection")) {
            String clientID = maintenanceMsg.replace("CloseSingleConnection", "");
            this.closeConnection(MapProxyFactory.getInstance().getMapProxyByID(clientID));
        } else if (maintenanceMsg.startsWith("UpdateSingleClient")) {
            String clientID = maintenanceMsg.replace("UpdateSingleClient", "");
            this.updateClient(clientID);
        } else if (maintenanceMsg.startsWith("CloseAllConnections")) {
            this.closeAllConnections();
        } else if (maintenanceMsg.startsWith("UpdateAllClients")) {
            this.updateAllClients();
        } else if (maintenanceMsg.startsWith("UpdateServerCache")) {
            this.updateServerCache();
        } else {
            log.error((Object)("JMS Message unknown: " + maintenanceMsg));
        }
    }

    private void updateServerCache() {
        log.debug((Object)"AirportMapMaintenance: Server cache will be updated!");
        DataCache.getInstance().updateBulkData();
    }

    private void updateAllClients() {
        log.debug((Object)"AirportMapMaintenance: All clients will be updated!");
        ConcurrentHashMap<String, MapProxy> clientPool = MapProxyFactory.getInstance().getMapProxyPool();
        Iterator it = clientPool.values().iterator();
        while (it.hasNext()) {
            ((MapProxy)((Object)it.next())).scheduleNextBulkUpate();
        }
    }

    private void closeAllConnections() {
        log.debug((Object)"AirportMapMaintenance: All airport map connections will be closed!");
        ConcurrentHashMap<String, MapProxy> clientPool = MapProxyFactory.getInstance().getMapProxyPool();
        Iterator it = clientPool.values().iterator();
        while (it.hasNext()) {
            this.closeConnection((MapProxy)((Object)it.next()));
        }
    }

    private void updateClient(String clientID) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AirportMapMaintenance: Client " + clientID + " will be updated!"));
        }
        try {
            MapProxyFactory.getInstance().getMapProxyByID(clientID).scheduleNextBulkUpate();
        }
        catch (Throwable e) {
            log.error((Object)("ClientID '" + clientID + "' doesn't exist!"), e);
        }
    }

    private void closeConnection(MapProxy mapProxy) {
        if (mapProxy != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("AirportMapMaintenance: Client " + mapProxy.getClientName() + " will be closed!"));
            }
            MapProxyFactory.getInstance().removeProxy(mapProxy);
        }
    }

    public void setJMSClient(JMSClient client) {
    }
}

