/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.web.map.components.masterdata;

import de.proveo.util.observable.wrapper.PermissionVO;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.web.map.components.cache.DataCache;
import de.proveo.web.map.components.event.MapProxy;
import de.proveo.web.map.components.event.MapProxyFactory;
import de.proveo.wwt.datamodel.resourceString.ResourceString;
import de.proveo.wwt.datamodel.stateModel.State;
import de.proveo.wwt.datamodel.stateModel.StateModel;
import de.proveo.wwt.datamodel.unit.typeIdentity.UnitTypeIdentity;
import de.proveo.wwt.logic.ejb.general.jms.JMSClient;
import de.proveo.wwt.logic.ejb.general.jms.JMSMessageListener;
import de.proveo.wwt.logic.ejb.stateModel.StateModelFacadeRemote;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MasterdataHandler
extends JMSMessageListener {
    private static final Log log = LogFactory.getLog(MasterdataHandler.class);
    private static final Set<Integer> ACTIVE_STATE_MODELS_CACHE = new HashSet<Integer>();
    private StateModelFacadeRemote stateModelFacade = null;

    public MasterdataHandler() {
        try {
            InitialContext context = new InitialContext();
            this.stateModelFacade = (StateModelFacadeRemote)context.lookup("rts/StateModelFacade/remote");
            List activeStateModels = this.stateModelFacade.getActiveStateModels();
            int size = activeStateModels.size();
            for (int i = 0; i < size; ++i) {
                StateModel stateModel = (StateModel)activeStateModels.get(i);
                ACTIVE_STATE_MODELS_CACHE.add(stateModel.getId());
            }
            log.debug((Object)("Active state models cache initialized. Cache size: " + ACTIVE_STATE_MODELS_CACHE.size()));
        }
        catch (NamingException e) {
            log.error((Object)"StateModelListener.init() runs into NamingException", (Throwable)e);
        }
    }

    private PermissionVO checkClient(List<PermissionVO> permissionVOList, MapProxy mapProxy) {
        for (PermissionVO permissionVO : permissionVOList) {
            if (permissionVO.getUserName().equals(mapProxy.getUsername()) || permissionVO.isUnitsMoved()) {
                return permissionVO;
            }
            if (permissionVO.getUnitID() <= 0L) continue;
            return mapProxy.getUnitEventHandler().hasPermissionForUnitID(permissionVO.getUnitID()) ? permissionVO : null;
        }
        return null;
    }

    private void checkForAPMapFlagChanges(List<PermissionVO> permissionVOList) {
        for (int i = 0; i < permissionVOList.size(); ++i) {
            Long unitID;
            PermissionVO permissionVO = permissionVOList.get(i);
            if (permissionVO == null || (unitID = this.isAirportMapFlagSet(permissionVO)) == null) continue;
            DataCache.getInstance().setAPMapFlagByUnitID(unitID, permissionVO.isAirportMapVisible());
        }
    }

    private void initUnitClientBulkUpdate(MapProxy mapProxy) {
        mapProxy.getUnitEventHandler().scheduleNextBulkUpdate();
    }

    private Long isAirportMapFlagSet(PermissionVO permissionVO) {
        return permissionVO.isAirportMapFlagSet() ? permissionVO.getUnitID() : null;
    }

    public void onMessage(Message message) {
        log.debug((Object)"New update of permission settings received!");
        try {
            if (message != null && message instanceof ObjectMessage) {
                Serializable object = ((ObjectMessage)message).getObject();
                if (object != null && object instanceof SerializableEventWrapper) {
                    SerializableEventWrapper event = (SerializableEventWrapper)object;
                    this.updateClientView(event);
                } else {
                    log.warn((Object)("MasterdataHandler received a ObjectMessage with a non SerializableEventWrapper as object: " + object));
                }
            } else {
                log.warn((Object)("MasterdataHandler received a non ObjectMessage: " + message));
            }
        }
        catch (JMSException e) {
            log.error((Object)"onMessage runs into JMSException: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownAirportMap(MapProxy mapProxy, ShutdownReason reason) {
        HashMap<String, String> eventMap = new HashMap<String, String>();
        eventMap.put("DataType", "data_type_server_messages");
        if (reason == ShutdownReason.USER_DELETED) {
            eventMap.put("ServerMessage", "ServerMessageUserDeleted");
        } else if (reason == ShutdownReason.USER_BLOCKED) {
            eventMap.put("ServerMessage", "ServerMessageBlockOutUser");
        } else if (reason == ShutdownReason.ROLE_CHANGED) {
            eventMap.put("ServerMessage", "ServerMessageRoleChanged");
        } else if (reason == ShutdownReason.PASSWORD_CHANGED) {
            eventMap.put("ServerMessage", "ServerMessagePwUserChanged");
        } else {
            log.error((Object)("Got unhandled ShutdownReason: '" + (Object)((Object)reason) + "'. Disconnect without informing client!"));
            MapProxyFactory.getInstance().removeProxy(mapProxy);
            return;
        }
        try {
            mapProxy.sendResponse(eventMap);
        }
        finally {
            MapProxyFactory.getInstance().removeProxy(mapProxy);
        }
    }

    private void updateClientView(SerializableEventWrapper event) {
        ArrayList<Long> listAffectedUnitIds = new ArrayList();
        String eventType = event.get_typeOfEvent();
        if (eventType.equals("UnitTypeNotifyMessage")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"updateClientView () - Event type: UnitTypeNotifyMessage");
            }
            UnitTypeIdentity unitType = (UnitTypeIdentity)event.getUnitTypeValue();
            listAffectedUnitIds = event.getLongList();
            DataCache.getInstance().setChangedUnitType(unitType, listAffectedUnitIds);
        } else if (eventType.equals("UnitNotifyMessage") || eventType.equals("UnitNotifyMapflagMessage")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"updateClientView () - Event type: UnitNotifyMessage or UnitNotifyMapflagMessage");
            }
            List list = event.getValueList();
            listAffectedUnitIds = DataCache.getInstance().setChangedUnit(list);
        } else if (eventType.equals("UnitDeletedChangedNotifyMessage")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"updateClientView () - Event type: UnitDeletedChangedNotifyMessage");
            }
            List list = event.getValueList();
            for (int i = 0; i < list.size(); ++i) {
                UnitDTO unitDTO = (UnitDTO)list.get(i);
                long unitId = unitDTO.getUnitId();
                DataCache.getInstance().setDeletedFlagByUnitID(unitId, unitDTO.isDeleted());
                listAffectedUnitIds.add(unitId);
            }
        } else if (eventType.equals("StateModelCreateMessage")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"updateClientView () - Event type: StateModelCreateMessage");
            }
            Object object = event.getUnitTypeValue();
            boolean updateClient = false;
            Map<Integer, Boolean> affectedStateModels = this.getRelatedStateModels(object);
            for (int smId : affectedStateModels.keySet()) {
                Boolean smIsActive = affectedStateModels.get(smId);
                Boolean smWasActive = ACTIVE_STATE_MODELS_CACHE.contains(smId);
                if (object instanceof StateModel) {
                    smIsActive = null;
                }
                if (!updateClient) {
                    updateClient = this.isClientUpdateNeeded(smWasActive, smIsActive);
                }
                this.updateCache(smId, smWasActive, smIsActive);
            }
            if (!updateClient) {
                return;
            }
        } else if (eventType.equals("StateModelUpdateMessage")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"updateClientView () - Event type: StateModelUpdateMessage");
            }
            Object object = event.getUnitTypeValue();
            boolean updateClient = false;
            Map<Integer, Boolean> affectedStateModels = this.getRelatedStateModels(object);
            for (int smId : affectedStateModels.keySet()) {
                Boolean smIsActive = affectedStateModels.get(smId);
                Boolean smWasActive = ACTIVE_STATE_MODELS_CACHE.contains(smId);
                if (!updateClient) {
                    updateClient = this.isClientUpdateNeeded(smWasActive, smIsActive);
                }
                this.updateCache(smId, smWasActive, smIsActive);
            }
            if (!updateClient) {
                return;
            }
        } else if (eventType.equals("StateModelRemoveMessage")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"updateClientView () - Event type: StateModelRemoveMessage");
            }
            Object object = event.getUnitTypeValue();
            boolean updateClient = false;
            Map<Integer, Boolean> affectedStateModels = this.getRelatedStateModels(object);
            for (int smId : affectedStateModels.keySet()) {
                Boolean smIsActive = affectedStateModels.get(smId);
                Boolean smWasActive = ACTIVE_STATE_MODELS_CACHE.contains(smId);
                if (object instanceof StateModel) {
                    smIsActive = null;
                }
                if (!updateClient) {
                    updateClient = this.isClientUpdateNeeded(smWasActive, smIsActive);
                }
                this.updateCache(smId, smWasActive, smIsActive);
            }
            if (!updateClient) {
                return;
            }
        } else if (eventType.equals("MeasurementCreateMessage")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"updateClientView () - Event type: MeasurementCreateMessage");
            }
        } else if (eventType.equals("MeasurementUpdateMessage")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"updateClientView () - Event type: MeasurementUpdateMessage");
            }
        } else if (eventType.equals("MeasurementRemoveMessage")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"updateClientView () - Event type: MeasurementRemoveMessage");
            }
        } else if (eventType.equals("ViewPermissionUpdateMessage")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"updateClientView () - Event type: ViewPermissionUpdateMessage");
            }
            List permissionVOList = event.getPermissionVOList();
            this.checkForAPMapFlagChanges(permissionVOList);
        }
        this.updateClients(event, listAffectedUnitIds);
    }

    private void updateClients(SerializableEventWrapper event, List<Long> listAffectedUnitIds) {
        String eventType = event.get_typeOfEvent();
        ConcurrentHashMap<String, MapProxy> clientPool = MapProxyFactory.getInstance().getMapProxyPool();
        if (clientPool.isEmpty()) {
            return;
        }
        for (MapProxy mapProxy : clientPool.values()) {
            if (eventType.equals("StateModelCreateMessage") || eventType.equals("StateModelUpdateMessage") || eventType.equals("StateModelRemoveMessage")) {
                this.initUnitClientBulkUpdate(mapProxy);
                continue;
            }
            if (eventType.equals("MeasurementCreateMessage") || eventType.equals("MeasurementUpdateMessage") || eventType.equals("MeasurementRemoveMessage")) {
                this.initUnitClientBulkUpdate(mapProxy);
                continue;
            }
            if (eventType.equals("ViewPermissionUpdateMessage")) {
                List permissionVOList = event.getPermissionVOList();
                PermissionVO permissionVO = this.checkClient(permissionVOList, mapProxy);
                if (permissionVO == null) continue;
                if (permissionVO.isUserDeleted()) {
                    this.shutdownAirportMap(mapProxy, ShutdownReason.USER_DELETED);
                    continue;
                }
                if (permissionVO.isBlockOutUser()) {
                    this.shutdownAirportMap(mapProxy, ShutdownReason.USER_BLOCKED);
                    continue;
                }
                if (permissionVO.isUserPwChanged()) {
                    this.shutdownAirportMap(mapProxy, ShutdownReason.PASSWORD_CHANGED);
                    continue;
                }
                if (permissionVO.isRoleChanged()) {
                    this.shutdownAirportMap(mapProxy, ShutdownReason.ROLE_CHANGED);
                    continue;
                }
                this.initUnitClientBulkUpdate(mapProxy);
                continue;
            }
            if (!eventType.equals("UnitDeletedChangedNotifyMessage") && !mapProxy.getUnitEventHandler().isAffectedFromChangedUnitType(listAffectedUnitIds) && !eventType.equals("UnitNotifyMapflagMessage")) continue;
            if (eventType.equals("UnitNotifyMessage") || eventType.equals("UnitNotifyMapflagMessage") || eventType.equals("UnitDeletedChangedNotifyMessage")) {
                if (listAffectedUnitIds == null) continue;
                for (int i = 0; i < listAffectedUnitIds.size(); ++i) {
                    Long unitId = listAffectedUnitIds.get(i);
                    if (unitId == null) continue;
                    mapProxy.getUnitEventHandler().sendStampToClient(unitId);
                }
                continue;
            }
            if (!eventType.equals("UnitTypeNotifyMessage")) continue;
            this.initUnitClientBulkUpdate(mapProxy);
        }
    }

    public void setJMSClient(JMSClient client) {
    }

    private Map<Integer, Boolean> getRelatedStateModels(Object object) {
        HashMap<Integer, Boolean> possibleStateModels = new HashMap<Integer, Boolean>();
        if (object == null) {
            return possibleStateModels;
        }
        if (object instanceof StateModel) {
            StateModel stateModel = (StateModel)object;
            possibleStateModels.put(stateModel.getId(), stateModel.isActive());
        } else if (object instanceof State) {
            State state = (State)object;
            int smId = state.getStateModelId();
            possibleStateModels.put(smId, this.stateModelFacade.isStateModelActive(smId));
        } else if (object instanceof ResourceString) {
            ResourceString resource = (ResourceString)object;
            String key = resource.getPk();
            if (key.contains(".")) {
                String[] keyParts = StringUtils.split((String)key, (String)".");
                String type = keyParts[0];
                String idString = keyParts[keyParts.length - 1];
                int id = -1;
                try {
                    id = Integer.parseInt(idString);
                }
                catch (Throwable ex) {
                    return possibleStateModels;
                }
                if (type.equals("state")) {
                    Map stateModelMap = this.stateModelFacade.getStateModelMap();
                    Iterator ite = stateModelMap.keySet().iterator();
                    while (ite.hasNext()) {
                        int smId = (Integer)ite.next();
                        List statesList = (List)stateModelMap.get(smId);
                        if (!statesList.contains(id)) continue;
                        possibleStateModels.put(smId, this.stateModelFacade.isStateModelActive(smId));
                    }
                } else if (type.equals("stateModel")) {
                    possibleStateModels.put(id, this.stateModelFacade.isStateModelActive(id));
                } else {
                    log.warn((Object)("Found changed resource for state model which is neither a state nor a state model resource: ResourcePK=" + key));
                }
            }
        } else {
            log.warn((Object)("Can not get related state model for given object: " + object));
        }
        return possibleStateModels;
    }

    private boolean isClientUpdateNeeded(Boolean previouslyActive, Boolean currentlyActive) {
        if (currentlyActive == null && previouslyActive == null) {
            return false;
        }
        if (currentlyActive == null) {
            return previouslyActive;
        }
        if (previouslyActive == null) {
            return currentlyActive;
        }
        if (currentlyActive.booleanValue()) {
            return true;
        }
        return previouslyActive;
    }

    private void updateCache(int smId, Boolean smWasActive, Boolean smIsActive) {
        if (smIsActive != null && smIsActive.booleanValue() && (smWasActive == null || !smWasActive.booleanValue())) {
            ACTIVE_STATE_MODELS_CACHE.add(smId);
        } else if ((smIsActive == null || !smIsActive.booleanValue()) && smWasActive != null && smWasActive.booleanValue()) {
            ACTIVE_STATE_MODELS_CACHE.remove(smId);
        }
    }

    public static enum ShutdownReason {
        USER_DELETED,
        USER_BLOCKED,
        ROLE_CHANGED,
        PASSWORD_CHANGED;

    }
}

