/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.web.map.components.event.unit;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.web.map.components.cache.DataCache;
import de.proveo.web.map.components.event.AbstractEventHandler;
import de.proveo.web.map.components.event.MapProxy;
import de.proveo.web.map.components.event.MapProxyFactory;
import de.proveo.web.map.util.MapUtil;
import de.proveo.wwt.logic.app.security.LoginContextUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnitEventHandler
extends AbstractEventHandler {
    private static final Log log = LogFactory.getLog(UnitEventHandler.class);
    private static final String EVENT_HANDLER_NAME = "UnitEventHandler";
    private HashSet<Long> unitPermissions = new HashSet();
    private final Object unitPermissionsLock = new Object();
    private boolean notifyPermissions = false;
    private boolean infomanMessagesNeeded = false;
    private boolean notifyMessagesNeeded = false;
    private boolean useMessagesNeeded = false;
    private String username = null;
    private String password = null;
    private long unitGroupId = -1L;
    private LoginContextUtil loginContextUtil;
    private boolean admin = false;
    private boolean superAdmin = false;
    private boolean sendingBulk = false;
    private final Object sendingBulkLock = new Object();
    private boolean sendingSingleBulk = false;
    private final Object sendingSingleBulkLock = new Object();

    public UnitEventHandler(MapProxy mapProxy) {
        super(mapProxy);
        String method = "ClientID='" + this.clientName + "' -> UnitEventHandler(): ";
        this.username = this.mapProxy.getUsername();
        this.password = this.mapProxy.getPassword();
        this.unitGroupId = this.mapProxy.getUnitGroupId();
        this.updateClientPermissions(this.unitGroupId);
        try {
            this.notifyPermissions = this.getNotifyPermission();
        }
        catch (Throwable e) {
            log.error((Object)(method + "Error occured while checking notify permissions!"), e);
        }
        String selector = this.mapProxy.getSelector();
        this.infomanMessagesNeeded = selector.indexOf("InfomanMessages") != -1;
        this.notifyMessagesNeeded = selector.indexOf("InfomanNotifyMessages") != -1 && this.notifyPermissions;
        this.useMessagesNeeded = selector.indexOf("UseEvent") != -1;
        this.superAdmin = this.isSuperAdmin();
        this.admin = this.superAdmin ? true : this.isAdmin();
    }

    private boolean isAdmin() {
        String method = "ClientID='" + this.clientName + "' -> isAdmin(): ";
        boolean isAdmin = false;
        if (this.loginContextUtil == null) {
            try {
                this.loginContextUtil = new LoginContextUtil(this.username, this.password);
                this.loginContextUtil.fetchPermissions();
            }
            catch (Throwable ex) {
                log.error((Object)(method + "LoginContextUtil runs into"), ex);
            }
        }
        if (this.loginContextUtil != null) {
            isAdmin = this.loginContextUtil.isAccessPermitted() && (this.loginContextUtil.isSuperAdmin() || this.loginContextUtil.isUserInRole("section.airportmap_admin"));
        }
        return isAdmin;
    }

    private boolean isSuperAdmin() {
        String method = "ClientID='" + this.clientName + "' -> isSuperAdmin(): ";
        boolean isSuperAdmin = false;
        if (this.loginContextUtil == null) {
            try {
                this.loginContextUtil = new LoginContextUtil(this.username, this.password);
                this.loginContextUtil.fetchPermissions();
            }
            catch (Throwable ex) {
                log.error((Object)(method + "LoginContextUtil runs into"), ex);
            }
        }
        if (this.loginContextUtil != null) {
            isSuperAdmin = this.loginContextUtil.isAccessPermitted() && this.loginContextUtil.isSuperAdmin();
        }
        return isSuperAdmin;
    }

    private void checkDataAvailability() {
        String method = "ClientID='" + this.clientName + "' -> checkDataAvailability(): ";
        boolean dataAvailable = DataCache.getInstance().isUnitCacheDataLoaded();
        while (!dataAvailable) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(method + "No data available, yet."));
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                log.error((Object)(method + "runs into InterruptedException"), (Throwable)e);
            }
            dataAvailable = DataCache.getInstance().isUnitCacheDataLoaded();
        }
    }

    @Override
    public String getName() {
        return EVENT_HANDLER_NAME;
    }

    @Override
    public String getSelectorName() {
        return "units";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean cleanUp() {
        this.loginContextUtil = null;
        Object object = this.unitPermissionsLock;
        synchronized (object) {
            if (this.unitPermissions != null) {
                this.unitPermissions.clear();
                this.unitPermissions = null;
            }
        }
        return super.cleanUp();
    }

    @Override
    public Map<String, Object> handleMessage(SerializableEventWrapper eventWrapper) {
        String method = "ClientID='" + this.clientName + "' -> handleMessage(): ";
        Map<String, Object> eventMap = MapUtil.getInstance().createFittingUnitEventMap(eventWrapper);
        if (eventMap == null) {
            return null;
        }
        boolean permission = this.checkPermission(eventMap);
        if (!permission) {
            return null;
        }
        long unitID = (Long)eventMap.get("UnitId");
        if (!DataCache.getInstance().isVisible(unitID)) {
            return null;
        }
        MapUtil.getInstance().mapPutNullCheck(eventMap, "DataType", "SingleUnitEvent", false);
        return eventMap;
    }

    @Override
    protected void initProcessableEventTypes() {
        this.processableEventTypes = new HashSet();
        this.processableEventTypes.add("KeepAlive");
        this.processableEventTypes.add("GeoStructHistoryAndCache");
        this.processableEventTypes.add("StateEventHistoryAndCache");
        this.processableEventTypes.add("MeasurementHistoryAndCache");
        this.processableEventTypes.add("InfomanMessages");
        this.processableEventTypes.add("InfomanNotifyMessages");
        this.processableEventTypes.add("UseEvent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClientPermissions(long unitId) {
        String method = "ClientID='" + this.clientName + "' -> updateClientPermissions(): ";
        Object object = this.unitPermissionsLock;
        synchronized (object) {
            try {
                this.unitPermissions = DataCache.getInstance().getUnitPermissions(this.username, this.superAdmin, unitId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(method + "Permissions for user " + this.username + " updated!"));
                }
            }
            catch (Throwable ex) {
                log.error((Object)(method + "Could not update permissions for user " + this.username), ex);
                this.unitPermissions = new HashSet();
            }
        }
    }

    private boolean checkPermission(Map<String, Object> eventMap) {
        boolean containsUnitPermission = false;
        long unitID = (Long)eventMap.get("UnitId");
        if (this.hasPermissionForUnitID(unitID)) {
            containsUnitPermission = true;
            String eventType = (String)eventMap.get("EventType");
            if (eventType.equals("data_type_notification_event") && !this.notifyPermissions) {
                containsUnitPermission = false;
            }
        }
        return containsUnitPermission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPermissionForUnitID(Long unitID) {
        Object object = this.unitPermissionsLock;
        synchronized (object) {
            return this.unitPermissions.contains(unitID);
        }
    }

    private boolean getNotifyPermission() throws Exception {
        String method = "ClientID='" + this.clientName + "' -> getNotifyPermission(): ";
        boolean notifyPermission = false;
        this.loginContextUtil = new LoginContextUtil(this.username, this.password);
        this.loginContextUtil.fetchPermissions();
        if (this.loginContextUtil.isAccessPermitted()) {
            if (this.loginContextUtil.isSuperAdmin()) {
                notifyPermission = true;
            } else if (this.loginContextUtil.isUserInRole("section.airportmap.notification")) {
                notifyPermission = true;
            }
        }
        if (log.isDebugEnabled()) {
            if (notifyPermission) {
                log.debug((Object)(method + "client has notify permissions."));
            } else {
                log.debug((Object)(method + "client has NO notify permissions."));
            }
        }
        return notifyPermission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void sendAllBulkDataToClient() throws Exception {
        String method = "ClientID='" + this.clientName + "' -> sendAllBulkDataToClient(): ";
        this.lastBulkUpdate = System.currentTimeMillis();
        this.updateClientPermissions(this.unitGroupId);
        if (!this.isShuttingDown()) {
            log.debug((Object)(method + "Start ..."));
            this.setSendingBulk(true);
            try {
                HashSet<Long> permissions;
                this.setEventBufferActive(true);
                this.checkDataAvailability();
                Object object = this.unitPermissionsLock;
                synchronized (object) {
                    permissions = new HashSet<Long>(this.unitPermissions);
                }
                Map<Long, Map<String, Object>> allStamps = DataCache.getInstance().getAllPermittedCachedStamps(permissions, this.infomanMessagesNeeded, this.notifyMessagesNeeded, this.useMessagesNeeded);
                log.debug((Object)(method + "All data has been fetched from DataCache!"));
                HashMap<String, Object> data = new HashMap<String, Object>();
                MapUtil.getInstance().addTreeData(data, permissions, this.unitGroupId, this.isAdmin());
                MapUtil.getInstance().addServerData(data);
                MapUtil.getInstance().addXMLData(data, this.mapProxy.getNamespacesAndParameters());
                MapUtil.getInstance().mapPutNullCheck(data, "DataType", "units", false);
                if (allStamps.isEmpty()) {
                    log.warn((Object)(method + "Unit stamps are empty! User may have no unit permissions."));
                }
                MapUtil.getInstance().mapPutNullCheck(data, "Stamps", allStamps, false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(method + "Prepare finished --> Start sending to the Client."));
                }
                this.sendMessageToClient(data);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(method + "Sending all stamps finished."));
                }
                this.setSendingBulk(false);
                if (this.isSendingSingleBulk()) return;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(method + "Finally sending buffer content..."));
                }
                this.sendEventBufferToClient();
                return;
            }
            catch (Exception ex) {
                this.setSendingBulk(false);
                throw ex;
            }
        }
        log.warn((Object)(method + "Client is marked for Shutdown."));
    }

    public boolean isAffectedFromChangedUnitType(List<Long> listAffectedUnitIds) {
        for (int index = 0; index < listAffectedUnitIds.size(); ++index) {
            Long unitId = listAffectedUnitIds.get(index);
            if (unitId == null || !this.hasPermissionForUnitID((long)unitId)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendStampToClient(long unitId) {
        String method = "ClientID='" + this.clientName + "' -> sendStampToClient(" + unitId + "): ";
        this.updateClientPermissions(this.unitGroupId);
        if (!this.isShuttingDown()) {
            HashMap<String, Object> mcr = new HashMap<String, Object>();
            Map<String, Object> stamp = null;
            try {
                HashSet<Long> permissions;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(method + "start ..."));
                }
                this.setSendingSingleBulk(true);
                this.setEventBufferActive(true);
                this.checkDataAvailability();
                Object object = this.unitPermissionsLock;
                synchronized (object) {
                    permissions = new HashSet<Long>(this.unitPermissions);
                }
                if (this.hasPermissionForUnitID(unitId)) {
                    stamp = DataCache.getInstance().getCachedStamp(unitId, this.infomanMessagesNeeded, this.notifyMessagesNeeded, this.useMessagesNeeded);
                }
                if (stamp == null) {
                    MapUtil.getInstance().mapPutNullCheck(mcr, "UnitId", unitId, false);
                } else {
                    MapUtil.getInstance().mapPutNullCheck(mcr, "Stamp", stamp, false);
                }
                MapUtil.getInstance().mapPutNullCheck(mcr, "DataType", "unit", false);
                MapUtil.getInstance().mapPutNullCheck(mcr, "EventType", "unit", false);
                MapUtil.getInstance().addTreeData(mcr, permissions, this.unitGroupId, this.admin);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(method + "Prepare finished --> Start sending to the Client."));
                }
                if (!this.isSendingBulk()) {
                    this.sendMessageToClient(mcr);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(method + "stamp sent to client!"));
                    }
                } else {
                    this.addEventToEventBuffer(mcr);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(method + "stamp added to buffer!"));
                    }
                }
                this.setSendingSingleBulk(false);
                if (!this.isSendingBulk()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(method + "Finally sending buffer content..."));
                    }
                    this.sendEventBufferToClient();
                }
            }
            catch (IOException e) {
                this.setSendingSingleBulk(false);
                log.error((Object)(method + "runs into IOException! Problems while building unit tree! Shutdown client ..."), (Throwable)e);
                MapProxyFactory.getInstance().removeProxy(this.mapProxy);
            }
        } else {
            log.warn((Object)(method + "Client is marked for Shutdown."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSendingBulk() {
        Object object = this.sendingBulkLock;
        synchronized (object) {
            return this.sendingBulk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSendingBulk(boolean sendingBulk) {
        Object object = this.sendingBulkLock;
        synchronized (object) {
            this.sendingBulk = sendingBulk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSendingSingleBulk() {
        Object object = this.sendingSingleBulkLock;
        synchronized (object) {
            return this.sendingSingleBulk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSendingSingleBulk(boolean sendingSingleBulk) {
        Object object = this.sendingSingleBulkLock;
        synchronized (object) {
            this.sendingSingleBulk = sendingSingleBulk;
        }
    }
}

