/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.web.map.components.event.fis;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.web.map.components.cache.DataCache;
import de.proveo.web.map.components.event.AbstractEventHandler;
import de.proveo.web.map.components.event.MapProxy;
import de.proveo.web.map.util.MapUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FISEventHandler
extends AbstractEventHandler {
    private static final Log log = LogFactory.getLog(FISEventHandler.class);
    private static final String EVENT_HANDLER_NAME = "FISEventHandler";

    public FISEventHandler(MapProxy mapProxy) {
        super(mapProxy);
    }

    @Override
    public String getName() {
        return EVENT_HANDLER_NAME;
    }

    @Override
    public String getSelectorName() {
        return "stands";
    }

    private void checkDataAvailability() {
        String method = "ClientID='" + this.clientName + "' -> checkDataAvailability(): ";
        if (!MapUtil.getInstance().isStandsLogicEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(method + "Cannot check data availability, stand logic is disabled."));
            }
            return;
        }
        boolean dataAvailable = DataCache.getInstance().isStandCacheDataLoaded();
        while (!dataAvailable) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(method + "No data available, yet."));
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                log.error((Object)(method + "runs into InterruptedException"), (Throwable)e);
            }
            dataAvailable = DataCache.getInstance().isStandCacheDataLoaded();
        }
    }

    @Override
    public Map<String, Object> handleMessage(SerializableEventWrapper eventWrapper) {
        String method = "ClientID='" + this.clientName + "' -> handleMessage(): ";
        Map<String, Object> eventMap = MapUtil.getInstance().createFittingStandEventMap(eventWrapper);
        if (eventMap == null) {
            return null;
        }
        MapUtil.getInstance().mapPutNullCheck(eventMap, "DataType", "data_type_SingleStandEvent", false);
        return eventMap;
    }

    @Override
    protected void initProcessableEventTypes() {
        this.processableEventTypes = new HashSet();
        this.processableEventTypes.add("StandEvent");
    }

    @Override
    public void sendAllBulkDataToClient() throws Exception {
        String method = "ClientID='" + this.clientName + "' -> sendAllBulkDataToClient(): ";
        this.lastBulkUpdate = System.currentTimeMillis();
        if (!this.isShuttingDown()) {
            log.debug((Object)(method + "Start ..."));
            this.setEventBufferActive(true);
            this.checkDataAvailability();
            Map<String, Map<String, Object>> allStands = DataCache.getInstance().getAllPermittedCachedStands();
            log.debug((Object)(method + "All data has been fetched from DataCache!"));
            HashMap<String, Object> data = new HashMap<String, Object>();
            MapUtil.getInstance().addServerData(data);
            MapUtil.getInstance().mapPutNullCheck(data, "DataType", "data_type_stands", false);
            MapUtil.getInstance().mapPutNullCheck(data, "ALL_STANDS", allStands, false);
            this.sendMessageToClient(data);
            if (allStands == null) {
                this.sendMsgAboutDeactivatedFISServer();
                log.error((Object)(method + "Stands server logic is deactivated but a client tries to retrieve FIS data!"));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)(method + "All stands sent to client!"));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(method + "Finally sending buffer content..."));
            }
            this.sendEventBufferToClient();
        } else {
            log.warn((Object)(method + "Client is marked for Shutdown."));
        }
    }

    private void sendMsgAboutDeactivatedFISServer() {
        HashMap<String, Object> eventMap = new HashMap<String, Object>();
        MapUtil.getInstance().mapPutNullCheck(eventMap, "DataType", "data_type_server_messages", false);
        MapUtil.getInstance().mapPutNullCheck(eventMap, "ServerMessage", "ServerMessageFISDeactivated", false);
        this.sendMessageToClient(eventMap);
    }
}

