/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.web.map.components.event;

import de.proveo.rts.configuration.map.AirportMapMBean;
import de.proveo.util.service.ServiceFactory;
import de.proveo.util.service.ServiceInstantiationException;
import de.proveo.util.service.ServiceNotFoundException;
import de.proveo.web.map.communication.stream.HTTPConnection;
import de.proveo.web.map.components.event.MapProxy;
import de.proveo.web.map.components.event.MapProxyFactory;
import de.proveo.web.map.util.MapUtil;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapServlet
extends HttpServlet {
    private static final long serialVersionUID = 6912602153837173070L;
    private static final Log log = LogFactory.getLog(MapServlet.class);
    private AirportMapMBean airportMapConfig;

    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("destroy() is called! --> Instance: " + ((Object)((Object)this)).toString()));
            log.debug((Object)"Servlet instance removed.");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String method = "doGet(): ";
        log.warn((Object)(method + "avoid GET, use POST instead!"));
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block9: {
            String method = "doPost(): ";
            if (log.isDebugEnabled()) {
                log.debug((Object)(method + "POST started for instance " + ((Object)((Object)this)).toString() + " (Thread: " + Thread.currentThread().toString() + ")"));
            }
            if (this.airportMapConfig.isClientsDisabled()) {
                block8: {
                    try {
                        response.sendError(503);
                    }
                    catch (Throwable ex) {
                        if (!log.isDebugEnabled()) break block8;
                        log.debug((Object)"Could not send error code response to client, maybe the client is already closed or corrupted connection?!");
                    }
                }
                return;
            }
            try {
                this.createClient(request, response);
                log.debug((Object)(method + "POST finished for instance " + ((Object)((Object)this)).toString()));
            }
            catch (Throwable e) {
                log.fatal((Object)"Server was not able to create a client for the airport map!", e);
                try {
                    response.sendError(503);
                }
                catch (Throwable ex) {
                    if (!log.isDebugEnabled()) break block9;
                    log.debug((Object)"Could not send error code response to client, maybe the client is already closed or corrupted connection?!");
                }
            }
        }
    }

    public void init(ServletConfig config) throws ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"init()");
        }
        super.init(config);
        try {
            this.airportMapConfig = (AirportMapMBean)ServiceFactory.getInstance().getService(AirportMapMBean.class);
        }
        catch (ServiceNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
        catch (ServiceInstantiationException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void createClient(HttpServletRequest request, HttpServletResponse response) throws NullPointerException, IOException {
        String method = "createClient(): ";
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        String clientId = request.getParameter("clientId");
        String unitGroupIdStr = request.getParameter("unitGroupId");
        MapProxy previousClient = MapProxyFactory.getInstance().getMapProxyByID(clientId);
        if (previousClient != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)(method + "Client with ClientId '" + clientId + "' already exists. Removing old client ..."));
            }
            MapProxyFactory.getInstance().removeProxy(previousClient);
            previousClient = MapProxyFactory.getInstance().getMapProxyByID(clientId);
            if (previousClient == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)(method + "Old client instance with ClientId '" + clientId + "' removed."));
                }
            } else {
                log.error((Object)(method + "Old client instance with ClientId '" + clientId + "' could not be removed. Break!"));
                return;
            }
            previousClient = null;
        } else if (log.isDebugEnabled()) {
            log.debug((Object)(method + "Client with ClientId " + clientId + " unknown! Will initialize new client ..."));
        }
        long unitGroupId = MapUtil.getInstance().getAirportId(unitGroupIdStr);
        HTTPConnection connection = new HTTPConnection(request, response);
        MapProxy client = MapProxyFactory.getInstance().createMapProxy(clientId, username, password, unitGroupId, connection);
        if (client != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting new client (" + clientId + ") on hold ..."));
            }
            this.setNewClientOnHold(clientId, client);
        } else {
            log.fatal((Object)(method + "Client (" + clientId + ") is still known - ServletLock skipped!?! CHECK IMPLEMENTATION!!!"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNewClientOnHold(String clientId, MapProxy myClient) {
        try {
            if (!myClient.isShuttingDown()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("New MapProxy -> sending all requested initial bulk data for client with id " + clientId + " (Client: " + ((Object)((Object)myClient)).toString() + ")."));
                }
            } else {
                log.error((Object)("New MapServlet -> Could not send initial data and set client on hold for client with id " + clientId + " (Client: " + ((Object)((Object)myClient)).toString() + "), because client is already shutting down!"));
                return;
            }
            myClient.sendInitialData();
            if (log.isInfoEnabled()) {
                log.info((Object)("New MapServlet -> " + ((Object)((Object)this)).toString() + " with client id " + clientId + " (Client: " + ((Object)((Object)myClient)).toString() + ") on hold."));
            }
            while (!myClient.isShuttingDown()) {
                Thread.sleep(1000L);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Client: " + clientId + " (Client: " + ((Object)((Object)myClient)).toString() + ") was shut down!"));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Endless loop in MapServlet for client '" + clientId + "' (Client: " + ((Object)((Object)myClient)).toString() + ") has stopped --> ServletID: " + ((Object)((Object)this)).toString()));
                log.debug((Object)("Terminating method createClient() for client '" + clientId + " (Client: " + ((Object)((Object)myClient)).toString() + ")."));
            }
        }
        catch (InterruptedException ex) {
            log.error((Object)("setNewClientOnHold() for client '" + clientId + "' (Client: " + ((Object)((Object)myClient)).toString() + ") runs into"), (Throwable)ex);
        }
        finally {
            myClient = null;
        }
    }
}

