/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.web.map.components.event;

import de.proveo.configurator.airportmap.AirportMapMonitorMBean;
import de.proveo.util.service.ServiceFactory;
import de.proveo.util.service.ServiceInstantiationException;
import de.proveo.util.service.ServiceNotFoundException;
import de.proveo.web.map.communication.stream.Connection;
import de.proveo.web.map.components.cache.DataCache;
import de.proveo.web.map.components.event.MapProxy;
import de.proveo.web.map.components.masterdata.MasterdataHandler;
import de.proveo.web.map.management.MapManagement;
import de.proveo.web.map.util.MapUtil;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantClient;
import de.proveo.wwt.logic.ejb.general.jms.JMSConnectionUtil;
import de.proveo.wwt.logic.ejb.general.jms.JMSMessageListener;
import de.proveo.wwt.logic.xml.request.XmlRequestManager;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MapProxyFactory {
    private static MapProxyFactory instance = null;
    private static final Log log = LogFactory.getLog(MapProxyFactory.class);
    private final ConcurrentHashMap<String, MapProxy> proxyPool = new ConcurrentHashMap();
    private InformantClient informantClient = null;
    private MasterdataHandler airportmapMasterDataChangeProvider = null;
    private MapManagement airportMapMaintenance = null;
    private static final ReentrantLock lock = new ReentrantLock();
    private AirportMapMonitorMBean airportMapMonitorMBean = null;
    private long periodTimestampPing = 900000L;
    private XmlRequestManager xmlRequestManager = null;

    private MapProxyFactory() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Constructor MapProxyFactory invoked.");
        }
        this.informantClient = new InformantClient();
        this.xmlRequestManager = new XmlRequestManager();
        this.airportmapMasterDataChangeProvider = new MasterdataHandler();
        JMSConnectionUtil.getInstance().establishJMSConnection("MasterdataHandler", (JMSMessageListener)this.airportmapMasterDataChangeProvider, this.getSelectorString("UnitTypeNotifyMessage") + " OR " + this.getSelectorString("UnitNotifyMessage") + " OR " + this.getSelectorString("UnitDeletedChangedNotifyMessage") + " OR " + this.getSelectorString("ViewPermissionUpdateMessage") + " OR " + this.getSelectorString("StateModelCreateMessage") + " OR " + this.getSelectorString("StateModelUpdateMessage") + " OR " + this.getSelectorString("StateModelRemoveMessage") + " OR " + this.getSelectorString("MeasurementCreateMessage") + " OR " + this.getSelectorString("MeasurementUpdateMessage") + " OR " + this.getSelectorString("MeasurementRemoveMessage"), this.informantClient);
        if (log.isDebugEnabled()) {
            log.debug((Object)"JMS masterdata view permission client started!");
        }
        this.airportMapMaintenance = new MapManagement();
        JMSConnectionUtil.getInstance().establishJMSConnection("MapManagement", (JMSMessageListener)this.airportMapMaintenance, this.getSelectorString("AirportMapMaintenance"), this.informantClient);
        if (log.isDebugEnabled()) {
            log.debug((Object)"JMS map maintenance client started!");
        }
        try {
            this.airportMapMonitorMBean = (AirportMapMonitorMBean)ServiceFactory.getInstance().getService(AirportMapMonitorMBean.class);
        }
        catch (ServiceNotFoundException e) {
            log.error((Object)"MapProxyFactory has caused a ServiceNotFoundException", (Throwable)e);
        }
        catch (ServiceInstantiationException e) {
            log.error((Object)"MapProxyFactory has caused a ServiceInstantiationException", (Throwable)e);
        }
        DataCache.getInstance();
        String selector = this.createSelector("units,stands,notify_messages,use_messages,infoman_messages");
        JMSConnectionUtil.getInstance().establishJMSConnection("DataCache", (JMSMessageListener)DataCache.getInstance(), selector, this.informantClient);
        this.periodTimestampPing = Long.parseLong(MapUtil.getInstance().getParameter("observable.pingthread.timeStamp", null));
    }

    public MapProxy createMapProxy(String clientName, String username, String password, long unitGroupId, Connection connection) throws NullPointerException {
        String method = "createMapProxy(" + clientName + "): ";
        MapProxy mapProxy = this.proxyPool.get(clientName);
        if (mapProxy != null) {
            log.error((Object)(method + "MapProxy with id '" + clientName + "' already exists. Cannot create a client which is already created. Break! (MapProxyFactoryInstance: " + this.toString() + ")"));
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(method + "Create new MapProxy with id '" + clientName + "' for airport id '" + unitGroupId + "' ... (MapProxyFactoryInstance: " + this.toString() + ")"));
        }
        String selector = this.getSelector(connection);
        mapProxy = new MapProxy(clientName, username, password, unitGroupId, selector, connection);
        mapProxy.setup();
        log.debug((Object)(method + "Adding new client with id '" + clientName + "' to proxyPool ..."));
        this.proxyPool.put(clientName, mapProxy);
        if (this.airportMapMonitorMBean != null) {
            Properties clientValues = connection.getServletParameters();
            clientValues.put("jmsClientId", mapProxy.getJMSClientId());
            this.airportMapMonitorMBean.setAirportMapUser(clientName, clientValues);
        } else {
            log.error((Object)(method + "Could not register client with ClientID '" + clientName + "' at MBean, because MBean instance is null!"));
        }
        mapProxy.pingServerTime(System.currentTimeMillis());
        if (log.isDebugEnabled()) {
            log.debug((Object)(method + "***** MapProxy sucussfully created with these topics: " + selector + " *****"));
        }
        return mapProxy;
    }

    public String createSelector(String selectorValues) {
        StringBuffer selector = new StringBuffer();
        if (!selectorValues.equals("")) {
            StringTokenizer tokenizer = new StringTokenizer(selectorValues, ",");
            boolean standsSelected = false;
            boolean unitsSelected = false;
            boolean errorSelected = false;
            while (tokenizer.hasMoreTokens()) {
                String nextToken = tokenizer.nextToken().trim();
                if (nextToken.equals("units")) {
                    selector = this.addSelector(selector, this.getSelectorString("KeepAlive"));
                    selector = this.addSelector(selector, this.getSelectorString("GeoStructHistoryAndCache"));
                    selector = this.addSelector(selector, this.getSelectorString("StateEventHistoryAndCache"));
                    selector = this.addSelector(selector, this.getSelectorString("MeasurementHistoryAndCache"));
                    unitsSelected = true;
                    continue;
                }
                if (nextToken.equals("stands")) {
                    selector = this.addSelector(selector, this.getSelectorString("AllStandData"));
                    selector = this.addSelector(selector, this.getSelectorString("StandEvent"));
                    selector = this.addSelector(selector, this.getSelectorString("AllocationEvent"));
                    standsSelected = true;
                    continue;
                }
                if (nextToken.equals("notify_messages")) {
                    selector = this.addSelector(selector, this.getSelectorString("InfomanNotifyMessages"));
                    continue;
                }
                if (nextToken.equals("use_messages")) {
                    selector = this.addSelector(selector, this.getSelectorString("UseEvent"));
                    continue;
                }
                if (nextToken.equals("infoman_messages")) {
                    selector = this.addSelector(selector, this.getSelectorString("InfomanMessages"));
                    continue;
                }
                if (nextToken.equals("server_errors")) {
                    errorSelected = true;
                    continue;
                }
                selector = this.addSelector(selector, this.getSelectorString(nextToken));
                log.warn((Object)("Unidentified selector given: " + nextToken));
            }
            selector = this.addErrorMsgSelectors(selector, standsSelected, unitsSelected, errorSelected);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Topic selector: " + selector));
            }
        }
        return selector.toString();
    }

    private StringBuffer addSelector(StringBuffer completeSelector, String selectorItem) {
        if (completeSelector.length() != 0) {
            completeSelector = completeSelector.append(" OR ");
        }
        completeSelector = completeSelector.append(selectorItem);
        return completeSelector;
    }

    private StringBuffer addErrorMsgSelectors(StringBuffer selector, boolean standsSelected, boolean unitsSelected, boolean errorSelected) {
        if (standsSelected && unitsSelected && errorSelected) {
            selector = this.addSelector(selector, this.getSelectorString("ServerErrorEvent"));
            selector = this.addSelector(selector, this.getSelectorString("StandErrorEvent"));
            selector = this.addSelector(selector, this.getSelectorString("UnitErrorEvent"));
        } else if (unitsSelected && errorSelected) {
            selector = this.addSelector(selector, this.getSelectorString("ServerErrorEvent"));
            selector = this.addSelector(selector, this.getSelectorString("UnitErrorEvent"));
        } else if (standsSelected && errorSelected) {
            selector = this.addSelector(selector, this.getSelectorString("ServerErrorEvent"));
            selector = this.addSelector(selector, this.getSelectorString("StandErrorEvent"));
        }
        return selector;
    }

    public void removeProxy(MapProxy mapProxy) {
        String clientName = mapProxy == null ? "?!?null?!?" : mapProxy.getClientName();
        String method = "removeProxy(" + clientName + "): ";
        if (mapProxy != null) {
            log.debug((Object)(method + "Do clean up for client with id '" + clientName + "' ..."));
            if (!mapProxy.isShuttingDown()) {
                boolean removed;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(method + "Shutting down MapProxy (" + ((Object)((Object)mapProxy)).toString() + ") ..."));
                }
                mapProxy.shutdown();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(method + "MapProxy shut down (" + ((Object)((Object)mapProxy)).toString() + ")"));
                }
                if (this.airportMapMonitorMBean != null) {
                    this.airportMapMonitorMBean.removeAirportMapUser(clientName);
                } else {
                    log.error((Object)(method + "Could not deregister client with ClientID '" + clientName + "' at MBean, because MBean instance is null!"));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(method + "Removing client with id '" + clientName + "' from proxyPool ..."));
                }
                if (removed = this.proxyPool.remove(clientName, (Object)mapProxy)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(method + "Client with id '" + clientName + "' removed from proxyPool (" + ((Object)((Object)mapProxy)).toString() + ")."));
                    }
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)(method + "Given client isn't currently in proxyPool, didn't remove it (Given MapProxy=" + ((Object)((Object)mapProxy)).toString() + "  - MapProxy in Pool=" + ((Object)((Object)this.proxyPool.get(clientName))).toString() + ")."));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(method + "***** MapProxy (" + ((Object)((Object)mapProxy)).toString() + ") completely shutdown *****"));
                }
            } else {
                log.warn((Object)(method + "Client is already shutting down!"));
            }
        } else {
            log.warn((Object)(method + "Could not shutdown client, because there is no MapProxy registered with this name."));
        }
    }

    private String getSelector(Connection connection) {
        return this.createSelector(this.getTypeOfInterest(connection));
    }

    public String getTypeOfInterest(Connection connection) {
        return connection.getServletParameters().getProperty("TypeOfInterest", "");
    }

    public String getXMLSchemas(Connection connection) {
        return connection.getServletParameters().getProperty("xmlSchemas", "");
    }

    private String getSelectorString(String selectionItem) {
        return "TypeOfInterest='" + selectionItem + "'";
    }

    public ConcurrentHashMap<String, MapProxy> getMapProxyPool() {
        return this.proxyPool;
    }

    public MapProxy getMapProxyByID(String clientID) {
        return this.proxyPool.get(clientID);
    }

    public InformantClient getInformantClient() {
        return this.informantClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MapProxyFactory getInstance() {
        if (instance == null) {
            lock.lock();
            try {
                if (instance == null) {
                    instance = new MapProxyFactory();
                }
            }
            finally {
                lock.unlock();
            }
        }
        return instance;
    }

    public XmlRequestManager getXmlRequestManager() {
        return this.xmlRequestManager;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (log.isDebugEnabled()) {
            log.debug((Object)("finalize(): Object " + this.toString() + " deleted by garbage collector!"));
        }
    }

    public long getTimestampPeriod() {
        return this.periodTimestampPing;
    }
}

