/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.web.map.components.event;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.web.map.components.event.MapProxy;
import de.proveo.web.map.timer.BulkUpdateTask;
import de.proveo.web.map.util.MapUtil;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractEventHandler
implements Comparable<Object> {
    private static final Log log = LogFactory.getLog(AbstractEventHandler.class);
    protected HashSet<String> processableEventTypes = null;
    protected volatile String clientName = "UNKNOWN?!";
    protected volatile long lastBulkUpdate = System.currentTimeMillis();
    protected MapProxy mapProxy = null;
    private LinkedList<Map<String, Object>> eventBufferLinkedList = null;
    private ScheduledFuture bulkUpdateTask = null;
    private volatile long delay = -1L;
    private volatile boolean eventBufferActive = true;
    private final Object eventBufferLock = new Object();
    private volatile boolean sendData = false;

    public AbstractEventHandler(MapProxy mapProxy) {
        this.mapProxy = mapProxy;
        this.eventBufferLinkedList = new LinkedList();
        this.eventBufferActive = true;
        this.sendData = this.mapProxy.getTypeOfClientInterest().indexOf(this.getSelectorName()) != -1;
        this.clientName = this.mapProxy.getClientName();
        this.delay = Long.parseLong(MapUtil.getInstance().getParameter("observable.clientbulkdatathread.delay", null));
        this.initProcessableEventTypes();
    }

    public boolean canHandleEventType(String type) {
        return this.processableEventTypes.contains(type);
    }

    protected boolean cleanUp() {
        boolean success = this.stopTimers(true);
        if (this.processableEventTypes != null) {
            this.processableEventTypes.clear();
            this.processableEventTypes = null;
        }
        if (this.eventBufferLinkedList != null) {
            this.eventBufferLinkedList.clear();
            this.eventBufferLinkedList = null;
        }
        this.mapProxy = null;
        return success;
    }

    public void forwardSingleMessage(SerializableEventWrapper eventWrapper) {
        String method = "*[" + this.getName() + "]* ClientID='" + this.clientName + "' -> forwardSingleMessage(): ";
        Map<String, Object> map = this.handleMessage(eventWrapper);
        if (map != null) {
            if (this.isEventBufferActive()) {
                this.addEventToEventBuffer(map);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(method + "Event put into event buffer!"));
                }
            } else {
                this.sendMessageToClient(map);
            }
        }
    }

    public String getClientName() {
        return this.clientName;
    }

    public MapProxy getMapProxy() {
        return this.mapProxy;
    }

    public abstract String getName();

    public abstract String getSelectorName();

    public abstract Map<String, Object> handleMessage(SerializableEventWrapper var1);

    protected abstract void initProcessableEventTypes();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEventBufferActive() {
        Object object = this.eventBufferLock;
        synchronized (object) {
            return this.eventBufferActive;
        }
    }

    protected boolean isSendData() {
        return this.sendData;
    }

    protected boolean isShuttingDown() {
        boolean shuttingDown = true;
        if (this.mapProxy != null) {
            shuttingDown = this.mapProxy.isShuttingDown();
        }
        return shuttingDown;
    }

    private boolean stopTimers(boolean immediately) {
        boolean ret = true;
        if (this.bulkUpdateTask != null) {
            boolean canceled;
            String method = "*[" + this.getName() + "]* ClientID='" + this.clientName + "' -> stopTimers(): ";
            if (log.isDebugEnabled()) {
                log.debug((Object)(method + "Stopping previous timestamp timer task ..."));
            }
            if (!(canceled = this.bulkUpdateTask.cancel(immediately)) && !this.bulkUpdateTask.isDone()) {
                ret = false;
            } else {
                if (this.mapProxy.getThreadPoolExecutor() != null) {
                    this.mapProxy.getThreadPoolExecutor().purge();
                }
                this.bulkUpdateTask = null;
            }
            if (log.isDebugEnabled()) {
                if (ret) {
                    log.debug((Object)(method + "Previous task for scheduled bulk has been canceled!"));
                } else {
                    log.warn((Object)(method + "Previous task for scheduled bulk could not be canceled!"));
                }
            }
        }
        return ret;
    }

    public void scheduleNextBulkUpdate() {
        String method = "*[" + this.getName() + "]* ClientID='" + this.clientName + "' -> scheduleNextBulkUpdate(): ";
        this.stopTimers(false);
        if (this.mapProxy == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(method + "Can not schedule bulk update for this client, because client is shutting down at the moment."));
            }
            return;
        }
        String username = this.mapProxy.getUsername();
        BulkUpdateTask runBulkUpdateTask = new BulkUpdateTask(this);
        if (System.currentTimeMillis() - this.lastBulkUpdate > this.delay) {
            this.bulkUpdateTask = this.mapProxy.getThreadPoolExecutor().schedule(runBulkUpdateTask, 0L, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled()) {
                log.debug((Object)(method + "*** Bulk update task (re-)scheduled! Next execution time for user " + username + " will be now! ***"));
            }
        } else {
            this.bulkUpdateTask = this.mapProxy.getThreadPoolExecutor().schedule(runBulkUpdateTask, this.delay, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled()) {
                log.debug((Object)(method + "*** Bulk update task (re-)scheduled! Next execution time for user " + username + " will be in " + this.delay / 1000L + " seconds! ***"));
            }
        }
    }

    public abstract void sendAllBulkDataToClient() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEventBufferToClient() {
        String method = "*[" + this.getName() + "]* ClientID='" + this.clientName + "' -> sendEventBufferToClient(): ";
        if (log.isDebugEnabled()) {
            log.debug((Object)(method + "started ..."));
        }
        if (this.eventBufferLinkedList.isEmpty()) {
            this.setEventBufferActive(false);
        } else {
            while (!this.isShuttingDown() && !this.eventBufferLinkedList.isEmpty()) {
                this.sendMessageToClient(this.eventBufferLinkedList.poll());
                Object object = this.eventBufferLock;
                synchronized (object) {
                    if (this.eventBufferLinkedList.isEmpty()) {
                        this.setEventBufferActive(false);
                        break;
                    }
                }
            }
        }
        this.setEventBufferActive(false);
        if (this.isShuttingDown()) {
            log.warn((Object)(method + "Client was marked for Shutdown while sending event buffer to the client. Sending aborded"));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(method + "Event buffer sent to client"));
        }
    }

    protected void sendMessageToClient(Map<String, Object> message) {
        String method = "*[" + this.getName() + "]* ClientID='" + this.clientName + "' -> sendMessageToClient(): ";
        if (!this.isSendData()) {
            log.error((Object)(method + "Received event for disabled client. Discard event!"));
            return;
        }
        this.mapProxy.sendResponse(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEventToEventBuffer(Map<String, Object> event) {
        Object object = this.eventBufferLock;
        synchronized (object) {
            this.eventBufferLinkedList.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEventBufferActive(boolean active) {
        String method = "*[" + this.getName() + "]* ClientID='" + this.clientName + "' -> setEventBufferActive(): ";
        Object object = this.eventBufferLock;
        synchronized (object) {
            if (this.eventBufferActive != active) {
                this.eventBufferActive = active;
                if (this.eventBufferActive) {
                    log.debug((Object)(method + "Event buffer activated!"));
                } else {
                    int bufferSize = this.eventBufferLinkedList.size();
                    if (bufferSize > 0) {
                        log.error((Object)(method + "Event buffer was deactivated, but there were still " + bufferSize + " event(s) in it."));
                        this.eventBufferLinkedList.clear();
                    }
                    log.debug((Object)(method + "Event buffer deactivated!"));
                }
            }
        }
    }

    @Override
    public int compareTo(Object o) {
        if (o != null && o instanceof AbstractEventHandler) {
            return this.getName().compareTo(((AbstractEventHandler)o).getName());
        }
        return 1;
    }
}

