/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.web.map.components.cache;

import de.proveo.util.observable.interfaces.StandsBulkDataUpdateListener;
import de.proveo.util.observable.interfaces.UnitBulkDataUpdateListener;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.web.map.timer.StandCacheUpdateTask;
import de.proveo.web.map.timer.UnitCacheUpdateTask;
import de.proveo.web.map.util.MapUtil;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.unit.typeIdentity.UnitTypeIdentity;
import de.proveo.wwt.logic.ejb.dataOut.mapclient.MapClientFacadeRemote;
import de.proveo.wwt.logic.ejb.general.area.AreaInFacadeRemote;
import de.proveo.wwt.logic.ejb.general.jms.JMSClient;
import de.proveo.wwt.logic.ejb.general.jms.JMSMessageListener;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeRemote;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DataCache
extends JMSMessageListener
implements UnitBulkDataUpdateListener,
StandsBulkDataUpdateListener {
    private static final Log log = LogFactory.getLog(DataCache.class);
    private AreaInFacadeRemote areaInFacadeBean = null;
    private MapClientFacadeRemote mapClientFacade = null;
    private UnitFacadeRemote unitFacade = null;
    private static DataCache unitBulkData = null;
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final Object UPDATE_STAMPS_LOCK = new Object();
    private static final Object IS_UPDATING_STAMPS_LOCK = new Object();
    private volatile boolean updatingStamps = false;
    private static final HashMap<Long, Object> UNIT_LOCKS = new HashMap();
    private final ConcurrentHashMap<Long, Map<String, Object>> allStampsByDBMap = new ConcurrentHashMap();
    private static final Object UPDATE_STANDS_LOCK = new Object();
    private static final Object IS_UPDATING_STANDS_LOCK = new Object();
    private volatile boolean updatingStands = false;
    private static final HashMap<String, Object> STAND_LOCKS = new HashMap();
    private final ConcurrentHashMap<String, Map<String, Object>> allStandsByDBMap = new ConcurrentHashMap();
    private static final Object UPDATE_AREAS_LOCK = new Object();
    private static final Object IS_UPDATING_AREAS_LOCK = new Object();
    private volatile boolean updatingAreas = false;
    private final ConcurrentHashMap<Integer, Map<String, String>> allAreasMap = new ConcurrentHashMap();
    protected LinkedList<SerializableEventWrapper> unitEventBufferLinkedList = null;
    protected boolean unitsEventBufferActive = true;
    private int timeToUpdateBulkData = 1800000;
    private int maxOfNotifyEvents = 500;
    private final ScheduledThreadPoolExecutor threadPoolExecutor = new ScheduledThreadPoolExecutor(1);

    private DataCache() {
        try {
            InitialContext context = new InitialContext();
            this.areaInFacadeBean = (AreaInFacadeRemote)context.lookup("rts/AreaInFacade/remote");
            this.mapClientFacade = (MapClientFacadeRemote)context.lookup("rts/MapClientFacade/remote");
            this.unitFacade = (UnitFacadeRemote)context.lookup("rts/UnitFacade/remote");
            this.timeToUpdateBulkData = Integer.parseInt(MapUtil.getInstance().getParameter("observable.unitbulkdatathread.dbPeriod", Integer.toString(this.timeToUpdateBulkData)));
            this.maxOfNotifyEvents = Integer.parseInt(MapUtil.getInstance().getParameter("observable.notifies.maximumPerUnitPerDay", Integer.toString(this.maxOfNotifyEvents)));
        }
        catch (NamingException e) {
            log.error((Object)"DataCache runs into NamingException", (Throwable)e);
        }
        catch (NumberFormatException e) {
            log.error((Object)"DataCache runs into NumberFormatException", (Throwable)e);
        }
        new Thread("DataCacheInitializerThread"){

            @Override
            public void run() {
                DataCache.this.updateAreaCache();
                DataCache.this.updateUnitBulkData();
                if (MapUtil.getInstance().isStandsLogicEnabled()) {
                    DataCache.this.updateStandsBulkData();
                }
                log.debug((Object)"Initial bulk data received!");
                DataCache.this.startBulkDataUpdateTimer();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataCache getInstance() {
        if (unitBulkData == null) {
            LOCK.lock();
            try {
                if (unitBulkData == null) {
                    unitBulkData = new DataCache();
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        return unitBulkData;
    }

    private void startBulkDataUpdateTimer() {
        this.threadPoolExecutor.scheduleAtFixedRate(new UnitCacheUpdateTask(this), this.timeToUpdateBulkData, this.timeToUpdateBulkData, TimeUnit.MILLISECONDS);
        if (MapUtil.getInstance().isStandsLogicEnabled()) {
            this.threadPoolExecutor.scheduleAtFixedRate(new StandCacheUpdateTask(this), this.timeToUpdateBulkData, this.timeToUpdateBulkData, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Units and stands bulk update for cache will be periodically started in " + this.timeToUpdateBulkData / 60000 + " minutes"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Units bulk update for cache will be periodically started in " + this.timeToUpdateBulkData / 60000 + " minutes"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAreaCache() {
        String method = "updateAreaCache(): ";
        log.debug((Object)(method + "Reading all areas from database ..."));
        Object object = IS_UPDATING_AREAS_LOCK;
        synchronized (object) {
            this.updatingAreas = true;
        }
        try {
            List allAreasList = this.areaInFacadeBean.findAll();
            if (allAreasList != null) {
                int amountOfAreas = allAreasList.size();
                log.debug((Object)(method + "Found " + amountOfAreas + " areas. Updating cache ..."));
                this.allAreasMap.clear();
                for (int i = 0; i < amountOfAreas; ++i) {
                    Area area = (Area)allAreasList.get(i);
                    HashMap valueMap = new HashMap();
                    MapUtil.getInstance().mapPutNullCheck(valueMap, "Area", area.getName(), false);
                    MapUtil.getInstance().mapPutNullCheck(valueMap, "AreaName", area.getDescription(), false);
                    MapUtil.getInstance().mapPutNullCheck(this.allAreasMap, area.getAreaId(), valueMap, false);
                }
                log.debug((Object)(method + "Area cache updated."));
            } else {
                log.error((Object)(method + "areaInFacadeBean.findAllForAirportmap() returned null?!"));
            }
        }
        finally {
            object = IS_UPDATING_AREAS_LOCK;
            synchronized (object) {
                this.updatingAreas = false;
            }
            object = UPDATE_AREAS_LOCK;
            synchronized (object) {
                UPDATE_AREAS_LOCK.notifyAll();
            }
        }
    }

    public void updateBulkData() {
        this.updateUnitBulkData();
        if (MapUtil.getInstance().isStandsLogicEnabled()) {
            this.updateStandsBulkData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUnitBulkData() {
        Object dbData;
        String method = "updateUnitBulkData(): ";
        log.debug((Object)(method + "Updating unit data for cache from database ..."));
        Object object = IS_UPDATING_STAMPS_LOCK;
        synchronized (object) {
            this.updatingStamps = true;
        }
        try {
            dbData = this.mapClientFacade.getOnlineUnitData();
            if (dbData != null) {
                this.allStampsByDBMap.clear();
                this.allStampsByDBMap.putAll((Map<Long, Map<String, Object>>)dbData);
                ((ConcurrentHashMap)dbData).clear();
            }
            log.debug((Object)(method + "Unit cache data updated from database"));
        }
        catch (Throwable ex) {
            log.error((Object)(method + "Update unit cache data from database runs into unknown exception"), ex);
        }
        finally {
            dbData = IS_UPDATING_STAMPS_LOCK;
            synchronized (dbData) {
                this.updatingStamps = false;
            }
            dbData = UPDATE_STAMPS_LOCK;
            synchronized (dbData) {
                UPDATE_STAMPS_LOCK.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStandsBulkData() {
        Object dbData;
        String method = "updateStandsBulkData(): ";
        log.debug((Object)(method + "Updating stands data for cache from database ..."));
        Object object = IS_UPDATING_STANDS_LOCK;
        synchronized (object) {
            this.updatingStands = true;
        }
        try {
            dbData = this.mapClientFacade.getOnlineStandsData();
            if (dbData != null) {
                this.allStandsByDBMap.clear();
                this.allStandsByDBMap.putAll((Map<String, Map<String, Object>>)dbData);
                ((ConcurrentHashMap)dbData).clear();
            }
            log.debug((Object)(method + "Stands cache data updated from database"));
        }
        catch (Throwable ex) {
            log.error((Object)(method + "Update stands cache data from database runs into unknown exception"), ex);
        }
        finally {
            dbData = IS_UPDATING_STANDS_LOCK;
            synchronized (dbData) {
                this.updatingStands = false;
            }
            dbData = UPDATE_STANDS_LOCK;
            synchronized (dbData) {
                UPDATE_STANDS_LOCK.notifyAll();
            }
        }
    }

    public boolean isUnitCacheDataLoaded() {
        return !this.isUpdatingStamps() && !this.isUpdatingAreas();
    }

    public boolean isStandCacheDataLoaded() {
        return !this.isUpdatingStands();
    }

    public HashSet<Long> getUnitPermissions(String username, boolean superAdmin, long unitGroupId) throws Exception {
        return this.mapClientFacade.getUnitPermissions(username, superAdmin, unitGroupId);
    }

    public Map<Long, Map<String, Object>> getAllPermittedCachedStamps(Set<Long> unitPermissons, boolean infomanMessages, boolean notifyMessages, boolean useMessages) {
        String method = "getAllPermittedCachedStamps(): ";
        HashMap<Long, Map<String, Object>> gseDataClone = new HashMap<Long, Map<String, Object>>();
        for (Long unitId : unitPermissons) {
            Map<String, Object> stamp;
            try {
                stamp = this.getCachedStampClone(unitId);
            }
            catch (Throwable ex) {
                continue;
            }
            if (!((Boolean)stamp.get("UnitAirportMapFlag")).booleanValue() || ((Boolean)stamp.get("UnitDeletedFlag")).booleanValue()) continue;
            if (!useMessages && stamp.remove("UseEventUserKey") != null) {
                stamp.remove("UseEventTimestamp");
                stamp.remove("UseEventUserGroupId");
                stamp.remove("UseEventLogin");
                stamp.remove("UseEventReceiveTime");
                stamp.remove("UseEventDriverName");
                stamp.remove("UseEventPersonalNumber");
            }
            if (!infomanMessages) {
                stamp.remove("SmBootTimestamp");
                stamp.remove("SmBootMessage");
                stamp.remove("SmIpTimestamp");
                stamp.remove("SmIpMessage");
                stamp.remove("SmErrorTimestamp");
                stamp.remove("SmErrorMessage");
                stamp.remove("infomanConfigurationName");
                stamp.remove("infomanConfigurationUpToDate");
                stamp.remove("infomanHardware");
                stamp.remove("infomanHardwareSN");
                stamp.remove("infomanInfomanSN");
                stamp.remove("infomanJavaVMVersion");
                stamp.remove("infomanKernelVersion");
                stamp.remove("infomanPMVersion");
                stamp.remove("infomanRootFSVersion");
                stamp.remove("infomanSoftwareVersion");
            }
            if (!notifyMessages) {
                stamp.remove("NotifyEvents");
            }
            if (stamp.isEmpty()) continue;
            if (!unitId.equals(stamp.get("UnitId"))) {
                log.error((Object)(method + "Unit ID mismatch found in cache?! Given='" + unitId + "' Stamp='" + stamp.get("UnitId") + "'. Will update stamp with given unit ID ..."));
                MapUtil.getInstance().mapPutNullCheck(stamp, "UnitId", unitId, false);
                HashMap<String, Object> update = new HashMap<String, Object>();
                MapUtil.getInstance().mapPutNullCheck(update, "UnitId", unitId, false);
                this.updateStamp(unitId, update);
            }
            MapUtil.getInstance().mapPutNullCheck(gseDataClone, unitId, stamp, false);
        }
        return gseDataClone;
    }

    public Map<String, Object> getCachedStamp(Long unitId, boolean infomanMessages, boolean notifyMessages, boolean useMessages) {
        Map<String, Object> stampClone;
        String method = "getCachedStamp(): ";
        try {
            stampClone = this.getCachedStampClone(unitId);
        }
        catch (Throwable ex) {
            return null;
        }
        if (!MapUtils.getBoolean(stampClone, (Object)"UnitAirportMapFlag").booleanValue() || MapUtils.getBoolean(stampClone, (Object)"UnitDeletedFlag").booleanValue()) {
            return null;
        }
        if (!useMessages && stampClone.remove("UseEventUserKey") != null) {
            stampClone.remove("UseEventTimestamp");
            stampClone.remove("UseEventUserGroupId");
            stampClone.remove("UseEventLogin");
            stampClone.remove("UseEventReceiveTime");
            stampClone.remove("UseEventDriverName");
            stampClone.remove("UseEventPersonalNumber");
        }
        if (!infomanMessages) {
            stampClone.remove("SmBootTimestamp");
            stampClone.remove("SmBootMessage");
            stampClone.remove("SmIpTimestamp");
            stampClone.remove("SmIpMessage");
            stampClone.remove("SmErrorTimestamp");
            stampClone.remove("SmErrorMessage");
            stampClone.remove("infomanConfigurationName");
            stampClone.remove("infomanConfigurationUpToDate");
            stampClone.remove("infomanHardware");
            stampClone.remove("infomanHardwareSN");
            stampClone.remove("infomanInfomanSN");
            stampClone.remove("infomanJavaVMVersion");
            stampClone.remove("infomanKernelVersion");
            stampClone.remove("infomanPMVersion");
            stampClone.remove("infomanRootFSVersion");
            stampClone.remove("infomanSoftwareVersion");
        }
        if (!notifyMessages) {
            stampClone.remove("NotifyEvents");
        }
        if (stampClone.isEmpty()) {
            return null;
        }
        return stampClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, Object>> getAllPermittedCachedStands() {
        String method = "getAllPermittedCachedStands(): ";
        if (!MapUtil.getInstance().isStandsLogicEnabled()) {
            log.error((Object)(method + "Some client tries to get all cached stands, but stand logic is disabled!?! Returning null."));
            return null;
        }
        HashMap<String, Map<String, Object>> stands = new HashMap<String, Map<String, Object>>();
        HashSet standIds = new HashSet(this.getAllStandsByDBMap().keySet());
        for (String standId : standIds) {
            Object object = this.getStandLock(standId);
            synchronized (object) {
                Map standData;
                try {
                    standData = (Map)MapUtil.getInstance().deepClone((Serializable)((Object)this.getAllStandsByDBMap().get(standId)));
                }
                catch (Throwable ex) {
                    continue;
                }
                MapUtil.getInstance().mapPutNullCheck(stands, standId, standData, false);
            }
        }
        return stands;
    }

    public Map<String, String> getCachedArea(int areaId) {
        return this.getAllAreasMap().get(areaId);
    }

    public void onMessage(Message message) {
        String method = "onMessage(): ";
        try {
            if (message instanceof ObjectMessage) {
                ObjectMessage oMessage = (ObjectMessage)message;
                Serializable _object = oMessage.getObject();
                if (_object instanceof SerializableEventWrapper) {
                    SerializableEventWrapper eventWrapper = (SerializableEventWrapper)_object;
                    try {
                        this.addSingleEventToCache(eventWrapper);
                    }
                    catch (Throwable ex) {
                        log.error((Object)(method + "Could not update cache data!"), ex);
                    }
                } else {
                    log.error((Object)(method + "Could not handle message. Object of ObjectMessage isn't a SerializableEventWrapper. Object=" + _object));
                }
            } else {
                log.error((Object)(method + "Could not handle message. Message isn't an instance of ObjectMessage. Message=" + message));
            }
            message.acknowledge();
        }
        catch (JMSException e) {
            log.error((Object)(method + "runs into JMSException: "), (Throwable)e);
        }
        catch (Throwable ex) {
            log.error((Object)(method + "runs into unknown exception"), ex);
        }
    }

    private void addSingleEventToCache(SerializableEventWrapper event) throws Exception {
        String method = "addSingleEventToCache(): ";
        DataType dataType = this.getDataTypeOfEvent(event);
        if (dataType.equals((Object)DataType.UNKNOWN)) {
            log.error((Object)(method + "Received an unknown event type: " + event.get_typeOfEvent()));
        } else if (dataType.equals((Object)DataType.UNIT)) {
            this.addSingleUnitEventToCache(event);
        } else if (dataType.equals((Object)DataType.STAND)) {
            this.addSingleStandEventToCache(event);
        } else {
            log.fatal((Object)(method + "Received an unknown data type: " + dataType.name()));
        }
    }

    private void addSingleUnitEventToCache(SerializableEventWrapper event) {
        String method = "addSingleUnitEventToCache(): ";
        Map<String, Object> eventMap = MapUtil.getInstance().createFittingUnitEventMap(event);
        if (eventMap == null) {
            return;
        }
        Long unitId = (Long)eventMap.get("UnitId");
        HashMap<String, Object> update = new HashMap();
        if ("data_type_notification_event".equals(eventMap.get("EventType"))) {
            TreeMap notifyEvents = new TreeMap();
            Long timeStamp = (Long)eventMap.get("NotifyTimestamp");
            Long msgID = (Long)eventMap.get("NotifyMessageID");
            MapUtil.getInstance().mapPutNullCheck(notifyEvents, timeStamp + "_" + msgID, eventMap, false);
            MapUtil.getInstance().mapPutNullCheck(update, "NotifyEvents", notifyEvents, false);
        } else {
            update = eventMap;
        }
        boolean success = this.updateStamp(unitId, update);
        if (!success) {
            log.fatal((Object)(method + "Couldn't add an event to the cache!!!"));
        }
    }

    private void addSingleStandEventToCache(SerializableEventWrapper event) {
        String method = "addSingleStandEventToCache(): ";
        if (!MapUtil.getInstance().isStandsLogicEnabled()) {
            log.error((Object)(method + "Receiving stand events but stand logic is disabled?! Discard event."));
            return;
        }
        Map<String, Object> eventMap = MapUtil.getInstance().createFittingStandEventMap(event);
        if (eventMap == null) {
            return;
        }
        String standID = (String)eventMap.get("fstd");
        this.updateStand(standID, eventMap);
    }

    public boolean isVisible(Long unitId) {
        boolean visible = false;
        Map<String, Object> stamp = this.getCachedStamp(unitId);
        if (stamp != null) {
            Object deletedFlagObj;
            boolean apFlag = false;
            boolean deletedFlag = false;
            Object apFlagObj = stamp.get("UnitAirportMapFlag");
            if (apFlagObj != null) {
                apFlag = (Boolean)apFlagObj;
            }
            if ((deletedFlagObj = stamp.get("UnitDeletedFlag")) != null) {
                deletedFlag = (Boolean)deletedFlagObj;
            }
            visible = apFlag && !deletedFlag;
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Unit with ID '" + unitId + "' cannot be found in cache and database, but event data is incomming!"));
        }
        return visible;
    }

    public void setAPMapFlagByUnitID(Long unitId, boolean isVisible) {
        HashMap<String, Object> update = new HashMap<String, Object>();
        MapUtil.getInstance().mapPutNullCheck(update, "UnitAirportMapFlag", isVisible, false);
        this.updateStamp(unitId, update);
    }

    public void setChangedUnitType(UnitTypeIdentity unitTypeValue, List<Long> listAffectedUnitIds) {
        try {
            unitTypeValue = this.unitFacade.getUnitTypeById(Long.valueOf(unitTypeValue.getId()));
        }
        catch (Exception ex) {
            log.warn((Object)"Could not get current unit type identity", (Throwable)ex);
        }
        for (int index = 0; index < listAffectedUnitIds.size(); ++index) {
            Long unitId = listAffectedUnitIds.get(index);
            if (unitId == null) continue;
            HashMap<String, Object> update = new HashMap<String, Object>();
            MapUtil.getInstance().mapPutNullCheck(update, "UnitKind", unitTypeValue.getImageType().getName(), false);
            MapUtil.getInstance().mapPutNullCheck(update, "UnitType", unitTypeValue.getName(), false);
            this.updateStamp(unitId, update);
        }
    }

    public List<Long> setChangedUnit(List<UnitDTO> unitDTOs) {
        ArrayList<Long> listAffectedUnitIds = new ArrayList<Long>();
        for (int index = 0; index < unitDTOs.size(); ++index) {
            UnitDTO unitDTO = unitDTOs.get(index);
            if (unitDTO == null) continue;
            long unitId = unitDTO.getUnitId();
            HashMap<String, Object> update = new HashMap<String, Object>();
            listAffectedUnitIds.add(unitId);
            UnitTypeIdentity unitTypeValue = unitDTO.getUnitTypeIdentity();
            try {
                unitTypeValue = this.unitFacade.getUnitTypeById(Long.valueOf(unitTypeValue.getId()));
            }
            catch (Exception ex) {
                log.warn((Object)"Could not get current unit type identity", (Throwable)ex);
            }
            MapUtil.getInstance().mapPutNullCheck(update, "UnitKind", unitTypeValue.getImageType().getName(), false);
            MapUtil.getInstance().mapPutNullCheck(update, "UnitType", unitTypeValue.getName(), false);
            MapUtil.getInstance().mapPutNullCheck(update, "UnitName", unitDTO.getUnitName(), false);
            MapUtil.getInstance().mapPutNullCheck(update, "UnitAirportMapFlag", unitDTO.getUnitModel().getAirportmapVisible(), false);
            MapUtil.getInstance().mapPutNullCheck(update, "UnitDeletedFlag", unitDTO.isDeleted(), false);
            this.updateStamp(unitId, update);
        }
        return listAffectedUnitIds;
    }

    public void setDeletedFlagByUnitID(Long unitId, boolean deleted) {
        HashMap<String, Object> update = new HashMap<String, Object>();
        MapUtil.getInstance().mapPutNullCheck(update, "UnitDeletedFlag", deleted, false);
        this.updateStamp(unitId, update);
    }

    private DataType getDataTypeOfEvent(SerializableEventWrapper event) {
        String eventType = event.get_typeOfEvent();
        if (eventType != null) {
            if (eventType.equals("StandEvent")) {
                return DataType.STAND;
            }
            if (eventType.equals("KeepAlive")) {
                return DataType.UNIT;
            }
            if (eventType.equals("GeoStructHistoryAndCache")) {
                return DataType.UNIT;
            }
            if (eventType.equals("StateEventHistoryAndCache")) {
                return DataType.UNIT;
            }
            if (eventType.equals("InfomanMessages")) {
                return DataType.UNIT;
            }
            if (eventType.equals("InfomanNotifyMessages")) {
                return DataType.UNIT;
            }
            if (eventType.equals("UseEvent")) {
                return DataType.UNIT;
            }
            if (eventType.equals("MeasurementHistoryAndCache")) {
                return DataType.UNIT;
            }
        }
        return DataType.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getUnitLock(long unitId) {
        Object lock = UNIT_LOCKS.get(unitId);
        if (lock == null) {
            HashMap<Long, Object> hashMap = UNIT_LOCKS;
            synchronized (hashMap) {
                lock = UNIT_LOCKS.get(unitId);
                if (lock == null) {
                    lock = new Object();
                    MapUtil.getInstance().mapPutNullCheck(UNIT_LOCKS, unitId, lock, false);
                }
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getCachedStamp(long unitId) {
        String method = "getCachedStamp(" + unitId + "): ";
        try {
            Object object = this.getUnitLock(unitId);
            synchronized (object) {
                HashMap stamp = this.getAllStampsByDBMap().get(unitId);
                if (stamp == null) {
                    log.trace((Object)(method + "Could not find stamp in cache, searching in database ..."));
                    stamp = this.mapClientFacade.getUnitData(unitId, true, true, true);
                    if (stamp != null) {
                        log.debug((Object)(method + "Adding new single stamp to data of cache ..."));
                        MapUtil.getInstance().mapPutNullCheck(this.getAllStampsByDBMap(), unitId, stamp, false);
                        log.debug((Object)(method + "New single stamp added to cache."));
                    } else {
                        log.error((Object)(method + "Stamp is neither in cache nor in database?! Try to add empty stamp in cache ..."));
                        stamp = new HashMap();
                        MapUtil.getInstance().mapPutNullCheck(this.getAllStampsByDBMap(), unitId, stamp, false);
                        log.debug((Object)(method + "New empty single stamp added to cache."));
                    }
                }
                return stamp;
            }
        }
        catch (Throwable ex) {
            log.error((Object)(method + "Get cached stamp data runs into unknown exception"), ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getCachedStampClone(long unitId) {
        String method = "getCachedStampClone(" + unitId + "): ";
        try {
            Object object = this.getUnitLock(unitId);
            synchronized (object) {
                Map stamp = this.getCachedStamp(unitId);
                if (stamp != null) {
                    stamp = (Map)MapUtil.getInstance().deepClone((Serializable)((Object)stamp));
                }
                return stamp;
            }
        }
        catch (Throwable ex) {
            log.error((Object)(method + "Get cached stamp data runs into unknown exception"), ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateStamp(Long unitId, Map<String, Object> update) {
        String method = "updateStamp(" + unitId + "): ";
        log.debug((Object)(method + "Updating unit stamp data ..."));
        if (unitId == null) {
            log.error((Object)(method + "Can't update stamp with null unit ID!"));
            return false;
        }
        try {
            Object object = this.getUnitLock(unitId);
            synchronized (object) {
                Map<String, Object> stamp = this.getCachedStamp(unitId);
                if (stamp == null) {
                    stamp = update;
                } else {
                    TreeMap newNotifyEvents = (TreeMap)update.remove("NotifyEvents");
                    if (newNotifyEvents != null) {
                        TreeMap notifyEvents = (TreeMap)stamp.get("NotifyEvents");
                        if (notifyEvents == null) {
                            while (newNotifyEvents.size() > this.maxOfNotifyEvents) {
                                Map.Entry oldestEntry = newNotifyEvents.pollFirstEntry();
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)(method + "Removed oldest notify in notify list: " + (String)oldestEntry.getKey()));
                            }
                            MapUtil.getInstance().mapPutNullCheck(stamp, "NotifyEvents", newNotifyEvents, false);
                        } else {
                            for (String nKey : newNotifyEvents.keySet()) {
                                Map nMap = (Map)newNotifyEvents.get(nKey);
                                MapUtil.getInstance().mapPutNullCheck(notifyEvents, nKey, nMap, false);
                            }
                            while (notifyEvents.size() > this.maxOfNotifyEvents) {
                                Map.Entry oldestEntry = notifyEvents.pollFirstEntry();
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)(method + "Removed oldest notify in notify list: " + (String)oldestEntry.getKey()));
                            }
                        }
                    }
                    stamp.putAll(update);
                }
                if (!unitId.equals(stamp.get("UnitId"))) {
                    log.error((Object)(method + "Unit ID mismatch found in cache?! Given='" + unitId + "' Stamp='" + stamp.get("UnitId") + "'. Will update stamp with given unit ID ..."));
                    MapUtil.getInstance().mapPutNullCheck(stamp, "UnitId", unitId, false);
                }
                MapUtil.getInstance().mapPutNullCheck(this.getAllStampsByDBMap(), unitId, stamp, false);
            }
            log.debug((Object)(method + "Unit cache stamp data updated."));
            return true;
        }
        catch (Throwable ex) {
            log.error((Object)(method + "Update unit stamp runs into unknown exception"), ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getStandLock(String standId) {
        Object lock = STAND_LOCKS.get(standId);
        if (lock == null) {
            HashMap<String, Object> hashMap = STAND_LOCKS;
            synchronized (hashMap) {
                lock = STAND_LOCKS.get(standId);
                if (lock == null) {
                    lock = new Object();
                    MapUtil.getInstance().mapPutNullCheck(STAND_LOCKS, standId, lock, false);
                }
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateStand(String standId, Map<String, Object> update) {
        String method = "updateStand(" + standId + "): ";
        log.debug((Object)(method + "Updating stand data from event ..."));
        if (standId == null) {
            log.error((Object)(method + "Can't update stamp with null unit ID!"));
            return false;
        }
        try {
            Object object = this.getStandLock(standId);
            synchronized (object) {
                Map<String, Object> stand = this.getAllStandsByDBMap().get(standId);
                if (stand == null) {
                    stand = update;
                } else {
                    stand.putAll(update);
                }
                if (!standId.equals(stand.get("fstd"))) {
                    log.error((Object)(method + "Stand ID mismatch found in cache?! Given='" + standId + "' StandData='" + stand.get("UnitId") + "'. Will update stand data with given stand ID ..."));
                    MapUtil.getInstance().mapPutNullCheck(stand, "fstd", standId, false);
                }
                MapUtil.getInstance().mapPutNullCheck(this.getAllStandsByDBMap(), standId, stand, false);
            }
            log.debug((Object)(method + "Unit cache stamp data updated from event"));
            return true;
        }
        catch (Throwable ex) {
            log.error((Object)(method + "Update unit cache data stamp from event runs into unknown exception"), ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentHashMap<Integer, Map<String, String>> getAllAreasMap() {
        if (this.isUpdatingAreas()) {
            Object object = UPDATE_AREAS_LOCK;
            synchronized (object) {
                while (this.isUpdatingAreas()) {
                    try {
                        UPDATE_AREAS_LOCK.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        return this.allAreasMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentHashMap<Long, Map<String, Object>> getAllStampsByDBMap() {
        if (this.isUpdatingStamps()) {
            Object object = UPDATE_STAMPS_LOCK;
            synchronized (object) {
                while (this.isUpdatingStamps()) {
                    try {
                        UPDATE_STAMPS_LOCK.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        return this.allStampsByDBMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentHashMap<String, Map<String, Object>> getAllStandsByDBMap() {
        if (this.isUpdatingStands()) {
            Object object = UPDATE_STANDS_LOCK;
            synchronized (object) {
                while (this.isUpdatingStands()) {
                    try {
                        UPDATE_STANDS_LOCK.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        return this.allStandsByDBMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUpdatingAreas() {
        Object object = IS_UPDATING_AREAS_LOCK;
        synchronized (object) {
            return this.updatingAreas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUpdatingStamps() {
        Object object = IS_UPDATING_STAMPS_LOCK;
        synchronized (object) {
            return this.updatingStamps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUpdatingStands() {
        Object object = IS_UPDATING_STANDS_LOCK;
        synchronized (object) {
            return this.updatingStands;
        }
    }

    public void setJMSClient(JMSClient client) {
    }

    private static enum DataType {
        UNIT,
        STAND,
        UNKNOWN;

    }
}

