/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.observable.stands;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandsDataFactory
implements Serializable {
    private static final Log log = LogFactory.getLog(StandsDataFactory.class);
    private Map<String, Object> flightEventsMap = null;
    private Map<String, Map<String, Object>> arrivalFlightEventsMap = null;
    private Map<String, Map<String, Object>> departureFlightEventsMap = null;
    private Map<String, Object> mainMap = null;
    private Map<String, Object> standsMap = null;
    private Map<String, Map<String, Object>> gseAllocationsMap = null;
    private Map<String, Map<String, Object>> staffAllocationsMap = null;

    public StandsDataFactory() {
        this.mainMap = new HashMap<String, Object>();
        this.flightEventsMap = new HashMap<String, Object>();
        this.arrivalFlightEventsMap = new HashMap<String, Map<String, Object>>();
        this.departureFlightEventsMap = new HashMap<String, Map<String, Object>>();
        this.standsMap = new HashMap<String, Object>();
        this.staffAllocationsMap = new HashMap<String, Map<String, Object>>();
        this.gseAllocationsMap = new HashMap<String, Map<String, Object>>();
        this.mainMap.put("ALL_FLIGHT_EVENTS", this.flightEventsMap);
        this.mainMap.put("ARRIVAL_ALL_FLIGHT_EVENTS", this.arrivalFlightEventsMap);
        this.mainMap.put("DEPARTURE_ALL_FLIGHT_EVENTS", this.departureFlightEventsMap);
        this.mainMap.put("ALL_STANDS", this.standsMap);
        this.mainMap.put("ALL_GSE_ALLOCATION_EVENTS", this.gseAllocationsMap);
        this.mainMap.put("ALL_STAFF_ALLOCATION_EVENTS", this.staffAllocationsMap);
        this.standsMap.put("StandStates", new HashMap());
    }

    public StandsDataFactory(Map<String, Object> transferData) {
        this.mainMap = transferData;
        this.flightEventsMap = this.mainMap.containsKey("ALL_FLIGHT_EVENTS") ? (Map<Object, Object>)this.mainMap.get("ALL_FLIGHT_EVENTS") : new HashMap<String, Object>();
        this.arrivalFlightEventsMap = this.mainMap.containsKey("ARRIVAL_ALL_FLIGHT_EVENTS") ? (Map<Object, Object>)this.mainMap.get("ARRIVAL_ALL_FLIGHT_EVENTS") : new HashMap<String, Map<String, Object>>();
        this.departureFlightEventsMap = this.mainMap.containsKey("DEPARTURE_ALL_FLIGHT_EVENTS") ? (Map<Object, Object>)this.mainMap.get("DEPARTURE_ALL_FLIGHT_EVENTS") : new HashMap<String, Map<String, Object>>();
        this.standsMap = this.mainMap.containsKey("ALL_STANDS") ? (Map<Object, Object>)this.mainMap.get("ALL_STANDS") : new HashMap<String, Object>();
        this.staffAllocationsMap = this.mainMap.containsKey("ALL_STAFF_ALLOCATION_EVENTS") ? (Map<Object, Object>)this.mainMap.get("ALL_STAFF_ALLOCATION_EVENTS") : new HashMap<String, Map<String, Object>>();
        this.gseAllocationsMap = this.mainMap.containsKey("ALL_GSE_ALLOCATION_EVENTS") ? (Map<Object, Object>)this.mainMap.get("ALL_GSE_ALLOCATION_EVENTS") : new HashMap<String, Map<String, Object>>();
    }

    public Map<String, Object> getGSEAllocationsForFlight(String flightNumber) {
        Map<String, Object> ret = new HashMap<String, Object>();
        if (this.gseAllocationsMap != null) {
            String depUAFT;
            Map<String, Object> depGSEAllocations;
            Map completeFlight;
            ret = this.gseAllocationsMap.get(flightNumber);
            if (ret != null) {
                ret = new HashMap<String, Object>(ret);
            }
            if ((completeFlight = (Map)this.flightEventsMap.get(flightNumber)) != null && (depGSEAllocations = this.gseAllocationsMap.get(depUAFT = (String)completeFlight.get("departureUAFT"))) != null) {
                depGSEAllocations = new HashMap<String, Object>(depGSEAllocations);
                if (ret != null) {
                    ret.putAll(depGSEAllocations);
                } else {
                    ret = depGSEAllocations;
                }
            }
        }
        return ret;
    }

    public Map<String, Object> getStaffAllocationsForFlight(String flightNumber) {
        Map<String, Object> ret = new HashMap<String, Object>();
        if (this.staffAllocationsMap != null) {
            String depUAFT;
            Map<String, Object> depStaffAllocations;
            Map completeFlight;
            ret = this.staffAllocationsMap.get(flightNumber);
            if (ret != null) {
                ret = new HashMap<String, Object>(ret);
            }
            if ((completeFlight = (Map)this.flightEventsMap.get(flightNumber)) != null && (depStaffAllocations = this.staffAllocationsMap.get(depUAFT = (String)completeFlight.get("departureUAFT"))) != null) {
                depStaffAllocations = new HashMap<String, Object>(depStaffAllocations);
                if (ret != null) {
                    ret.putAll(depStaffAllocations);
                } else {
                    ret = depStaffAllocations;
                }
            }
        }
        return ret;
    }

    public void addGSEAllocationEvent(String key, Map<String, Map<String, String>> value) {
        if (value.isEmpty()) {
            log.error((Object)"GSE allocation event is empty, will not be added");
            return;
        }
        Map<String, Object> gseAllocationMap = this.gseAllocationsMap.get(key);
        Map<String, String> tmp = value.get("GSEAllocationGSEID");
        if (tmp == null || ((String)((Object)tmp)).length() == 0) {
            log.error((Object)"Could not find GSE ID in GSE allocation event, maybe it's not a GSE allocation event!!!");
            return;
        }
        String gseId = (String)((Object)tmp);
        if (gseAllocationMap == null) {
            gseAllocationMap = new HashMap<String, Object>();
            gseAllocationMap.put(gseId, value);
            this.gseAllocationsMap.put(key, gseAllocationMap);
        } else {
            gseAllocationMap.put(gseId, value);
        }
    }

    public Set getFlightsIDList() {
        return this.flightEventsMap.keySet();
    }

    public void deleteGSEAllocationEvent(String key, String gseID) {
        Map<String, Object> gseAllocationMap = this.gseAllocationsMap.get(key);
        if (gseAllocationMap == null) {
            log.error((Object)"GSE is already not allocated because flight cannot be recognized!");
        } else {
            Object value = gseAllocationMap.remove(gseID);
            if (value == null) {
                log.error((Object)("GSE allocation event could not be deleted, cause there was no GSE allocation event with the GSE ID: " + gseID + "!"));
            }
            if (gseAllocationMap.size() == 0) {
                this.gseAllocationsMap.remove(key);
            } else {
                this.gseAllocationsMap.put(key, gseAllocationMap);
            }
        }
    }

    public void addStaffAllocationEvent(String key, Map<String, Map<String, String>> value) {
        if (value.isEmpty()) {
            log.error((Object)"Staff allocation event is empty, will not be added");
            return;
        }
        Map<String, Object> staffAllocationMap = this.staffAllocationsMap.get(key);
        Map<String, String> tmp = value.get("StaffAllocationPersonalNumber");
        if (tmp == null || ((String)((Object)tmp)).length() == 0) {
            log.error((Object)"Could not find personal number in staff allocation event, maybe it's not a staff allocation event!!!");
            return;
        }
        String personalNumber = (String)((Object)tmp);
        if (staffAllocationMap == null) {
            staffAllocationMap = new HashMap<String, Object>();
            staffAllocationMap.put(personalNumber, value);
            this.staffAllocationsMap.put(key, staffAllocationMap);
        } else {
            staffAllocationMap.put(personalNumber, value);
        }
    }

    public void deleteStaffAllocationEvent(String key, String teamAllocationID) {
        Map<String, Object> staffAllocationMap = this.staffAllocationsMap.get(key);
        if (staffAllocationMap == null) {
            log.error((Object)"Staff is already not allocated because flight cannot be recognized!");
        } else {
            Object value = staffAllocationMap.remove(teamAllocationID);
            if (value == null) {
                log.error((Object)("Staff allocation event could not be deleted, cause there was no staff allocation event with the staff: " + teamAllocationID + "!"));
            }
            if (staffAllocationMap.size() == 0) {
                this.staffAllocationsMap.remove(key);
            } else {
                this.staffAllocationsMap.put(key, staffAllocationMap);
            }
        }
    }

    public void addFlightEvent(String key, Map<String, Object> value) {
        this.flightEventsMap.put(key, value);
        Object tmpStandId = value.get("fstd");
        String standId = "";
        if (tmpStandId != null) {
            standId = tmpStandId.toString().trim();
        }
        if (standId != null && standId.length() != 0) {
            HashMap<String, Map<String, Object>> stand = (HashMap<String, Map<String, Object>>)this.standsMap.get(standId);
            if (stand == null) {
                stand = new HashMap<String, Map<String, Object>>();
                stand.put(key, value);
                this.standsMap.put(standId, stand);
            } else {
                stand.put(key, value);
                this.standsMap.put(standId, stand);
            }
        }
    }

    public String addADFlight(String uaft, Map<String, Object> flightEvent) {
        if (flightEvent.get("arrivalUAFT") != null) {
            this.arrivalFlightEventsMap.put(uaft, flightEvent);
            return this.concateArrivalFlightEvent(uaft, flightEvent);
        }
        if (flightEvent.get("departureUAFT") != null) {
            this.departureFlightEventsMap.put(uaft, flightEvent);
            return this.concateDepartureFlightEvent(uaft, flightEvent);
        }
        return null;
    }

    public String concateArrivalFlightEvent(String arrivalUAFT, Map<String, Object> arrivalFlightEvent) {
        HashMap<String, Object> arrivalFlightEventCopy = new HashMap<String, Object>(arrivalFlightEvent);
        Set<String> departureUAFTs = this.departureFlightEventsMap.keySet();
        for (String departureUAFT : departureUAFTs) {
            HashMap<String, Object> nextDepartureFlightCopy = new HashMap<String, Object>(this.departureFlightEventsMap.get(departureUAFT));
            if (!nextDepartureFlightCopy.get("departureRKEY").equals(arrivalUAFT)) continue;
            nextDepartureFlightCopy.putAll(arrivalFlightEventCopy);
            nextDepartureFlightCopy.put("oid", arrivalUAFT);
            nextDepartureFlightCopy.put("FlightEventType", "FlightUpdate");
            this.addFlightEvent(arrivalUAFT, nextDepartureFlightCopy);
            return arrivalUAFT;
        }
        return null;
    }

    public String concateDepartureFlightEvent(String arrivalUAFT, Map<String, Object> departureFlightEvent) {
        HashMap<String, Object> departureFlightEventCopy = new HashMap<String, Object>(departureFlightEvent);
        String departureRKEY = (String)departureFlightEventCopy.get("departureRKEY");
        Set<String> arrivalUAFTs = this.arrivalFlightEventsMap.keySet();
        if (arrivalUAFTs.contains(departureRKEY)) {
            HashMap<String, Object> fittingArrivalFlightCopy = new HashMap<String, Object>(this.arrivalFlightEventsMap.get(departureRKEY));
            fittingArrivalFlightCopy.putAll(departureFlightEventCopy);
            fittingArrivalFlightCopy.put("oid", departureRKEY);
            fittingArrivalFlightCopy.put("FlightEventType", "FlightUpdate");
            this.addFlightEvent(departureRKEY, fittingArrivalFlightCopy);
            return departureRKEY;
        }
        return null;
    }

    public Map<String, Map<String, Object>> getAllADFlights() {
        HashMap<String, Map<String, Object>> allFlightEvents = new HashMap<String, Map<String, Object>>();
        allFlightEvents.putAll(this.arrivalFlightEventsMap);
        allFlightEvents.putAll(this.departureFlightEventsMap);
        return allFlightEvents;
    }

    public void addGeneralValue(String key, Object value) {
        this.mainMap.put(key, value);
    }

    public StandsDataFactory clone() {
        StandsDataFactory data = new StandsDataFactory();
        for (String flightEventNextKey : this.flightEventsMap.keySet()) {
            Map nextMapOfInnerMap = (Map)this.flightEventsMap.get(flightEventNextKey);
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            for (String nextKey : nextMapOfInnerMap.keySet()) {
                newMap.put(nextKey, nextMapOfInnerMap.get(nextKey));
            }
            data.addFlightEvent(flightEventNextKey, newMap);
        }
        for (String nextKey : this.mainMap.keySet()) {
            if (nextKey.equals("ALL_FLIGHT_EVENTS")) continue;
            data.addGeneralValue(nextKey, this.mainMap.get(nextKey));
        }
        return data;
    }

    public boolean deleteFlightEvent(String uaft) {
        boolean ret = false;
        Object flightEvent = this.flightEventsMap.remove(uaft);
        if (flightEvent != null) {
            Map flightEventMap = (Map)flightEvent;
            ret = this.deleteFlightEventFromStand(flightEventMap);
        } else {
            ret = false;
        }
        return ret;
    }

    public boolean deleteFlightEventFromStand(Map flightEventMap) {
        if (flightEventMap == null) {
            return false;
        }
        boolean ret = false;
        Object tmp = flightEventMap.get("oid");
        String uaft = "";
        if (tmp != null) {
            uaft = tmp.toString().trim();
        }
        if (uaft.length() == 0) {
            log.warn((Object)"flightEvent could not be deleted from standsMap, cause there was no flight id included");
            ret = false;
            return ret;
        }
        tmp = flightEventMap.get("fstd");
        String standId = "";
        if (tmp == null) {
            log.warn((Object)"flightEvent could not be deleted from standsMap, cause there was no stand id included");
            ret = false;
        } else {
            standId = ((String)tmp).trim();
            Object flightOfStand = this.standsMap.get(standId);
            if (flightOfStand == null) {
                log.warn((Object)("flightEvent could not be deleted from standsMap, cause there was no flight for given stand id: " + standId));
                ret = false;
            } else if (((Map)flightOfStand).remove(uaft) == null) {
                log.warn((Object)("flightEvent could not be deleted from standsMap, cause there was no flight for given flight id: " + uaft));
                ret = false;
            } else {
                ret = true;
            }
            Map actualStand = this.getCurrentFlightByStand(standId);
            if (actualStand == null) {
                this.updateState(standId, "StandAllocationStatus", "Empty");
            } else {
                this.updateState(standId, "StandAllocationStatus", "Taken");
            }
        }
        return ret;
    }

    public String getActualStandState(String standAllocationID, String stateID) {
        Map standStates = (Map)this.standsMap.get("StandStates");
        HashMap statesOfStand = (HashMap)standStates.get(standAllocationID);
        if (statesOfStand == null) {
            HashMap newStandMap = new HashMap();
            standStates.put(standAllocationID, newStandMap);
            statesOfStand = newStandMap;
        }
        if (statesOfStand.get(stateID) == null) {
            return "";
        }
        return (String)statesOfStand.get(stateID);
    }

    public Iterator getAllFlightEvents() {
        return this.flightEventsMap.values().iterator();
    }

    public Set<String> getAllStandIds() {
        Set<String> standIDsTemp = this.standsMap.keySet();
        HashSet<String> standIDs = new HashSet<String>(standIDsTemp);
        standIDs.remove("StandStates");
        return standIDs;
    }

    public Map<String, Object> getAllStates() {
        return (Map)this.standsMap.get("StandStates");
    }

    public int getAmountOfFlightEvents() {
        return this.flightEventsMap.values().size();
    }

    public Map getCurrentFlightByStand(String standAllocationID) {
        List<Map<String, Object>> currentFlights = this.getCurrentFlightsByStand(standAllocationID);
        if (currentFlights.size() == 0) {
            return null;
        }
        if (currentFlights.size() == 1) {
            return currentFlights.get(0);
        }
        Iterator<Map<String, Object>> currentFlightsIterator = currentFlights.iterator();
        Map<String, Object> currentFlightEventBuffer = null;
        while (currentFlightsIterator.hasNext()) {
            Map<String, Object> currentFlightEvent = currentFlightsIterator.next();
            if (currentFlightEventBuffer != null && (Long)currentFlightEvent.get("st") <= (Long)currentFlightEventBuffer.get("st")) continue;
            currentFlightEventBuffer = currentFlightEvent;
        }
        return currentFlightEventBuffer;
    }

    private List<Map<String, Object>> getCurrentFlightsByStand(String standAllocationID) {
        Collection standValues;
        ArrayList<Map<String, Object>> flights = new ArrayList<Map<String, Object>>();
        Map stand = (Map)this.standsMap.get(standAllocationID);
        if (stand != null && (standValues = stand.values()) != null) {
            for (Map flightEvent : new HashSet(standValues)) {
                long actualTime;
                long endTime;
                if (flightEvent.get("st") == null || flightEvent.get("et") == null || flightEvent.get("st").equals("") || flightEvent.get("et").equals("") || (Long)flightEvent.get("st") == 0L || (Long)flightEvent.get("et") == 0L) {
                    log.warn((Object)("start (" + flightEvent.get("st") + ") or endtime (" + flightEvent.get("et") + ") not available of flight with id: '" + flightEvent.get("oid") + "', jump to next flight"));
                    continue;
                }
                if (flightEvent.get("onbl") == null || flightEvent.get("onbl").toString().length() == 0 || (Long)flightEvent.get("onbl") == 0L || flightEvent.get("ofbl") != null && flightEvent.get("ofbl").toString().length() != 0 && (Long)flightEvent.get("ofbl") != 0L || (endTime = ((Long)flightEvent.get("et")).longValue()) < (actualTime = System.currentTimeMillis())) continue;
                flights.add(new HashMap(flightEvent));
            }
        }
        return flights;
    }

    public List<Map> getFlightEventsList(String standAllocationID) {
        ArrayList<Map> flightEvents = new ArrayList<Map>();
        Iterator allFlightEventsIterator = this.clone().getAllFlightEvents();
        while (allFlightEventsIterator.hasNext()) {
            Map flightEvent = (Map)allFlightEventsIterator.next();
            if (!((String)flightEvent.get("fstd")).equals(standAllocationID)) continue;
            flightEvents.add(flightEvent);
        }
        return flightEvents;
    }

    public Map<String, Object> getFlightEventsMap(String standAllocationID) {
        HashMap<String, Object> flightEvents = new HashMap<String, Object>();
        Iterator allFlightEventsIterator = this.clone().getAllFlightEvents();
        while (allFlightEventsIterator.hasNext()) {
            Map flightEvent = (Map)allFlightEventsIterator.next();
            if (!((String)flightEvent.get("fstd")).equals(standAllocationID)) continue;
            flightEvents.put((String)flightEvent.get("oid"), flightEvent);
        }
        return flightEvents;
    }

    public Map<String, Object> getAllConcatenatedFlightEvents() {
        return this.flightEventsMap;
    }

    public boolean isFlightIncludedInConcatenatedFlightList(String uaft) {
        return this.flightEventsMap.containsKey(uaft);
    }

    public Map getNextFlightByStand(String standAllocationID) {
        List<Map<String, Object>> nextFlights = this.getNextFlightsByStand(standAllocationID);
        if (nextFlights.size() == 0) {
            return null;
        }
        if (nextFlights.size() == 1) {
            return nextFlights.get(0);
        }
        Iterator<Map<String, Object>> nextFlightsIterator = nextFlights.iterator();
        Map<String, Object> nextFlightEventBuffer = null;
        while (nextFlightsIterator.hasNext()) {
            Map<String, Object> nextFlightEvent = nextFlightsIterator.next();
            if (nextFlightEventBuffer != null && (Long)nextFlightEvent.get("st") >= (Long)nextFlightEventBuffer.get("st")) continue;
            nextFlightEventBuffer = nextFlightEvent;
        }
        return nextFlightEventBuffer;
    }

    private List<Map<String, Object>> getNextFlightsByStand(String standAllocationID) {
        Collection standValues;
        ArrayList<Map<String, Object>> flights = new ArrayList<Map<String, Object>>();
        Map stand = (Map)this.standsMap.get(standAllocationID);
        if (stand != null && (standValues = stand.values()) != null) {
            for (Map flightEvent : new HashSet(standValues)) {
                long actualTime;
                long endTime;
                if (flightEvent.get("st") == null || flightEvent.get("et") == null || flightEvent.get("st").equals("") || flightEvent.get("et").equals("")) {
                    log.warn((Object)("start (" + flightEvent.get("st") + ") or endtime (" + flightEvent.get("et") + ") not available of flight with id: '" + flightEvent.get("oid") + "', jump to next flight"));
                    continue;
                }
                if (flightEvent.get("onbl") != null && flightEvent.get("onbl").toString().length() != 0 && (Long)flightEvent.get("onbl") != 0L || flightEvent.get("ofbl") != null && flightEvent.get("ofbl").toString().length() != 0 && (Long)flightEvent.get("ofbl") != 0L || (endTime = ((Long)flightEvent.get("et")).longValue()) <= (actualTime = System.currentTimeMillis())) continue;
                flights.add(new HashMap(flightEvent));
            }
        }
        return flights;
    }

    public Object getGeneralValue(String key) {
        return this.mainMap.get(key);
    }

    public Map getPreviousFlightByStand(String standAllocationID) {
        List prevFlights = this.getPreviousFlightsByStand(standAllocationID);
        if (prevFlights.size() == 0) {
            return null;
        }
        if (prevFlights.size() == 1) {
            return (Map)prevFlights.get(0);
        }
        Iterator prevFlightsIterator = prevFlights.iterator();
        Map prevFlightEventBuffer = null;
        while (prevFlightsIterator.hasNext()) {
            Map prevFlightEvent = (Map)prevFlightsIterator.next();
            if (prevFlightEventBuffer != null && (Long)prevFlightEvent.get("et") <= (Long)prevFlightEventBuffer.get("et")) continue;
            prevFlightEventBuffer = prevFlightEvent;
        }
        return prevFlightEventBuffer;
    }

    private List getPreviousFlightsByStand(String standAllocationID) {
        Collection standValues;
        ArrayList flights = new ArrayList();
        Map stand = (Map)this.standsMap.get(standAllocationID);
        if (stand != null && (standValues = stand.values()) != null) {
            for (Map flightEvent : new HashSet(standValues)) {
                long actualTime;
                long startTime;
                if (flightEvent.get("st") == null || flightEvent.get("et") == null || flightEvent.get("st").equals("") || flightEvent.get("et").equals("")) {
                    log.warn((Object)("start (" + flightEvent.get("st") + ") or endtime (" + flightEvent.get("et") + ") not available of flight with id: '" + flightEvent.get("oid") + "', jump to next flight"));
                    continue;
                }
                if (flightEvent.get("ofbl") == null || flightEvent.get("ofbl").toString().length() == 0 || (Long)flightEvent.get("ofbl") == 0L || (startTime = ((Long)flightEvent.get("st")).longValue()) >= (actualTime = System.currentTimeMillis())) continue;
                flights.add(new HashMap(flightEvent));
            }
        }
        return flights;
    }

    public long getServerTime() {
        return (Long)this.mainMap.get("ServerTime");
    }

    public Map<String, Object> getSpecificFlightEvent(String key) {
        Map tmp = (Map)this.flightEventsMap.get(key);
        return tmp;
    }

    public Map<String, Object> getTransferData() {
        return this.mainMap;
    }

    public void updateFlightEventWithStateInfo(Map<String, Object> newFlightUpdate) {
        String flightKey;
        Object tmpStandId = newFlightUpdate.get("fstd");
        String standId = "";
        if (tmpStandId != null) {
            standId = tmpStandId.toString().trim();
        }
        if ((flightKey = (String)newFlightUpdate.get("oid")) == null) {
            this.updateState(standId, "StandAllocationStatus", new String((String)newFlightUpdate.get("StandAllocationStatus")));
        } else {
            String standStateAllocation;
            Map<String, Object> flightEvent = this.getSpecificFlightEvent(flightKey);
            if (flightEvent != null) {
                for (String nextKey : newFlightUpdate.keySet()) {
                    flightEvent.put(nextKey, newFlightUpdate.get(nextKey));
                }
            } else {
                this.flightEventsMap.put(flightKey, newFlightUpdate);
            }
            if (standId != null && standId.length() != 0) {
                HashMap<String, Map<String, Object>> stand = (HashMap<String, Map<String, Object>>)this.standsMap.get(standId);
                if (stand == null) {
                    stand = new HashMap<String, Map<String, Object>>();
                    stand.put(flightKey, newFlightUpdate);
                    this.standsMap.put(standId, stand);
                } else {
                    stand.put(flightKey, newFlightUpdate);
                    this.standsMap.put(standId, stand);
                }
            }
            if ((standStateAllocation = (String)newFlightUpdate.get("StandAllocationStatus")) != null) {
                this.updateState(standId, "StandAllocationStatus", new String(standStateAllocation));
                newFlightUpdate.remove("StandAllocationStatus");
            }
        }
    }

    public void updateOnOffStateOfStands() {
        for (String nextStandID : new HashSet<String>(this.getAllStandIds())) {
            Map actualStand = this.getCurrentFlightByStand(nextStandID);
            Map nextStand = this.getNextFlightByStand(nextStandID);
            if (this.isFlightTMO(nextStand)) {
                this.updateState(nextStandID, "StandAllocationStatus", "TMO");
                continue;
            }
            if (actualStand == null) {
                this.updateState(nextStandID, "StandAllocationStatus", "Empty");
                continue;
            }
            this.updateState(nextStandID, "StandAllocationStatus", "Taken");
        }
    }

    public boolean isFlightTMO(Map flightEvent) {
        if (flightEvent == null) {
            return false;
        }
        String flightTypeArrivalString = (String)flightEvent.get("FlightTypeArrival");
        if (flightTypeArrivalString != null) {
            try {
                int flightTypeArrival = Integer.parseInt(flightTypeArrivalString);
                return flightTypeArrival >= 25 && flightTypeArrival < 39;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public void updateState(String standAllocationID, String stateID, String stateValue) {
        if (standAllocationID == null || standAllocationID.trim().length() == 0) {
            return;
        }
        Map standStates = (Map)this.standsMap.get("StandStates");
        HashMap<String, String> statesOfStand = (HashMap<String, String>)standStates.get(standAllocationID);
        if (statesOfStand == null) {
            HashMap<String, String> newStandMap = new HashMap<String, String>();
            standStates.put(standAllocationID, newStandMap);
            statesOfStand = newStandMap;
        }
        statesOfStand.put(stateID, stateValue);
    }

    public Map<String, Map<String, Object>> getArrivalFlightEventsMap() {
        return this.arrivalFlightEventsMap;
    }

    public Map<String, Map<String, Object>> getDepartureFlightEventsMap() {
        return this.departureFlightEventsMap;
    }
}

