/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.observable.connection;

import de.proveo.util.connection.ServletConnectionException;
import de.proveo.util.observable.interfaces.ClientListener;
import de.proveo.util.observable.interfaces.ClientWatchdog;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionReader
extends Thread {
    private static final Log log = LogFactory.getLog(ConnectionReader.class);
    private ClientWatchdog clientWatchdog = null;
    private ClientListener clientListener = null;
    private Object object = null;
    private ObjectInputStream objectInputStream = null;
    private boolean isRunning = true;

    public ConnectionReader() {
        this.setName("ConnectionReader");
    }

    public ConnectionReader(ObjectInputStream ois) {
        this.objectInputStream = ois;
        this.setName("ConnectionReader");
    }

    public void setListener(ClientListener cl) {
        this.clientListener = cl;
    }

    public void setWatchdog(ClientWatchdog cw) {
        this.clientWatchdog = cw;
    }

    public void closeThread() {
        this.isRunning = false;
        this.clientListener = null;
        log.debug((Object)("closeThread() - " + this.toString() + ": ConnectionReader-Object will be deleted by garbage collector!"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String method = "run(): ";
        while (this.isRunning) {
            try {
                this.object = this.objectInputStream.readObject();
                if (this.object != null && this.isRunning) {
                    this.forwardObject(this.object);
                }
                if (this.isRunning) continue;
                this.objectInputStream.close();
                this.objectInputStream = null;
                log.debug((Object)"ObjectInputStream closed.");
            }
            catch (IOException ioe) {
                log.debug((Object)(method + "lost connection to ObjectInputStream"));
                try {
                    if (this.isRunning && this.clientListener != null) {
                        log.warn((Object)(method + "try to re-connect to ObjectInputStream because of: IOException: " + ioe.getMessage()));
                        if (this.clientWatchdog != null) {
                            this.clientWatchdog.setIdle(true);
                        }
                        this.clientListener.reconnect(this);
                        continue;
                    }
                    log.debug((Object)(method + "thread finished"));
                }
                catch (ServletConnectionException sce) {
                    log.error((Object)(method + "Can not connect to servlet! (" + sce.getMessage() + ")"));
                }
                finally {
                    if (this.clientWatchdog == null) continue;
                    this.clientWatchdog.setIdle(false);
                }
            }
            catch (ClassNotFoundException cnfe) {
                log.error((Object)"run() runs into ClassNotFoundException:", (Throwable)cnfe);
            }
            finally {
                if (this.clientWatchdog == null || !this.clientWatchdog.isIdle()) continue;
                this.clientWatchdog.setIdle(false);
            }
        }
    }

    public void setObjectInputStream(ObjectInputStream ois) {
        this.objectInputStream = ois;
    }

    protected void finalize() {
        log.debug((Object)("finalize(): Object " + this.toString() + " deleted by garbage collector!"));
    }

    private void forwardObject(Object object) {
        try {
            this.clientListener.setObject(object);
        }
        catch (Exception e) {
            log.error((Object)("forwardObject() - " + this.toString() + ": Error while working with clientListener object!"), (Throwable)e);
        }
    }
}

