/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.math;

import de.proveo.util.math.Line;
import de.proveo.util.math.LineMath;
import de.proveo.util.math.NumberHelper;
import de.proveo.util.math.Point;
import de.proveo.util.math.PointImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Polygon
implements Serializable {
    private static final int MAX_RECURSIVE = 100;
    private static final double ADD_STEP = 0.01;
    private Collection points;

    public Polygon() {
        this(new ArrayList());
    }

    public Polygon(Collection points) {
        if (points == null) {
            throw new NullPointerException("collection points is null");
        }
        this.points = points;
    }

    public boolean equals(Object obj) {
        if (obj.getClass().getName().equals(Polygon.class.getName())) {
            return this.equals((Polygon)obj);
        }
        return false;
    }

    public boolean equals(Polygon polygon) {
        if (this.points.size() != polygon.points.size()) {
            return false;
        }
        Iterator myPointIt = this.points.iterator();
        Iterator otherPointIt = polygon.points.iterator();
        while (myPointIt.hasNext()) {
            Point otherPoint;
            Point myPoint = (Point)myPointIt.next();
            if (myPoint.equals(otherPoint = (Point)otherPointIt.next())) continue;
            return false;
        }
        return true;
    }

    public Point getXmaxPoint() {
        Point xMaxPoint = null;
        for (Point point : this.points) {
            if (xMaxPoint == null) {
                xMaxPoint = point;
                continue;
            }
            if (!(xMaxPoint.getX() < point.getX())) continue;
            xMaxPoint = point;
        }
        if (xMaxPoint == null) {
            throw new NullPointerException("no point found");
        }
        return xMaxPoint;
    }

    public int hashCode() {
        HashCodeBuilder hc = new HashCodeBuilder(39, 45);
        hc.append((Object)this.points);
        return hc.toHashCode();
    }

    public boolean isPointInside(Point checkPoint) {
        IsInsideTestResult result = this.isPointInsideImpl(checkPoint);
        if (result.isInside()) {
            return true;
        }
        if (result.isPointTouch()) {
            PointImpl newPoint = new PointImpl(checkPoint.getX() + 0.01, checkPoint.getY() + 0.01);
            boolean finish = false;
            int tryCounter = 1;
            while (true) {
                if (tryCounter >= 100) {
                    return false;
                }
                result = this.isPointInsideImpl(newPoint);
                if (result.isInside()) {
                    return true;
                }
                if (!result.isPointTouch()) {
                    return false;
                }
                double factor = 0.0;
                factor = NumberHelper.isEvenNumber(tryCounter) ? 1.0 : -1.0;
                double add = 0.01 * (double)tryCounter * factor;
                newPoint = new PointImpl(newPoint.getX() + add, newPoint.getY() + add);
                ++tryCounter;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int pointCounter = 1;
        for (Point p : this.points) {
            buffer.append(pointCounter);
            buffer.append(": ");
            buffer.append(p.toString());
            buffer.append("\n");
            ++pointCounter;
        }
        return buffer.toString();
    }

    protected IsInsideTestResult isPointInsideImpl(Point point) {
        int intersectCounter = 0;
        boolean pointTouch = false;
        Point firstPoint = null;
        Point beginTestEdge = null;
        Line s = new Line(point, new PointImpl(this.getXmaxPoint().getX() + 1.0, point.getY()));
        Iterator it = this.points.iterator();
        while (it.hasNext()) {
            if (firstPoint == null) {
                beginTestEdge = firstPoint = (Point)it.next();
                continue;
            }
            Point endTestEdge = (Point)it.next();
            Line e = new Line(beginTestEdge, endTestEdge);
            if (LineMath.intersect(s, e)) {
                ++intersectCounter;
            } else if (point.getY() == beginTestEdge.getY() || point.getY() == endTestEdge.getY()) {
                pointTouch = true;
            }
            beginTestEdge = endTestEdge;
        }
        Line e = new Line(beginTestEdge, firstPoint);
        if (LineMath.intersect(s, e)) {
            ++intersectCounter;
        } else if (point.getY() == beginTestEdge.getY() || point.getY() == firstPoint.getY()) {
            pointTouch = true;
        }
        IsInsideTestResult result = new IsInsideTestResult();
        if (pointTouch) {
            result.setPointTouch(true);
        } else {
            boolean inside = !NumberHelper.isEvenNumber(intersectCounter);
            result.setInside(inside);
        }
        return result;
    }

    private class IsInsideTestResult {
        private boolean inside;
        private boolean pointTouch;

        public boolean isInside() {
            return this.inside;
        }

        public boolean isPointTouch() {
            return this.pointTouch;
        }

        public void setInside(boolean inside) {
            this.inside = inside;
        }

        public void setPointTouch(boolean pointTouch) {
            this.pointTouch = pointTouch;
        }
    }
}

