/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.file;

import de.proveo.util.file.JavaFileFilter;
import java.io.File;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecursiveFileBrowser {
    private File rootFile = null;
    private JavaFileFilter javaFileFilter = null;
    private ArrayList<File> filteredFileList = null;

    public RecursiveFileBrowser(File startFile, String filterList) {
        this.rootFile = startFile;
        this.filteredFileList = new ArrayList();
        this.javaFileFilter = new JavaFileFilter(filterList);
        this.browseFiles(this.rootFile);
    }

    public RecursiveFileBrowser(String filepath, String filterList) {
        this.rootFile = new File(filepath);
        this.filteredFileList = new ArrayList();
        this.javaFileFilter = new JavaFileFilter(filterList);
        this.browseFiles(this.rootFile);
    }

    private void browseFiles(File startFile) {
        File[] directoryList;
        File[] childElements = startFile.listFiles(this.javaFileFilter);
        if (childElements != null) {
            for (int i = 0; i < childElements.length; ++i) {
                this.filteredFileList.add(childElements[i]);
            }
        }
        if ((directoryList = startFile.listFiles()) != null) {
            for (int i = 0; i < directoryList.length; ++i) {
                if (!directoryList[i].isDirectory()) continue;
                this.browseFiles(directoryList[i]);
            }
        }
    }

    public ArrayList<File> getFilteredFileList() {
        return this.filteredFileList;
    }
}

