/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.date;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateUtil {
    private static final Log log = LogFactory.getLog(DateUtil.class);
    Locale locale;
    Locale systemLocale;
    String datetimePattern = "dd MMM yy HH:mm:ss";
    String durationPattern = "D 0H:0m:0s";
    String timezoneString = "";
    TimeZone systemTimezone = TimeZone.getDefault();
    TimeZone timezone;
    boolean differingTimezone = false;
    private final int DAYS_PER_YEAR = 365;
    private final int HOURS_PER_DAY = 24;
    private final int MINUTES_PER_HOUR = 60;
    private final int MS_PER_SECOND = 1000;
    private final int SECONDS_PER_MINUTE = 60;
    private final long MS_PER_MINUTE = 60000L;
    private final long MS_PER_HOUR = 3600000L;
    private final long MS_PER_DAY = 86400000L;
    private final long MS_PER_YEAR = 31536000000L;
    private boolean dayExist;
    private boolean hourExist;
    private boolean millisecondExist;
    private boolean minuteExist;
    private boolean secondExist;
    private boolean yearExist;
    private long day;
    private long hour;
    private long millisecond;
    private long minute;
    private long second;
    private long year;

    public DateUtil() {
        this.init(Locale.getDefault(), TimeZone.getDefault(), Locale.getDefault(), TimeZone.getDefault());
    }

    public DateUtil(Locale l, TimeZone t) {
        this.init(l, t, Locale.getDefault(), TimeZone.getDefault());
    }

    public DateUtil(Locale l, TimeZone t, Locale sl, TimeZone st) {
        this.init(l, t, sl, st);
    }

    public static String getDatestring4Timestamp(long stamp) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(stamp));
        return cal.getTime().toString();
    }

    public String getDateTime(long stamp) {
        return this.getDateTime(stamp, this.datetimePattern);
    }

    public String getDateTime(long stamp, String pattern) {
        String sMethodName = "getDateTime(): ";
        String ret = "";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern, this.locale);
        sdf.setTimeZone(this.timezone);
        ret = sdf.format(new Date(stamp));
        return ret;
    }

    public String getDuration(long d) {
        return this.getDuration(d, this.durationPattern);
    }

    public String getDuration(long duration, String format) {
        this.calculateDurationElements(duration);
        String[] replace = new String[format.length()];
        boolean optional = false;
        boolean skipOptional = false;
        boolean skipDecided = false;
        String optionalBuffer = "";
        int digitCount = 1;
        boolean literal = false;
        int lastChar = 0;
        for (int i = 0; i < replace.length; ++i) {
            char c = format.charAt(i);
            if (literal && c != '\'') {
                replace[i] = new Character(c).toString();
            } else if (literal && c == '\'') {
                literal = false;
                if (lastChar == 39) {
                    replace[i] = new Character(c).toString();
                }
            } else if (c == '\'') {
                literal = true;
            } else if (c == '[') {
                optional = true;
                skipOptional = false;
                skipDecided = false;
                optionalBuffer = "";
            } else if (c == ']') {
                optional = false;
                skipOptional = false;
                skipDecided = false;
                optionalBuffer = "";
            } else if (c == '0') {
                ++digitCount;
            } else if (c == 'y') {
                replace[i] = this.format(this.year, optional, digitCount);
                if (optional && replace[i].length() == 0) {
                    skipOptional = true;
                } else {
                    replace[i] = optionalBuffer + replace[i];
                }
                skipDecided = true;
                digitCount = 1;
                this.yearExist = true;
            } else if (c == 'D') {
                if (!this.yearExist) {
                    this.day += this.year * 365L;
                    this.year = 0L;
                }
                replace[i] = this.format(this.day, optional, digitCount);
                if (optional && replace[i].length() == 0) {
                    skipOptional = true;
                } else {
                    replace[i] = optionalBuffer + replace[i];
                }
                skipDecided = true;
                digitCount = 1;
                this.dayExist = true;
            } else if (c == 'H') {
                if (!this.yearExist) {
                    this.day += this.year * 365L;
                    this.year = 0L;
                }
                if (!this.dayExist) {
                    this.hour += this.day * 24L;
                    this.day = 0L;
                }
                replace[i] = this.format(this.hour, optional, digitCount);
                if (optional && replace[i].length() == 0) {
                    skipOptional = true;
                } else {
                    replace[i] = optionalBuffer + replace[i];
                }
                skipDecided = true;
                digitCount = 1;
                this.hourExist = true;
            } else if (c == 'm') {
                if (!this.yearExist) {
                    this.day += this.year * 365L;
                    this.year = 0L;
                }
                if (!this.dayExist) {
                    this.hour += this.day * 24L;
                    this.day = 0L;
                }
                if (!this.hourExist) {
                    this.minute += this.hour * 60L;
                    this.hour = 0L;
                }
                replace[i] = this.format(this.minute, optional, digitCount);
                if (optional && replace[i].length() == 0) {
                    skipOptional = true;
                } else {
                    replace[i] = optionalBuffer + replace[i];
                }
                skipDecided = true;
                digitCount = 1;
                this.minuteExist = true;
            } else if (c == 's') {
                if (!this.yearExist) {
                    this.day += this.year * 365L;
                    this.year = 0L;
                }
                if (!this.dayExist) {
                    this.hour += this.day * 24L;
                    this.day = 0L;
                }
                if (!this.hourExist) {
                    this.minute += this.hour * 60L;
                    this.hour = 0L;
                }
                if (!this.minuteExist) {
                    this.second += this.minute * 60L;
                    this.minute = 0L;
                }
                replace[i] = this.format(this.second, optional, digitCount);
                if (optional && replace[i].length() == 0) {
                    skipOptional = true;
                } else {
                    replace[i] = optionalBuffer + replace[i];
                }
                skipDecided = true;
                digitCount = 1;
                this.secondExist = true;
            } else if (c == 'S') {
                if (!this.yearExist) {
                    this.day += this.year * 365L;
                    this.year = 0L;
                }
                if (!this.dayExist) {
                    this.hour += this.day * 24L;
                    this.day = 0L;
                }
                if (!this.hourExist) {
                    this.minute += this.hour * 60L;
                    this.hour = 0L;
                }
                if (!this.minuteExist) {
                    this.second += this.minute * 60L;
                    this.minute = 0L;
                }
                if (!this.secondExist) {
                    this.millisecond += this.second * 1000L;
                    this.second = 0L;
                }
                replace[i] = this.format(this.millisecond, optional, digitCount);
                if (optional && replace[i].length() == 0) {
                    skipOptional = true;
                } else {
                    replace[i] = optionalBuffer + replace[i];
                }
                skipDecided = true;
                digitCount = 1;
                this.millisecondExist = true;
            } else if (!optional || optional && !skipOptional) {
                if (skipDecided) {
                    replace[i] = new Character(c).toString();
                } else {
                    optionalBuffer = optionalBuffer + new Character(c).toString();
                }
            }
            lastChar = c;
        }
        String str = this.concat(replace);
        return str;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public String getTimezoneString() {
        return this.timezoneString;
    }

    public boolean isDifferingTimezone() {
        return this.differingTimezone;
    }

    public void setDatetimePattern(String pattern) {
        this.datetimePattern = pattern;
    }

    public void setDurationPattern(String pattern) {
        this.durationPattern = pattern;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setTimezone(TimeZone timezone) {
        this.timezone = timezone;
        this.buildTimeZoneString();
    }

    protected void init(Locale l, TimeZone t, Locale sl, TimeZone st) {
        this.locale = l;
        this.timezone = t;
        this.systemLocale = sl;
        this.systemTimezone = st;
        this.buildTimeZoneString();
    }

    public void buildTimeZoneString() {
        if (this.systemTimezone.getRawOffset() != this.timezone.getRawOffset()) {
            this.differingTimezone = true;
            log.debug((Object)("init(): differing time zone: requested=" + this.timezone.getID() + ", system=" + this.systemTimezone.getID()));
        }
        String tmp = this.timezone.getID();
        tmp = tmp + " " + this.timezone.getDisplayName(this.locale);
        String offset = " (GMT";
        int oset = this.timezone.getRawOffset() / 3600000;
        if (oset >= 0) {
            offset = offset + "+";
        }
        offset = offset + oset + ")";
        this.timezoneString = tmp + offset;
    }

    private void calculateDurationElements(long duration) {
        this.year = duration / 31536000000L;
        this.day = (duration -= this.year * 31536000000L) / 86400000L;
        this.hour = (duration -= this.day * 86400000L) / 3600000L;
        this.minute = (duration -= this.hour * 3600000L) / 60000L;
        this.second = (duration -= this.minute * 60000L) / 1000L;
        this.millisecond = duration -= this.second * 1000L;
    }

    private String concat(String[] str) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < str.length; ++i) {
            if (str[i] == null || str[i].length() <= 0) continue;
            buffer.append(str[i]);
        }
        return buffer.toString();
    }

    private String format(long value, boolean optional, int digitCount) {
        int digitDiv = 0;
        StringBuffer buffer = new StringBuffer();
        if (value > 0L || !optional) {
            buffer.append(value);
            digitDiv = digitCount - buffer.length();
            if (digitDiv > 0) {
                for (int i = 0; i < digitDiv; ++i) {
                    buffer.insert(0, "0");
                }
            }
        }
        return buffer.toString();
    }
}

