/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.token;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.TokenLength;

public class DefaultToken<T extends TokenId>
extends AbstractToken<T>
implements CharSequence {
    private static final int TOKEN_TEXT_TO_STRING_STACK_LENGTH;
    private static final boolean TOKEN_TEXT_TO_STRING_DUMP;
    private static final int INPUT_SOURCE_SUBSEQUENCE_THRESHOLD = 30;
    CharSequence tokenLengthOrCachedText;

    public DefaultToken(T id, int length) {
        super(id);
        assert (length > 0) : "Token length=" + length + " <= 0";
        this.tokenLengthOrCachedText = TokenLength.get(length);
    }

    public DefaultToken(T id) {
        super(id);
        this.tokenLengthOrCachedText = TokenLength.get(0);
    }

    @Override
    public int length() {
        return this.tokenLengthOrCachedText.length();
    }

    @Override
    protected String dumpInfoTokenType() {
        return "DefT";
    }

    @Override
    public synchronized CharSequence text() {
        CharSequence text;
        if (this.tokenLengthOrCachedText.getClass() == TokenLength.class) {
            if (!this.isRemoved()) {
                int len = this.tokenLengthOrCachedText.length();
                if (len >= 30) {
                    CharSequence inputSourceText = this.tokenList.inputSourceText();
                    int tokenOffset = this.tokenList.tokenOffset(this);
                    text = new InputSourceSubsequence(this, inputSourceText, tokenOffset, tokenOffset + len);
                } else {
                    text = this;
                }
            } else {
                text = null;
            }
        } else {
            text = this.tokenLengthOrCachedText;
        }
        return text;
    }

    @Override
    public final char charAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException("index=" + index + ", length=" + this.length());
        }
        if (this.tokenList == null) {
            throw new IndexOutOfBoundsException("index=" + index + ", length=" + this.length() + " but tokenList==null for token " + this.dumpInfo(null, null, false, true, 0));
        }
        int tokenOffset = this.tokenList.tokenOffset(this);
        return this.tokenList.inputSourceText().charAt(tokenOffset + index);
    }

    @Override
    public final synchronized CharSequence subSequence(int start, int end) {
        CharSequence text;
        int textLength = this.tokenLengthOrCachedText.length();
        CharSequenceUtilities.checkIndexesValid((int)start, (int)end, (int)textLength);
        if (this.tokenLengthOrCachedText.getClass() == TokenLength.class) {
            CharSequence inputSourceText = this.tokenList.inputSourceText();
            int tokenOffset = this.tokenList.tokenOffset(this);
            text = new InputSourceSubsequence(this, inputSourceText, tokenOffset + start, tokenOffset + end);
        } else {
            text = this.tokenLengthOrCachedText.subSequence(start, end);
        }
        return text;
    }

    @Override
    public synchronized String toString() {
        String textStr;
        if (TOKEN_TEXT_TO_STRING_DUMP) {
            StackElementArray.logStackIfNew();
        }
        if (this.tokenLengthOrCachedText.getClass() == TokenLength.class) {
            if (!this.isRemoved()) {
                TokenLength tokenLength = (TokenLength)this.tokenLengthOrCachedText;
                CharSequence inputSourceText = this.tokenList.inputSourceText();
                int nextCacheFactor = tokenLength.nextCacheFactor();
                int threshold = inputSourceText.getClass() == String.class ? 300 : 900;
                int tokenOffset = this.tokenList.tokenOffset(this);
                textStr = ((Object)inputSourceText.subSequence(tokenOffset, tokenOffset + tokenLength.length())).toString();
                this.tokenLengthOrCachedText = nextCacheFactor < threshold ? tokenLength.next(nextCacheFactor) : textStr;
            } else {
                textStr = "<null>";
            }
        } else {
            textStr = ((Object)this.tokenLengthOrCachedText).toString();
        }
        return textStr;
    }

    synchronized void tokenLengthNext() {
        if (this.tokenLengthOrCachedText.getClass() == TokenLength.class && !this.isRemoved()) {
            TokenLength tokenLength = (TokenLength)this.tokenLengthOrCachedText;
            CharSequence inputSourceText = this.tokenList.inputSourceText();
            int nextCacheFactor = tokenLength.nextCacheFactor();
            int threshold = inputSourceText.getClass() == String.class ? 300 : 900;
            int tokenOffset = this.tokenList.tokenOffset(this);
            if (nextCacheFactor < threshold) {
                this.tokenLengthOrCachedText = tokenLength.next(nextCacheFactor);
            } else {
                String textStr = ((Object)inputSourceText.subSequence(tokenOffset, tokenOffset + tokenLength.length())).toString();
                this.tokenLengthOrCachedText = textStr;
            }
        }
    }

    static {
        int val;
        try {
            val = Integer.parseInt(System.getProperty("org.netbeans.lexer.token.text.to.string"));
        }
        catch (NumberFormatException ex) {
            val = 0;
        }
        TOKEN_TEXT_TO_STRING_STACK_LENGTH = val;
        TOKEN_TEXT_TO_STRING_DUMP = val > 0;
    }

    private static final class InputSourceSubsequence
    implements CharSequence {
        private final DefaultToken<?> token;
        private final CharSequence inputSourceText;
        private final int start;
        private final int end;

        public InputSourceSubsequence(DefaultToken token, CharSequence text, int start, int end) {
            this.token = token;
            this.inputSourceText = text;
            this.start = start;
            this.end = end;
        }

        @Override
        public int length() {
            return this.end - this.start;
        }

        @Override
        public char charAt(int index) {
            CharSequenceUtilities.checkIndexValid((int)index, (int)this.length());
            try {
                return this.inputSourceText.charAt(this.start + index);
            }
            catch (IndexOutOfBoundsException ex) {
                Object inputSource;
                TokenHierarchyOperation<?, ?> op;
                StringBuilder sb = new StringBuilder(200);
                sb.append("Internal lexer error: index=").append(index).append(", length()=").append(this.length()).append("\n  start=").append(this.start).append(", end=").append(this.end).append("\n  tokenOffset=").append(this.token.offset(null)).append(", tokenLength=").append(this.token.length()).append(", inputSourceLength=").append(this.inputSourceText.length()).append('\n');
                TokenList tokenList = this.token.tokenList();
                if (tokenList != null && (op = tokenList.tokenHierarchyOperation()) != null && (inputSource = op.inputSource()) != null) {
                    sb.append("  inputSource: ").append(inputSource.getClass());
                    if (inputSource instanceof Document) {
                        Document doc = (Document)inputSource;
                        sb.append("  document-locked: ").append(DocumentUtilities.isReadLocked((Document)doc));
                    }
                    sb.append('\n');
                }
                throw new IllegalStateException(sb.toString(), ex);
            }
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            CharSequenceUtilities.checkIndexesValid((CharSequence)this, (int)start, (int)end);
            return new InputSourceSubsequence(this.token, this.inputSourceText, this.start + start, this.start + end);
        }

        @Override
        public String toString() {
            if (TOKEN_TEXT_TO_STRING_DUMP) {
                StackElementArray.logStackIfNew();
            }
            this.token.tokenLengthNext();
            String textStr = ((Object)this.inputSourceText.subSequence(this.start, this.end)).toString();
            return textStr;
        }
    }

    private static final class StackElementArray {
        private static final Set<StackElementArray> stacks = DefaultToken.access$000() ? Collections.synchronizedSet(new HashSet()) : null;
        private final StackTraceElement[] stackTrace;
        private final int hashCode;

        static void logStackIfNew() {
            Exception ex = new Exception();
            StackTraceElement[] elems = ex.getStackTrace();
            int startIndex = 2;
            int endIndex = Math.min(elems.length, startIndex + TOKEN_TEXT_TO_STRING_STACK_LENGTH);
            StackTraceElement[] reducedElems = new StackTraceElement[endIndex - startIndex];
            System.arraycopy(elems, startIndex, reducedElems, 0, endIndex - startIndex);
            StackElementArray stackElementArray = new StackElementArray(reducedElems);
            if (!stacks.contains(stackElementArray)) {
                stacks.add(stackElementArray);
                Logger.getLogger(StackElementArray.class.getName()).log(Level.INFO, "Token.text().toString() called", ex);
            }
        }

        public StackElementArray(StackTraceElement[] stackTrace) {
            this.stackTrace = stackTrace;
            int hc = 0;
            for (int i = 0; i < stackTrace.length; ++i) {
                hc ^= stackTrace[i].hashCode();
            }
            this.hashCode = hc;
        }

        int length() {
            return this.stackTrace.length;
        }

        StackTraceElement element(int i) {
            return this.stackTrace[i];
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StackElementArray)) {
                return false;
            }
            StackElementArray sea = (StackElementArray)obj;
            if (sea.length() != this.length()) {
                return false;
            }
            for (int i = 0; i < this.stackTrace.length; ++i) {
                if (this.element(i).equals(sea.element(i))) continue;
                return false;
            }
            return true;
        }
    }
}

