/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import junit.framework.Assert;

final class ControlFlow {
    ControlFlow() {
    }

    static void registerSwitches(Logger listenTo, Logger reportTo, URL url, int timeout) throws IOException {
        int ch;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        InputStream is = url.openStream();
        while ((ch = is.read()) != -1) {
            os.write(ch);
        }
        os.close();
        is.close();
        ControlFlow.registerSwitches(listenTo, reportTo, new String(os.toByteArray(), "utf-8"), timeout);
    }

    static void registerSwitches(Logger listenTo, Logger reportTo, String order, int timeout) {
        int thr;
        LinkedList<Switch> switches = new LinkedList<Switch>();
        HashMap<String, Pattern> exprs = new HashMap<String, Pattern>();
        int pos = 0;
        while ((thr = order.indexOf("THREAD:", pos)) != -1) {
            int end;
            int msg = order.indexOf("MSG:", thr);
            if (msg == -1) {
                Assert.fail((String)("After THREAD: there must be MSG: " + order.substring(thr)));
            }
            if ((end = order.indexOf("THREAD:", msg)) == -1) {
                end = order.length();
            }
            String thrName = order.substring(pos + 7, msg).trim();
            String msgText = order.substring(msg + 4, end).trim();
            Pattern p = (Pattern)exprs.get(msgText);
            if (p == null) {
                p = Pattern.compile(msgText);
                exprs.put(msgText, p);
            }
            Switch s = new Switch(thrName, p);
            switches.add(s);
            pos = end;
        }
        ErrManager h = new ErrManager(switches, listenTo, reportTo, timeout);
        listenTo.addHandler(h);
    }

    private static final class ErrManager
    extends Handler {
        private LinkedList<Switch> switches;
        private int timeout;
        private Map<String, Thread> threads = new HashMap<String, Thread>();
        private Logger msg;
        private Logger assigned;

        public ErrManager(LinkedList<Switch> switches, Logger assigned, Logger msg, int t) {
            this.switches = switches;
            this.msg = msg;
            this.timeout = t;
            this.assigned = assigned;
            this.setLevel(Level.FINEST);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void publish(LogRecord record) {
            if (this.switches == null) {
                this.assigned.removeHandler(this);
                return;
            }
            String s = record.getMessage();
            if (s != null && record.getParameters() != null) {
                s = MessageFormat.format(s, record.getParameters());
            }
            boolean log = this.msg != null;
            boolean expectingMsg = false;
            while (true) {
                LinkedList<Switch> linkedList = this.switches;
                synchronized (linkedList) {
                    if (this.switches.isEmpty()) {
                        return;
                    }
                    Switch w = this.switches.getFirst();
                    String threadName = Thread.currentThread().getName();
                    boolean foundMatch = false;
                    if (w.matchesThread()) {
                        if (!w.matchesMessage(s)) {
                            return;
                        }
                        this.switches.removeFirst();
                        if (this.switches.isEmpty()) {
                            this.switches.notifyAll();
                            return;
                        }
                        w = this.switches.getFirst();
                        if (w.matchesThread()) {
                            return;
                        }
                        expectingMsg = true;
                        foundMatch = true;
                    } else {
                        for (Switch check : this.switches) {
                            if (!check.matchesMessage(s)) continue;
                            expectingMsg = true;
                            break;
                        }
                    }
                    Thread t = this.threads.get(w.name);
                    if (t != null) {
                        if (log) {
                            this.loginternal("t: " + threadName + " interrupts: " + t.getName());
                        }
                        t.interrupt();
                    }
                    this.threads.put(threadName, Thread.currentThread());
                    if (!expectingMsg) {
                        return;
                    }
                    Thread.interrupted();
                    try {
                        if (log) {
                            this.loginternal("t: " + threadName + " log: " + s + " waiting");
                        }
                        this.switches.wait(this.timeout);
                        if (log) {
                            this.loginternal("t: " + threadName + " log: " + s + " timeout");
                        }
                        return;
                    }
                    catch (InterruptedException ex) {
                        if (log) {
                            this.loginternal("t: " + threadName + " log: " + s + " interrupted");
                        }
                        if (foundMatch) {
                            return;
                        }
                    }
                }
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }

        private void loginternal(String string) {
            this.msg.info(string);
        }
    }

    private static final class Switch {
        private Pattern msg;
        private String name;

        public Switch(String n, Pattern m) {
            this.name = n;
            this.msg = m;
        }

        public boolean matchesThread() {
            String thr = Thread.currentThread().getName();
            return this.name.equals(thr);
        }

        public boolean matchesMessage(String logMsg) {
            return this.msg.matcher(logMsg).matches();
        }

        public String toString() {
            return "Switch[" + this.name + "]: " + this.msg;
        }
    }
}

