/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.lucene;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.parsing.lucene.SupportAccessor;
import org.netbeans.modules.parsing.lucene.support.Index;
import org.netbeans.modules.parsing.lucene.support.IndexReaderInjection;
import org.netbeans.modules.parsing.lucene.support.StoppableConvertor;

abstract class StoppableConvertorAdapter<C, T> {
    protected final StoppableConvertor<C, T> convertor;

    private StoppableConvertorAdapter(@NonNull StoppableConvertor<C, T> convertor) {
        assert (convertor != null);
        this.convertor = convertor;
    }

    abstract T convert(TermEnum var1) throws StoppableConvertor.Stop;

    final void setIndexReader(@NullAllowed IndexReader in) {
        if (this.convertor instanceof IndexReaderInjection) {
            ((IndexReaderInjection)((Object)this.convertor)).setIndexReader(in);
        }
    }

    static <T> StoppableConvertorAdapter<Term, T> forTerms(StoppableConvertor<Term, T> convertor) {
        return new TermAdapter<T>(convertor);
    }

    static <T> StoppableConvertorAdapter<Index.WithTermFrequencies.TermFreq, T> forFreqs(StoppableConvertor<Index.WithTermFrequencies.TermFreq, T> convertor) {
        return new FreqAdapter<T>(convertor);
    }

    private static class FreqAdapter<T>
    extends StoppableConvertorAdapter<Index.WithTermFrequencies.TermFreq, T> {
        private final SupportAccessor accessor = SupportAccessor.getInstance();
        private final Index.WithTermFrequencies.TermFreq tf = this.accessor.newTermFreq();

        FreqAdapter(@NonNull StoppableConvertor<Index.WithTermFrequencies.TermFreq, T> convertor) {
            super(convertor);
        }

        @Override
        T convert(TermEnum terms) throws StoppableConvertor.Stop {
            Term currentTerm = terms.term();
            if (currentTerm == null) {
                return null;
            }
            int freq = terms.docFreq();
            return (T)this.convertor.convert(this.accessor.setTermFreq(this.tf, currentTerm, freq));
        }
    }

    private static class TermAdapter<T>
    extends StoppableConvertorAdapter<Term, T> {
        TermAdapter(@NonNull StoppableConvertor<Term, T> convertor) {
            super(convertor);
        }

        @Override
        T convert(@NonNull TermEnum terms) throws StoppableConvertor.Stop {
            Term currentTerm = terms.term();
            if (currentTerm == null) {
                return null;
            }
            return (T)this.convertor.convert(currentTerm);
        }
    }
}

