/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.ssh.service.gui.impl;

import de.proveo.idm.core.gui.util.TableEditorStopper;
import de.proveo.idm.ssh.service.gui.impl.DropTableListener;
import de.proveo.idm.ssh.service.gui.impl.SSHPortForwardingTableModel;
import de.proveo.idm.ssh.service.util.ParseUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class TunnelEditorPanel
extends JPanel
implements TableModelListener,
PropertyChangeListener,
HelpCtx.Provider {
    public static final String PROP_DATA_CHANGED = "data_changed";
    private SSHPortForwardingTableModel model;
    private List<String> invalidURL = new ArrayList<String>();
    private PropertyEnv env;
    private PropertyEditorSupport editor;
    private JButton addButton;
    private JLabel infoLbl;
    private JPanel jPanel1;
    private JButton removeButton;
    private JScrollPane tablePane;
    private JTable tunnelTable;

    private TunnelEditorPanel() {
        this.initComponents();
        TableEditorStopper.ensureEditingStopWhenTableLosesFocus((JTable)this.tunnelTable);
        this.model = (SSHPortForwardingTableModel)this.tunnelTable.getModel();
        this.model.addTableModelListener(this);
        this.infoLbl.setText("");
    }

    public TunnelEditorPanel(PropertyEnv env, PropertyEditorSupport editor) {
        this();
        this.env = env;
        this.editor = editor;
        env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        env.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public Collection<String> getValues() {
        ArrayList<String> tunnels = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            String address = (String)this.model.getValueAt(i, 0);
            Integer port = (Integer)this.model.getValueAt(i, 1);
            builder.append(address);
            builder.append(":");
            builder.append(port);
            tunnels.add(builder.toString());
            builder.delete(0, builder.length());
        }
        return tunnels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(Collection col) {
        ParseUtil util = new ParseUtil();
        StringBuilder builder = new StringBuilder();
        this.invalidURL.clear();
        for (Object o : col) {
            String address = o.toString();
            try {
                util.parseURLElements(address);
                builder.append(util.getUser());
                String password = null;
                if (password != null && password.length() > 0) {
                    builder.append(":");
                    builder.append(password);
                }
                builder.append("@");
                builder.append(util.getHost());
                this.model.addDefaultElement(builder.toString(), util.getPort());
                builder.delete(0, builder.length());
            }
            catch (Exception ex) {}
            continue;
            finally {
                this.checkForInvalidURLs();
            }
        }
    }

    private void checkForInvalidURLs() {
        this.invalidURL.clear();
        Collection<String> values = this.getValues();
        ParseUtil util = new ParseUtil();
        for (String value : values) {
            try {
                util.parseURLElements(value);
                if (util.getPassword() == null) continue;
                this.invalidURL.add(value);
            }
            catch (IllegalArgumentException ex) {
                this.invalidURL.add(value);
            }
        }
        if (!this.invalidURL.isEmpty()) {
            String msg = NbBundle.getMessage(TunnelEditorPanel.class, (String)"TunnelEditorPanel.error.invalidURL");
            this.infoLbl.setText(msg + " " + this.invalidURL.get(0));
            this.env.setState(PropertyEnv.STATE_INVALID);
        } else {
            this.infoLbl.setText("");
            if (this.env.getState().equals(PropertyEnv.STATE_INVALID)) {
                this.env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            }
        }
    }

    public int getTableSize() {
        return this.model.getRowCount();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.firePropertyChange(PROP_DATA_CHANGED, 0, 1);
        this.checkForInvalidURLs();
    }

    private void initComponents() {
        this.tablePane = new JScrollPane();
        this.tunnelTable = new JTable();
        this.jPanel1 = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.infoLbl = new JLabel();
        this.setLayout(new BorderLayout());
        this.tunnelTable.setModel(new SSHPortForwardingTableModel());
        this.tunnelTable.setColumnSelectionAllowed(true);
        this.tunnelTable.setDragEnabled(true);
        this.tunnelTable.setSelectionMode(2);
        DropTableListener dtListener = new DropTableListener(this.tunnelTable);
        new DropTarget(this.tunnelTable, dtListener);
        this.tablePane.setViewportView(this.tunnelTable);
        this.tunnelTable.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.add((Component)this.tablePane, "Center");
        this.addButton.setText("+");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelEditorPanel.this.addButtonActionPerformed(evt);
            }
        });
        this.removeButton.setText("-");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelEditorPanel.this.removeButtonActionPerformed(evt);
            }
        });
        this.infoLbl.setForeground(new Color(255, 0, 0));
        this.infoLbl.setText("Error Message goes here");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoLbl).addContainerGap(131, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addButton).addComponent(this.removeButton).addComponent(this.infoLbl)).addContainerGap(-1, Short.MAX_VALUE)));
        this.add((Component)this.jPanel1, "Last");
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.model.addDefaultElement("", 22);
        this.model.fireTableStructureChanged();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int row = this.tunnelTable.getSelectedRow();
        if (row != -1) {
            this.model.removeElementAt(row);
        } else if (this.tunnelTable.getRowCount() > 0) {
            this.model.removeLast();
        }
        this.model.fireTableStructureChanged();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("state") && evt.getNewValue().equals(PropertyEnv.STATE_VALID)) {
            this.editor.setValue(this.getValues());
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("de.proveo.idm.ssh.service.sshcfg");
    }
}

