/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.ssh.service;

import de.proveo.idm.ssh.service.util.ParseUtil;

public class TunnelSegment {
    private String user;
    private String password;
    private String remoteHost;
    private TunnelSegment parent;
    private int remotePort;
    private int localPort = -1;
    private int connectedUsers = 0;
    private boolean isConnected;

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setConnected(boolean isConnected) {
        this.isConnected = isConnected;
    }

    public TunnelSegment(String url) {
        ParseUtil util = new ParseUtil();
        util.parseURLElements(url);
        this.user = util.getUser();
        this.password = null;
        this.remoteHost = util.getHost();
        this.remotePort = util.getPort();
    }

    public TunnelSegment(String user, String host, int port) {
        this.user = user;
        this.remoteHost = host;
        this.remotePort = port;
    }

    public TunnelSegment(String user, String host, String password, int port) {
        this(user, host, port);
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUser() {
        return this.user;
    }

    public String getHost() {
        return this.remoteHost;
    }

    public int getPort() {
        return this.remotePort;
    }

    public void setLocalPort(int port) {
        this.localPort = port;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TunnelSegment) {
            if (obj == this) {
                return true;
            }
            TunnelSegment other = (TunnelSegment)obj;
            if (this.remotePort != other.getPort()) {
                return false;
            }
            if (this.localPort != other.getLocalPort()) {
                return false;
            }
            if (!this.remoteHost.equals(other.getHost())) {
                return false;
            }
            return this.user.equals(other.getUser());
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        hash += this.remotePort;
        hash += this.localPort;
        hash += this.remoteHost.hashCode();
        return hash += this.user.hashCode();
    }

    public void increaseUserCount() {
        ++this.connectedUsers;
    }

    public void decreaseUserCount() {
        --this.connectedUsers;
    }

    public int getUserCount() {
        return this.connectedUsers;
    }

    public void setParent(TunnelSegment parent) {
        this.parent = parent;
    }

    public TunnelSegment getParent() {
        return this.parent;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("User: ");
        builder.append(this.user);
        builder.append(" - Host: ");
        builder.append(this.remoteHost);
        builder.append(":");
        builder.append(this.remotePort);
        builder.append(" - Local Port: ");
        builder.append(this.localPort);
        builder.append(" - User Count: ");
        builder.append(this.connectedUsers);
        return builder.toString();
    }
}

