/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.ssh.service;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import de.proveo.idm.ssh.service.MySSHUserInfo;
import de.proveo.idm.ssh.service.SSHConnection;
import de.proveo.infoman.remote.InfomanRAS;
import de.proveo.infoman.remote.SSHUserInfo;
import de.proveo.infoman.remote.util.TempFileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public final class SSHConnectionFactory {
    private static final Logger log = Logger.getLogger(SSHConnectionFactory.class.getName());
    public static final int DEFAULT_SSH_TRANSFER_TIMEOUT = 120000;
    public static final int DEFAULT_SSH_TIMEOUT = 60000;

    public static InfomanRAS createDefaultInfomanRAS(String url) {
        MySSHUserInfo userInfo = new MySSHUserInfo();
        InfomanRAS ras = new InfomanRAS();
        ras.setUserInfo((SSHUserInfo)userInfo);
        ras.setConnectingTimeout(60000);
        ras.setTimeout(120000);
        ras.setTransferTimeout(120000);
        if (url != null) {
            ras.setURL(url);
            userInfo.setConnetingToUrl(url);
            userInfo.setType(0);
        }
        List<InputStream> privKeys = SSHConnection.getDefaultPrivateKeys();
        for (InputStream privKey : privKeys) {
            try {
                ras.addPrivateKey(privKey);
            }
            catch (IOException ex) {
                log.log(Level.WARNING, "Couldn't add private key file", ex);
            }
        }
        if (!SSHConnection.DEFAULT_KNOWN_HOSTS_FILE.exists()) {
            try {
                if (!SSHConnection.DEFAULT_KNOWN_HOSTS_FILE.createNewFile()) {
                    throw new IOException("Failed to create known hosts file: " + SSHConnection.DEFAULT_KNOWN_HOSTS_FILE.getAbsolutePath());
                }
            }
            catch (Exception ex) {
                try {
                    FileUtils.touch((File)SSHConnection.DEFAULT_KNOWN_HOSTS_FILE);
                }
                catch (Exception ex2) {
                    log.log(Level.WARNING, "Couldn't create known_hosts file", ex2);
                }
            }
        }
        if (SSHConnection.DEFAULT_KNOWN_HOSTS_FILE.exists()) {
            try {
                ras.setKnownHosts(SSHConnection.DEFAULT_KNOWN_HOSTS_FILE.getAbsolutePath());
            }
            catch (IOException ex) {
                log.log(Level.WARNING, "Couldn't set known_hosts file", ex);
            }
        }
        try {
            File tmpDir = TempFileUtil.createTempDir((String)"infomanLocal");
            ras.setLocalTargetDir(tmpDir.getAbsolutePath());
        }
        catch (IOException ex) {
            log.log(Level.WARNING, "Could not create temporary SSH target directory", ex);
        }
        return ras;
    }

    public static Session createDefaultSession(String username, String host, int port) throws IOException {
        try {
            MySSHUserInfo userInfo = new MySSHUserInfo();
            userInfo.reInit();
            userInfo.setConnetingToUrl(username + "@" + host + ":" + port);
            userInfo.setType(2);
            JSch jsch = new JSch();
            Session session = jsch.getSession(username, host, port);
            session.setConfig("StrictHostKeyChecking", "no");
            session.setUserInfo((UserInfo)userInfo);
            List<InputStream> privKeys = SSHConnection.getDefaultPrivateKeys();
            for (InputStream privKey : privKeys) {
                try {
                    SSHConnectionFactory.addPrivateKey(jsch, new InputStreamReader(privKey));
                }
                catch (IOException ex) {
                    log.log(Level.WARNING, "Couldn't add private key file", ex);
                }
            }
            if (!SSHConnection.DEFAULT_KNOWN_HOSTS_FILE.exists()) {
                try {
                    if (!SSHConnection.DEFAULT_KNOWN_HOSTS_FILE.createNewFile()) {
                        throw new IOException("Failed to create known hosts file: " + SSHConnection.DEFAULT_KNOWN_HOSTS_FILE.getAbsolutePath());
                    }
                }
                catch (Exception ex) {
                    try {
                        FileUtils.touch((File)SSHConnection.DEFAULT_KNOWN_HOSTS_FILE);
                    }
                    catch (Exception ex2) {
                        log.log(Level.WARNING, "Couldn't create known_hosts file", ex2);
                    }
                }
            }
            if (SSHConnection.DEFAULT_KNOWN_HOSTS_FILE.exists()) {
                try {
                    jsch.setKnownHosts(SSHConnection.DEFAULT_KNOWN_HOSTS_FILE.getAbsolutePath());
                }
                catch (JSchException ex) {
                    log.log(Level.WARNING, "Couldn't set known_hosts file", ex);
                }
            }
            session.connect(60000);
            return session;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private static void addPrivateKey(JSch jsch, Reader reader) throws IOException {
        BufferedReader br = null;
        String privateKey = "";
        try {
            br = new BufferedReader(reader);
            boolean len = false;
            while (br.ready()) {
                privateKey = privateKey + br.readLine() + "\n";
            }
        }
        catch (IOException ex) {
            privateKey = null;
            throw new IOException(ex);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignore) {}
            }
        }
        if (privateKey != null) {
            try {
                jsch.addIdentity(reader + "", privateKey.getBytes(), null, "".getBytes());
            }
            catch (JSchException ex) {
                throw new IOException(ex);
            }
        }
    }
}

