/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.ssh.service;

import com.jcraft.jsch.UIKeyboardInteractive;
import de.proveo.idm.core.gui.navigation.api.Credentials;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.ssh.service.SSHConnection;
import de.proveo.infoman.remote.SSHUserInfo;
import javax.swing.Icon;
import org.apache.commons.lang.StringUtils;

public class MySSHUserInfo
extends SSHUserInfo
implements UIKeyboardInteractive {
    private String user = null;

    public String getPassphrase() {
        return this.passphrase;
    }

    public String getPassword() {
        return this.passwd;
    }

    public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
        String[] response = new String[prompt.length];
        for (int i = 0; i < prompt.length; ++i) {
            Icon leftIcon;
            String passKey = "ssh.keyboardInteractive.prompt" + i + "." + this.host;
            if (this.user != null) {
                passKey = "ssh.keyboardInteractive.prompt" + i + "." + this.host + ".%s";
            }
            Icon rightIcon = DialogUtil.DEFAULT_LOGIN_IMAGE_RIGHT;
            switch (this.deviceType) {
                case 0: {
                    leftIcon = SSHConnection.INFOMAN_LOGIN_IMAGE;
                    break;
                }
                case 2: {
                    leftIcon = SSHConnection.SERVER_LOGIN_IMAGE;
                    break;
                }
                default: {
                    leftIcon = DialogUtil.DEFAULT_LOGIN_IMAGE_LEFT;
                }
            }
            Credentials cred = DialogUtil.showLoginDialog((String)("Password for " + this.host), (String)"Enter Password", (String)passKey, (String)this.user, (boolean)false, (Icon)leftIcon, (Icon)rightIcon);
            if (cred == null) {
                return null;
            }
            response[i] = new String(cred.getPassword());
        }
        return response;
    }

    public boolean promptPassphrase(String message) {
        Icon leftIcon;
        if (this.host != null) {
            message = "Passphrase for " + this.host + ":";
        }
        String passKey = "ssh.passphrase." + this.host;
        if (this.user != null) {
            passKey = "ssh.passphrase." + this.host + ".%s";
        }
        Icon rightIcon = DialogUtil.DEFAULT_LOGIN_IMAGE_RIGHT;
        switch (this.deviceType) {
            case 0: {
                leftIcon = SSHConnection.INFOMAN_LOGIN_IMAGE;
                break;
            }
            case 2: {
                leftIcon = SSHConnection.SERVER_LOGIN_IMAGE;
                break;
            }
            default: {
                leftIcon = DialogUtil.DEFAULT_LOGIN_IMAGE_LEFT;
            }
        }
        Credentials cred = DialogUtil.showLoginDialog((String)message, (String)"Enter Passphrase", (String)passKey, (String)this.user, (boolean)false, (Icon)leftIcon, (Icon)rightIcon);
        if (cred != null) {
            this.passphrase = new String(cred.getPassword());
            return true;
        }
        return false;
    }

    public boolean promptPassword(String message) {
        Icon leftIcon;
        if (this.host != null) {
            message = "Password for " + this.host + ":";
        }
        String passKey = "ssh.password." + this.host;
        if (this.user != null) {
            passKey = "ssh.password." + this.host + ".%s";
        }
        Icon rightIcon = DialogUtil.DEFAULT_LOGIN_IMAGE_RIGHT;
        switch (this.deviceType) {
            case 0: {
                leftIcon = SSHConnection.INFOMAN_LOGIN_IMAGE;
                break;
            }
            case 2: {
                leftIcon = SSHConnection.SERVER_LOGIN_IMAGE;
                break;
            }
            default: {
                leftIcon = DialogUtil.DEFAULT_LOGIN_IMAGE_LEFT;
            }
        }
        Credentials cred = DialogUtil.showLoginDialog((String)message, (String)"Enter Password", (String)passKey, (String)this.user, (boolean)false, (Icon)leftIcon, (Icon)rightIcon);
        if (cred != null) {
            this.passwd = new String(cred.getPassword());
            return true;
        }
        return false;
    }

    public boolean promptYesNo(String str) {
        Object result = DialogUtil.showMessageDialog((Object)str, (String)"Warning", (boolean)true, (int)2, (int)0);
        return DialogUtil.YES_OPTION.equals(result);
    }

    public void reInit() {
        this.host = null;
        this.passphrase = null;
        this.passwd = null;
    }

    public void setConnetingToUrl(String url) {
        this.host = url;
        this.user = null;
        if (this.host != null && this.host.contains("@")) {
            String[] split = StringUtils.split((String)this.host, (String)"@");
            this.user = split[0];
            if (this.user.contains(":")) {
                split = StringUtils.split((String)this.user, (String)":");
                this.user = split[0];
            }
        }
    }

    public void setType(int deviceType) {
        super.setType(deviceType);
    }

    public void setPasswd(String password) {
        this.passwd = password;
    }

    public void showMessage(String message) {
        DialogUtil.showMessageDialog((Object)message, null, (boolean)true, (int)-1, (int)-1);
    }
}

