/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.analysis.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import org.netbeans.modules.analysis.ui.AnalysisResultTopComponent;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.cookies.OpenCookie;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class NextError
extends AbstractAction
implements PropertyChangeListener {
    private AnalysisResultTopComponent comp;

    public NextError(AnalysisResultTopComponent comp) {
        this.comp = comp;
        this.comp.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public boolean isEnabled() {
        boolean enabled;
        if (this.comp.nodesForNext == null) {
            return !this.comp.empty;
        }
        Node node = this.getNextMeaningfullNode();
        boolean bl = enabled = node != null;
        if (node != null) {
            this.comp.nodesForNext.add(0, node);
        }
        return enabled;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Node node = this.getNextMeaningfullNode();
        if (node == null) {
            this.fireEnabledChanged();
            return;
        }
        OpenCookie oc = (OpenCookie)node.getLookup().lookup(OpenCookie.class);
        assert (oc != null);
        this.addToSeenNodes(node);
        try {
            this.comp.getExplorerManager().setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        oc.open();
        this.fireEnabledChanged();
    }

    private Node getNextMeaningfullNode() {
        if (this.comp.nodesForNext == null) {
            this.comp.nodesForNext = new LinkedList<Node>();
            this.comp.nodesForNext.add(this.comp.getExplorerManager().getRootContext());
        }
        List<Node> nodesForNext = this.comp.nodesForNext;
        while (!nodesForNext.isEmpty()) {
            Node top = nodesForNext.remove(0);
            if (top.getChildren() != FilterNode.Children.LEAF) {
                nodesForNext.addAll(0, Arrays.asList(top.getChildren().getNodes(true)));
                continue;
            }
            ErrorDescription ed = (ErrorDescription)top.getLookup().lookup(ErrorDescription.class);
            if (ed == null) continue;
            Node[] selected = this.comp.getExplorerManager().getSelectedNodes();
            if (selected.length == 1 && selected[0] == top) {
                this.addToSeenNodes(top);
                continue;
            }
            return top;
        }
        return null;
    }

    private void addToSeenNodes(Node n) {
        if (this.comp.seenNodes == null) {
            this.comp.seenNodes = new LinkedList<Node>();
        }
        this.comp.seenNodes.add(0, n);
    }

    void fireEnabledChanged() {
        this.firePropertyChange("enabled", null, this.isEnabled());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireEnabledChanged();
    }
}

