/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.analysis;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.analysis.Bundle;
import org.netbeans.modules.analysis.Configuration;
import org.netbeans.modules.analysis.ConfigurationsManager;
import org.netbeans.modules.analysis.RequiredPluginsPanel;
import org.netbeans.modules.analysis.RunAnalysis;
import org.netbeans.modules.analysis.SPIAccessor;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.analysis.ui.AdjustConfigurationPanel;
import org.netbeans.modules.analysis.ui.ConfigurationsComboModel;
import org.netbeans.modules.refactoring.api.Scope;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class RunAnalysisPanel
extends JPanel
implements LookupListener {
    private static final String COMBO_PROTOTYPE = "999999999999999999999999999999999999999999999999999999999999";
    private final JPanel progress;
    private final RequiredPluginsPanel requiredPlugins;
    private Collection<? extends Analyzer.AnalyzerFactory> analyzers;
    private final Lookup.Result<Analyzer.AnalyzerFactory> analyzersResult;
    private final Map<String, AnalyzerAndWarning> warningId2Description = new HashMap<String, AnalyzerAndWarning>();
    private final JButton runAnalysis;
    private JButton browse;
    private JComboBox configurationCombo;
    private JRadioButton configurationRadio;
    private JComboBox inspectionCombo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JButton manage;
    private ButtonGroup radioButtons;
    private JComboBox scopeCombo;
    private JRadioButton singleInspectionRadio;

    public RunAnalysisPanel(ProgressHandle handle, Lookup context, JButton runAnalysis) {
        this(handle, context, runAnalysis, null);
    }

    public RunAnalysisPanel(ProgressHandle handle, Lookup context, JButton runAnalysis, DialogState state) {
        ClassPath source;
        ProjectInformation pi;
        this.runAnalysis = runAnalysis;
        this.analyzersResult = Lookup.getDefault().lookupResult(Analyzer.AnalyzerFactory.class);
        this.analyzersResult.addLookupListener((LookupListener)this);
        this.initComponents();
        ArrayList<ScopeDescription> scopes = new ArrayList<ScopeDescription>();
        Icon currentProjectIcon = null;
        NonRecursiveFolder pack = (NonRecursiveFolder)context.lookup(NonRecursiveFolder.class);
        FileObject currentFile = (FileObject)context.lookup(FileObject.class);
        if (currentFile != null && currentFile.isData()) {
            scopes.add(new FileScopeDescription(currentFile));
        }
        if (pack != null && currentFile == null) {
            currentFile = pack.getFolder();
        }
        if (currentFile != null) {
            Project p = FileOwnerQuery.getOwner((FileObject)currentFile);
            if (p != null) {
                ClassPath bootCP;
                pi = ProjectUtils.getInformation((Project)p);
                scopes.add(0, new CurrentProjectScopeDescription(p));
                currentProjectIcon = pi.getIcon();
                if (pack == null && (bootCP = ClassPath.getClassPath((FileObject)currentFile, (String)"classpath/boot")) != null) {
                    final FileObject packFO = currentFile.getParent();
                    pack = new NonRecursiveFolder(){

                        public FileObject getFolder() {
                            return packFO;
                        }
                    };
                }
            }
        } else {
            DataFolder df;
            SourceGroup sg;
            Project selected = (Project)context.lookup(Project.class);
            if (selected == null && (sg = (SourceGroup)context.lookup(SourceGroup.class)) != null) {
                selected = FileOwnerQuery.getOwner((FileObject)sg.getRootFolder());
            }
            if (selected == null && (df = (DataFolder)context.lookup(DataFolder.class)) != null) {
                selected = FileOwnerQuery.getOwner((FileObject)df.getPrimaryFile());
            }
            if (selected != null) {
                pi = ProjectUtils.getInformation((Project)selected);
                scopes.add(0, new CurrentProjectScopeDescription(selected));
                currentProjectIcon = pi.getIcon();
            }
        }
        if (pack != null && (source = ClassPath.getClassPath((FileObject)pack.getFolder(), (String)"classpath/source")) != null) {
            String packName = source.getResourceName(pack.getFolder());
            scopes.add(1, new PackageScopeDescription(pack, packName));
        }
        scopes.add(0, new AllProjectsScopeDescription(currentProjectIcon));
        this.scopeCombo.setModel(new DefaultComboBoxModel<ScopeDescription>(scopes.toArray(new ScopeDescription[0])));
        this.scopeCombo.setRenderer(new ScopeRenderer());
        this.scopeCombo.setSelectedIndex(scopes.size() - 1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.progress = new JPanel(new CardLayout());
        this.progress.add((Component)new JPanel(), "empty");
        this.progress.add((Component)ProgressHandleFactory.createProgressComponent((ProgressHandle)handle), "progress");
        this.requiredPlugins = new RequiredPluginsPanel();
        this.progress.add((Component)this.requiredPlugins, "plugins");
        this.add((Component)this.progress, gridBagConstraints);
        ((CardLayout)this.progress.getLayout()).show(this.progress, "empty");
        if (state == null) {
            state = DialogState.load();
        }
        this.updateConfigurations(state);
        this.updateEnableDisable();
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        ConfigurationsManager.getDefault().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RunAnalysisPanel.this.resultChanged(null);
            }
        });
        this.configurationCombo.addActionListener(new ActionListener(){
            Object currentItem;
            {
                this.currentItem = RunAnalysisPanel.this.configurationCombo.getSelectedItem();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object tempItem = RunAnalysisPanel.this.configurationCombo.getSelectedItem();
                if (tempItem instanceof String) {
                    RunAnalysisPanel.this.configurationCombo.setSelectedItem(this.currentItem);
                } else {
                    this.currentItem = tempItem;
                }
            }
        });
        this.inspectionCombo.addActionListener(new ActionListener(){
            Object currentItem;
            {
                this.currentItem = RunAnalysisPanel.this.inspectionCombo.getSelectedItem();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object tempItem = RunAnalysisPanel.this.inspectionCombo.getSelectedItem();
                if (!(tempItem instanceof AnalyzerAndWarning)) {
                    RunAnalysisPanel.this.inspectionCombo.setSelectedItem(this.currentItem);
                } else {
                    this.currentItem = tempItem;
                }
            }
        });
    }

    void started() {
        ((CardLayout)this.progress.getLayout()).show(this.progress, "progress");
        this.progress.invalidate();
        LinkedList<JComponent> todo = new LinkedList<JComponent>();
        todo.add(this);
        while (!todo.isEmpty()) {
            JComponent c = (JComponent)todo.remove(0);
            if (c == this.progress) continue;
            c.setEnabled(false);
            for (Component child : c.getComponents()) {
                if (!(child instanceof JComponent)) continue;
                todo.add((JComponent)child);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateConfigurations(DialogState state) {
        void var5_9;
        this.analyzers = this.analyzersResult.allInstances();
        Object selectedConfiguration = null;
        DefaultComboBoxModel<Object> configurationModel = new DefaultComboBoxModel<Object>();
        configurationModel.addElement(Bundle.LBL_Predefined());
        configurationModel.addElement(null);
        for (Analyzer.AnalyzerFactory analyzerFactory : this.analyzers) {
            if (SPIAccessor.ACCESSOR.getAnalyzerId(analyzerFactory).equals(state.selectedAnalyzer)) {
                selectedConfiguration = analyzerFactory;
            }
            configurationModel.addElement(analyzerFactory);
        }
        configurationModel.addElement(Bundle.LBL_Custom());
        for (Configuration configuration : ConfigurationsManager.getDefault().getConfigurations()) {
            if (configuration.id().equals(state.selectedConfiguration)) {
                selectedConfiguration = configuration;
            }
            configurationModel.addElement(configuration);
        }
        this.configurationCombo.setModel(configurationModel);
        this.configurationCombo.setSelectedItem(selectedConfiguration);
        this.configurationRadio.setSelected(state.configurationsSelected);
        this.configurationCombo.setRenderer(new ConfigurationRenderer(true));
        DefaultComboBoxModel<Object> inspectionModel = new DefaultComboBoxModel<Object>();
        Object var5_8 = null;
        AnalyzerAndWarning preselectInspection = null;
        for (Analyzer.AnalyzerFactory analyzerFactory : this.analyzers) {
            inspectionModel.addElement(SPIAccessor.ACCESSOR.getAnalyzerDisplayName(analyzerFactory));
            TreeMap<String, TreeSet<Analyzer.WarningDescription>> cat2Warnings = new TreeMap<String, TreeSet<Analyzer.WarningDescription>>();
            for (Analyzer.WarningDescription warningDescription : analyzerFactory.getWarnings()) {
                String cat = SPIAccessor.ACCESSOR.getWarningCategoryDisplayName(warningDescription);
                TreeSet<Analyzer.WarningDescription> warnings = (TreeSet<Analyzer.WarningDescription>)cat2Warnings.get(cat);
                if (warnings == null) {
                    warnings = new TreeSet<Analyzer.WarningDescription>(new Comparator<Analyzer.WarningDescription>(){

                        @Override
                        public int compare(Analyzer.WarningDescription o1, Analyzer.WarningDescription o2) {
                            return SPIAccessor.ACCESSOR.getWarningDisplayName(o1).compareToIgnoreCase(SPIAccessor.ACCESSOR.getWarningDisplayName(o2));
                        }
                    });
                    cat2Warnings.put(cat, warnings);
                }
                warnings.add(warningDescription);
            }
            for (Map.Entry entry : cat2Warnings.entrySet()) {
                inspectionModel.addElement("  " + (String)entry.getKey());
                for (Analyzer.WarningDescription wd : (Collection)entry.getValue()) {
                    AnalyzerAndWarning aaw = new AnalyzerAndWarning(analyzerFactory, wd);
                    inspectionModel.addElement(aaw);
                    this.warningId2Description.put(SPIAccessor.ACCESSOR.getWarningId(wd), aaw);
                    if (var5_9 == null) {
                        AnalyzerAndWarning analyzerAndWarning = aaw;
                    }
                    if (!SPIAccessor.ACCESSOR.getWarningId(wd).equals(state.selectedInspection)) continue;
                    preselectInspection = aaw;
                }
            }
        }
        this.inspectionCombo.setModel(inspectionModel);
        this.inspectionCombo.setRenderer(new InspectionRenderer());
        this.inspectionCombo.setSelectedItem(preselectInspection != null ? preselectInspection : var5_9);
        this.singleInspectionRadio.setSelected(!state.configurationsSelected);
        this.updatePlugins();
    }

    private void updatePlugins() {
        Collection<? extends Analyzer.AnalyzerFactory> toRun = !(this.configurationCombo.getSelectedItem() instanceof Analyzer.AnalyzerFactory) ? this.analyzers : Collections.singleton((Analyzer.AnalyzerFactory)this.configurationCombo.getSelectedItem());
        Analyzer.Context ctx = SPIAccessor.ACCESSOR.createContext(null, null, null, null, -1, -1);
        HashSet<Analyzer.MissingPlugin> plugins = new HashSet<Analyzer.MissingPlugin>();
        boolean someOk = false;
        for (Analyzer.AnalyzerFactory analyzerFactory : toRun) {
            Collection<? extends Analyzer.MissingPlugin> req = analyzerFactory.requiredPlugins(ctx);
            plugins.addAll(req);
            someOk |= req.isEmpty();
        }
        if (plugins.isEmpty()) {
            ((CardLayout)this.progress.getLayout()).show(this.progress, "empty");
        } else {
            this.requiredPlugins.setRequiredPlugins(plugins, !someOk);
            ((CardLayout)this.progress.getLayout()).show(this.progress, "plugins");
        }
        this.runAnalysis.setEnabled(someOk);
    }

    public Scope getSelectedScope(AtomicBoolean cancel) {
        return ((ScopeDescription)this.scopeCombo.getSelectedItem()).getScope(cancel);
    }

    public Analyzer.AnalyzerFactory getSelectedAnalyzer() {
        if (!(this.configurationCombo.getSelectedItem() instanceof Analyzer.AnalyzerFactory)) {
            return null;
        }
        return (Analyzer.AnalyzerFactory)this.configurationCombo.getSelectedItem();
    }

    public Configuration getConfiguration() {
        if (this.inspectionCombo.isEnabled()) {
            return ConfigurationsManager.getDefault().getTemporaryConfiguration();
        }
        Object selected = this.configurationCombo.getSelectedItem();
        if (selected instanceof Configuration) {
            return (Configuration)selected;
        }
        return null;
    }

    public Collection<? extends Analyzer.AnalyzerFactory> getAnalyzers() {
        return this.analyzers;
    }

    private void initComponents() {
        this.radioButtons = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.scopeCombo = new JComboBox();
        this.jLabel2 = new JLabel();
        this.configurationCombo = new JComboBox();
        this.manage = new JButton();
        this.configurationRadio = new JRadioButton();
        this.singleInspectionRadio = new JRadioButton();
        this.inspectionCombo = new JComboBox();
        this.browse = new JButton();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RunAnalysisPanel.class, (String)"RunAnalysisPanel.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 1280;
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.scopeCombo, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(RunAnalysisPanel.class, (String)"RunAnalysisPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.configurationCombo.setPrototypeDisplayValue(COMBO_PROTOTYPE);
        this.configurationCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAnalysisPanel.this.configurationComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.configurationCombo, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.manage, (String)NbBundle.getMessage(RunAnalysisPanel.class, (String)"RunAnalysisPanel.manage.text"));
        this.manage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAnalysisPanel.this.manageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.manage, gridBagConstraints);
        this.radioButtons.add(this.configurationRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.configurationRadio, (String)NbBundle.getMessage(RunAnalysisPanel.class, (String)"RunAnalysisPanel.configurationRadio.text"));
        this.configurationRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAnalysisPanel.this.configurationRadioActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.configurationRadio, gridBagConstraints);
        this.radioButtons.add(this.singleInspectionRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.singleInspectionRadio, (String)NbBundle.getMessage(RunAnalysisPanel.class, (String)"RunAnalysisPanel.singleInspectionRadio.text"));
        this.singleInspectionRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAnalysisPanel.this.singleInspectionRadioActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.singleInspectionRadio, gridBagConstraints);
        this.inspectionCombo.setPrototypeDisplayValue(COMBO_PROTOTYPE);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.inspectionCombo, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browse, (String)NbBundle.getMessage(RunAnalysisPanel.class, (String)"RunAnalysisPanel.browse.text"));
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAnalysisPanel.this.browseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.browse, gridBagConstraints);
    }

    private void configurationComboActionPerformed(ActionEvent evt) {
        this.updatePlugins();
    }

    private void manageActionPerformed(ActionEvent evt) {
        AdjustConfigurationPanel panel = new AdjustConfigurationPanel(this.analyzers, null, null);
        DialogDescriptor nd = new DialogDescriptor((Object)panel, Bundle.LBL_Configurations(), true, 2, NotifyDescriptor.OK_OPTION, null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.OK_OPTION) {
            panel.save();
        }
    }

    private void configurationRadioActionPerformed(ActionEvent evt) {
        this.updateEnableDisable();
    }

    private void singleInspectionRadioActionPerformed(ActionEvent evt) {
        this.updateEnableDisable();
    }

    private void browseActionPerformed(ActionEvent evt) {
        String warningToSelect;
        Analyzer.AnalyzerFactory analyzerToSelect;
        Object selectedInspection = this.inspectionCombo.getSelectedItem();
        if (selectedInspection instanceof AnalyzerAndWarning) {
            analyzerToSelect = ((AnalyzerAndWarning)selectedInspection).analyzer;
            warningToSelect = SPIAccessor.ACCESSOR.getWarningId(((AnalyzerAndWarning)selectedInspection).wd);
        } else {
            analyzerToSelect = null;
            warningToSelect = "";
        }
        AdjustConfigurationPanel panel = new AdjustConfigurationPanel(this.analyzers, analyzerToSelect, warningToSelect);
        DialogDescriptor nd = new DialogDescriptor((Object)panel, Bundle.LBL_Browse(), true, 2, NotifyDescriptor.OK_OPTION, null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.OK_OPTION) {
            this.inspectionCombo.setSelectedItem(this.warningId2Description.get(panel.getIdToRun()));
        }
    }

    private void updateEnableDisable() {
        boolean configuration = this.configurationRadio.isSelected();
        this.configurationCombo.setEnabled(configuration);
        this.manage.setEnabled(configuration);
        this.inspectionCombo.setEnabled(!configuration);
        this.browse.setEnabled(!configuration);
    }

    String getSingleWarningId() {
        return this.inspectionCombo.isEnabled() ? SPIAccessor.ACCESSOR.getWarningId(((AnalyzerAndWarning)this.inspectionCombo.getSelectedItem()).wd) : null;
    }

    public void resultChanged(LookupEvent ev) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RunAnalysisPanel.this.updateConfigurations(RunAnalysisPanel.this.getDialogState());
            }
        });
    }

    public DialogState getDialogState() {
        Object selectedConfiguration = this.configurationCombo.getSelectedItem();
        Object selectedInspection = this.inspectionCombo.getSelectedItem();
        return new DialogState(this.configurationRadio.isSelected(), selectedConfiguration instanceof Analyzer.AnalyzerFactory ? SPIAccessor.ACCESSOR.getAnalyzerId((Analyzer.AnalyzerFactory)selectedConfiguration) : null, selectedConfiguration instanceof Configuration ? ((Configuration)selectedConfiguration).id() : null, selectedInspection instanceof AnalyzerAndWarning ? SPIAccessor.ACCESSOR.getWarningId(((AnalyzerAndWarning)selectedInspection).wd) : null);
    }

    private static final class AllProjectsScopeDescription
    implements ScopeDescription {
        private final Icon icon;

        public AllProjectsScopeDescription(Icon icon) {
            this.icon = icon;
        }

        @Override
        public String getDisplayName() {
            return Bundle.DN_OpenProjects();
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        @Override
        public Scope getScope(AtomicBoolean cancel) {
            Map<Project, Map<FileObject, ClassPath>> projects2RegisteredContent = RunAnalysis.projects2RegisteredContent(cancel);
            if (cancel.get()) {
                return null;
            }
            Scope target = Scope.create(null, null, null);
            for (Project p : OpenProjects.getDefault().getOpenProjects()) {
                if (cancel.get()) {
                    return null;
                }
                target = RunAnalysis.addProjectToScope(p, target, cancel, projects2RegisteredContent);
            }
            return target;
        }
    }

    private static final class AnalyzerAndWarning {
        private final Analyzer.AnalyzerFactory analyzer;
        private final Analyzer.WarningDescription wd;

        public AnalyzerAndWarning(Analyzer.AnalyzerFactory analyzer, Analyzer.WarningDescription wd) {
            this.analyzer = analyzer;
            this.wd = wd;
        }
    }

    public static final class ConfigurationRenderer
    extends DefaultListCellRenderer {
        private final boolean indent;

        public ConfigurationRenderer(boolean indent) {
            this.indent = indent;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                value = Bundle.LBL_RunAllAnalyzers();
            } else if (value instanceof Analyzer.AnalyzerFactory) {
                value = Bundle.LBL_RunAnalyzer(SPIAccessor.ACCESSOR.getAnalyzerDisplayName((Analyzer.AnalyzerFactory)value));
            } else if (value instanceof Configuration) {
                value = ((Configuration)value).getDisplayName();
            } else if (value instanceof String) {
                this.setFont(this.getFont().deriveFont(2));
                this.setText((String)value);
                this.setEnabled(false);
                this.setBackground(list.getBackground());
                this.setForeground(UIManager.getColor("Label.disabledForeground"));
                return this;
            }
            if (index == list.getModel().getSize() - 5 && list.getModel() instanceof ConfigurationsComboModel && ((ConfigurationsComboModel)list.getModel()).canModify()) {
                this.setBorder(new Separator(list.getForeground()));
            } else {
                this.setBorder(null);
            }
            return super.getListCellRendererComponent((JList<?>)list, (this.indent ? "  " : "") + value, index, isSelected, cellHasFocus);
        }
    }

    private static final class CurrentProjectScopeDescription
    implements ScopeDescription {
        private final Project project;

        public CurrentProjectScopeDescription(Project project) {
            this.project = project;
        }

        @Override
        public String getDisplayName() {
            return Bundle.DN_CurrentProject(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        }

        @Override
        public Icon getIcon() {
            return ProjectUtils.getInformation((Project)this.project).getIcon();
        }

        @Override
        public Scope getScope(AtomicBoolean cancel) {
            Map<Project, Map<FileObject, ClassPath>> projects2RegisteredContent = RunAnalysis.projects2RegisteredContent(cancel);
            if (cancel.get()) {
                return null;
            }
            return RunAnalysis.addProjectToScope(this.project, Scope.create(null, null, null), cancel, projects2RegisteredContent);
        }
    }

    public static final class DialogState {
        private final boolean configurationsSelected;
        private final String selectedAnalyzer;
        private final String selectedConfiguration;
        private final String selectedInspection;

        private DialogState(boolean configurationsSelected, String selectedAnalyzer, String selectedConfiguration, String selectedInspection) {
            this.configurationsSelected = configurationsSelected;
            this.selectedAnalyzer = selectedAnalyzer;
            this.selectedConfiguration = selectedConfiguration;
            this.selectedInspection = selectedInspection;
        }

        public void save() {
            Preferences prefs = NbPreferences.forModule(RunAnalysisPanel.class).node("RunAnalysisPanel");
            prefs.putBoolean("configurationsSelected", this.configurationsSelected);
            if (this.selectedAnalyzer != null) {
                prefs.put("selectedAnalyzer", this.selectedAnalyzer);
            } else {
                prefs.remove("selectedAnalyzer");
            }
            if (this.selectedConfiguration != null) {
                prefs.put("selectedConfiguration", this.selectedConfiguration);
            } else {
                prefs.remove("selectedConfiguration");
            }
            if (this.selectedInspection != null) {
                prefs.put("selectedInspection", this.selectedInspection);
            } else {
                prefs.remove("selectedInspection");
            }
        }

        private static DialogState load() {
            Preferences prefs = NbPreferences.forModule(RunAnalysisPanel.class).node("RunAnalysisPanel");
            return new DialogState(prefs.getBoolean("configurationsSelected", true), prefs.get("selectedAnalyzer", null), prefs.get("selectedConfiguration", null), prefs.get("selectedInspection", null));
        }
    }

    private static final class FileScopeDescription
    implements ScopeDescription {
        private static final Logger LOG = Logger.getLogger(FileScopeDescription.class.getName());
        private final FileObject file;

        public FileScopeDescription(FileObject file) {
            this.file = file;
        }

        @Override
        public String getDisplayName() {
            return Bundle.DN_CurrentFile(this.file.getNameExt());
        }

        @Override
        public Icon getIcon() {
            try {
                DataObject d = DataObject.find((FileObject)this.file);
                Node n = d.getNodeDelegate();
                return ImageUtilities.image2Icon((Image)n.getIcon(1));
            }
            catch (DataObjectNotFoundException ex) {
                LOG.log(Level.FINE, null, ex);
                return null;
            }
        }

        @Override
        public Scope getScope(AtomicBoolean cancel) {
            return Scope.create(null, null, Collections.singletonList(this.file));
        }
    }

    private static final class InspectionRenderer
    extends DefaultListCellRenderer {
        private InspectionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof AnalyzerAndWarning) {
                value = "    " + SPIAccessor.ACCESSOR.getWarningDisplayName(((AnalyzerAndWarning)value).wd);
            } else if (value instanceof String) {
                this.setFont(this.getFont().deriveFont(2));
                this.setText((String)value);
                this.setEnabled(false);
                this.setBackground(list.getBackground());
                this.setForeground(UIManager.getColor("Label.disabledForeground"));
                return this;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private static final class PackageScopeDescription
    implements ScopeDescription {
        private final NonRecursiveFolder pack;
        private final String packName;

        public PackageScopeDescription(NonRecursiveFolder pack, String packName) {
            this.pack = pack;
            this.packName = packName;
        }

        @Override
        public String getDisplayName() {
            return Bundle.DN_CurrentPackage(this.packName);
        }

        @Override
        public Icon getIcon() {
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/analysis/ui/resources/package.gif", (boolean)false);
        }

        @Override
        public Scope getScope(AtomicBoolean cancel) {
            return Scope.create(null, Collections.singletonList(this.pack), null);
        }
    }

    private static interface ScopeDescription {
        public String getDisplayName();

        public Icon getIcon();

        public Scope getScope(AtomicBoolean var1);
    }

    private static final class ScopeRenderer
    extends DefaultListCellRenderer {
        private ScopeRenderer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof ScopeDescription) {
                ScopeDescription sd = (ScopeDescription)value;
                try {
                    Component component = super.getListCellRendererComponent((JList<?>)list, sd.getDisplayName(), index, isSelected, cellHasFocus);
                    return component;
                }
                finally {
                    this.setIcon(sd.getIcon());
                }
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private static class Separator
    implements Border {
        private Color fgColor;

        Separator(Color color) {
            this.fgColor = color;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics gr = g.create();
            if (gr != null) {
                try {
                    gr.translate(x, y);
                    gr.setColor(this.fgColor);
                    gr.drawLine(0, height - 1, width - 1, height - 1);
                }
                finally {
                    gr.dispose();
                }
            }
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 1, 0);
        }
    }
}

