/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.swing.components;

import com.jgoodies.animation.renderer.BasicTextRenderer;
import com.jgoodies.animation.renderer.HeightMode;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public final class BasicTextLabel
extends JComponent {
    public static final String PROPERTY_COLOR = "color";
    public static final String PROPERTY_HEIGHT_MODE = "heightMode";
    public static final String PROPERTY_SCALE = "scale";
    public static final String PROPERTY_SCALE_X = "scaleX";
    public static final String PROPERTY_SCALE_Y = "scaleY";
    public static final String PROPERTY_SPACE = "space";
    public static final String PROPERTY_TEXT = "text";
    public static final String PROPERTY_OFFSET_X = "offsetX";
    public static final String PROPERTY_OFFSET_Y = "offsetY";
    private final BasicTextRenderer renderer;

    public BasicTextLabel() {
        this("");
    }

    public BasicTextLabel(String text) {
        this.renderer = new BasicTextRenderer(text);
    }

    public Color getColor() {
        return this.renderer.getColor();
    }

    public HeightMode getHeightMode() {
        return this.renderer.getHeightMode();
    }

    public float getScale() {
        return Math.max(this.getScaleX(), this.getScaleX());
    }

    public float getScaleX() {
        return this.renderer.getScaleX();
    }

    public float getScaleY() {
        return this.renderer.getScaleY();
    }

    public float getSpace() {
        return this.renderer.getSpace();
    }

    public float getOffsetX() {
        return this.renderer.getOffsetX();
    }

    public float getOffsetY() {
        return this.renderer.getOffsetY();
    }

    public String getText() {
        return this.renderer.getText();
    }

    public void setColor(Color newColor) {
        Color oldColor = this.getColor();
        if (oldColor.equals(newColor)) {
            return;
        }
        this.renderer.setColor(newColor);
        this.firePropertyChange(PROPERTY_COLOR, oldColor, newColor);
        this.repaint();
    }

    public void setHeightMode(HeightMode heightMode) {
        HeightMode oldMode = this.getHeightMode();
        this.renderer.setHeightMode(heightMode);
        this.firePropertyChange(PROPERTY_HEIGHT_MODE, oldMode, heightMode);
        this.repaint();
    }

    public void setScale(float newScale) {
        float oldScale = this.getScale();
        this.renderer.setScaleX(newScale);
        this.renderer.setScaleY(newScale);
        this.firePropertyChange(PROPERTY_SCALE, oldScale, newScale);
        this.repaint();
    }

    public void setScaleX(float newScaleX) {
        float oldScaleX = this.getScaleX();
        if (oldScaleX == newScaleX) {
            return;
        }
        float oldScale = this.getScale();
        this.renderer.setScaleX(newScaleX);
        this.firePropertyChange(PROPERTY_SCALE_X, oldScaleX, newScaleX);
        this.firePropertyChange(PROPERTY_SCALE, oldScale, this.getScale());
        this.repaint();
    }

    public void setScaleY(float newScaleY) {
        float oldScaleY = this.getScaleY();
        if (oldScaleY == newScaleY) {
            return;
        }
        float oldScale = this.getScale();
        this.renderer.setScaleY(newScaleY);
        this.firePropertyChange(PROPERTY_SCALE_Y, oldScaleY, newScaleY);
        this.firePropertyChange(PROPERTY_SCALE, oldScale, this.getScale());
        this.repaint();
    }

    public void setSpace(float newSpace) {
        float oldSpace = this.getSpace();
        if (oldSpace == newSpace) {
            return;
        }
        this.renderer.setSpace(newSpace);
        this.firePropertyChange(PROPERTY_SPACE, oldSpace, newSpace);
        this.repaint();
    }

    public void setOffsetX(float offsetX) {
        float oldOffsetX = this.getOffsetX();
        this.renderer.setOffsetX(offsetX);
        this.firePropertyChange(PROPERTY_OFFSET_X, oldOffsetX, offsetX);
        this.repaint();
    }

    public void setOffsetY(float offsetY) {
        float oldOffsetY = this.getOffsetY();
        this.renderer.setOffsetY(offsetY);
        this.firePropertyChange(PROPERTY_OFFSET_Y, oldOffsetY, offsetY);
        this.repaint();
    }

    public void setText(String newText) {
        String oldText = this.getText();
        if (oldText.equals(newText)) {
            return;
        }
        this.renderer.setText(newText);
        this.firePropertyChange(PROPERTY_TEXT, oldText, newText);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.renderer.setFont(this.getFont());
        this.renderer.render(g2, this.getWidth(), this.getHeight());
    }
}

