/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.swing.animations;

import com.jgoodies.animation.Animation;
import com.jgoodies.animation.Animations;
import com.jgoodies.animation.swing.animations.BasicTextAnimation;
import com.jgoodies.animation.swing.components.BasicTextLabel;
import java.awt.Color;
import java.util.LinkedList;

public final class BasicTextAnimations {
    private static final int FADE_TYPE = 0;
    private static final int SCALE_TYPE = 1;
    private static final int SPACE_TYPE = 2;

    private BasicTextAnimations() {
    }

    public static Animation defaultFade(BasicTextLabel label1, BasicTextLabel label2, long singleDuration, long beginOffset, String separatedTexts, Color baseColor) {
        return BasicTextAnimations.createTextSequence(label1, label2, singleDuration, beginOffset, separatedTexts, baseColor, 0);
    }

    public static Animation defaultScale(BasicTextLabel label1, BasicTextLabel label2, long singleDuration, long beginOffset, String separatedTexts, Color baseColor) {
        return BasicTextAnimations.createTextSequence(label1, label2, singleDuration, beginOffset, separatedTexts, baseColor, 1);
    }

    public static Animation defaultSpace(BasicTextLabel label1, BasicTextLabel label2, long singleDuration, long beginOffset, String separatedTexts, Color baseColor) {
        return BasicTextAnimations.createTextSequence(label1, label2, singleDuration, beginOffset, separatedTexts, baseColor, 2);
    }

    private static Animation createTextSequence(BasicTextLabel label1, BasicTextLabel label2, long singleDuration, long beginOffset, String separatedTexts, Color baseColor, int type) {
        String[] texts = separatedTexts.split("\\|");
        LinkedList<Animation> animations = new LinkedList<Animation>();
        long beginTime = 0L;
        BasicTextLabel label = label1;
        for (int i = 0; i < texts.length; ++i) {
            label = i % 2 == 0 ? label1 : label2;
            Animation animation = BasicTextAnimations.animation(label, singleDuration, texts[i], baseColor, type);
            animations.add(Animations.offset(animation, beginTime));
            beginTime += singleDuration + beginOffset;
        }
        return Animations.parallel(animations);
    }

    private static Animation animation(BasicTextLabel label, long duration, String text, Color baseColor, int type) {
        switch (type) {
            case 0: {
                return BasicTextAnimation.defaultFade(label, duration, text, baseColor);
            }
            case 1: {
                return BasicTextAnimation.defaultScale(label, duration, text, baseColor);
            }
            case 2: {
                return BasicTextAnimation.defaultSpace(label, duration, text, baseColor);
            }
        }
        return null;
    }
}

