/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.swing.animations;

import com.jgoodies.animation.AbstractAnimation;
import com.jgoodies.animation.AnimationFunction;
import com.jgoodies.animation.AnimationFunctions;
import com.jgoodies.animation.swing.components.BasicTextLabel;
import java.awt.Color;

public final class BasicTextAnimation
extends AbstractAnimation {
    private final BasicTextLabel label;
    private final String text;
    private final AnimationFunction<Color> colorFunction;
    private final AnimationFunction<Integer> offsetFunction;
    private final AnimationFunction<Float> scaleXFunction;
    private final AnimationFunction<Float> scaleYFunction;
    private final AnimationFunction<Float> spaceFunction;
    private boolean offsetEnabled = false;

    public BasicTextAnimation(BasicTextLabel label, long duration, String text, AnimationFunction<Color> colorFunction, AnimationFunction<Float> scaleXFunction, AnimationFunction<Float> scaleYFunction, AnimationFunction<Float> spaceFunction) {
        super(duration);
        this.label = label;
        this.text = text;
        this.colorFunction = colorFunction != null ? colorFunction : BasicTextAnimation.defaultFadeColorFunction(duration, Color.DARK_GRAY);
        this.scaleXFunction = scaleXFunction != null ? scaleXFunction : AnimationFunctions.ONE;
        this.scaleYFunction = scaleYFunction != null ? scaleYFunction : AnimationFunctions.ONE;
        this.spaceFunction = spaceFunction != null ? spaceFunction : AnimationFunctions.ZERO;
        this.offsetFunction = BasicTextAnimation.defaultOffsetFunction();
    }

    public static BasicTextAnimation defaultFade(BasicTextLabel label, long duration, String text, Color baseColor) {
        return new BasicTextAnimation(label, duration, text, BasicTextAnimation.cinemaFadeColorFunction(duration, baseColor), null, null, null);
    }

    public static BasicTextAnimation defaultScale(BasicTextLabel label, long duration, String text, Color baseColor) {
        return new BasicTextAnimation(label, duration, text, BasicTextAnimation.defaultScaleColorFunction(duration, baseColor), BasicTextAnimation.defaultScaleFunction(duration), BasicTextAnimation.defaultScaleFunction(duration), null);
    }

    public static BasicTextAnimation defaultSpace(BasicTextLabel label, long duration, String text, Color baseColor) {
        return new BasicTextAnimation(label, duration, text, BasicTextAnimation.defaultSpaceColorFunction(duration, baseColor), null, null, BasicTextAnimation.defaultSpaceFunction(duration));
    }

    public static AnimationFunction<Color> defaultFadeColorFunction(long duration, Color baseColor) {
        return AnimationFunctions.alphaColor(AnimationFunctions.linear((long)duration, (Number[])new Integer[]{new Integer(0), new Integer(255), new Integer(255), new Integer(0)}, (float[])new float[]{0.0f, 0.3f, 0.7f, 1.0f}), baseColor);
    }

    public static AnimationFunction<Color> cinemaFadeColorFunction(long duration, Color baseColor) {
        return AnimationFunctions.alphaColor(AnimationFunctions.linear((long)duration, (Number[])new Integer[]{new Integer(0), new Integer(255), new Integer(255), new Integer(0)}, (float[])new float[]{0.0f, 0.3f, 0.85f, 1.0f}), baseColor);
    }

    public static AnimationFunction<Color> defaultScaleColorFunction(long duration, Color baseColor) {
        return AnimationFunctions.alphaColor(AnimationFunctions.linear((long)duration, (Number[])new Integer[]{new Integer(0), new Integer(255), new Integer(255), new Integer(0)}, (float[])new float[]{0.0f, 0.2f, 0.85f, 1.0f}), baseColor);
    }

    public static AnimationFunction<Color> defaultSpaceColorFunction(long duration, Color baseColor) {
        return AnimationFunctions.alphaColor(AnimationFunctions.linear((long)duration, (Number[])new Integer[]{new Integer(0), new Integer(255), new Integer(255), new Integer(0)}, (float[])new float[]{0.0f, 0.2f, 0.8f, 1.0f}), baseColor);
    }

    public static AnimationFunction<Integer> defaultOffsetFunction() {
        return AnimationFunctions.random(-2, 2, 0.5f);
    }

    public static AnimationFunction<Float> defaultScaleFunction(long duration) {
        return AnimationFunctions.linear((long)duration, (Number[])new Float[]{new Float(1.0f), new Float(1.0f), new Float(1.8f)}, (float[])new float[]{0.0f, 0.85f, 1.0f});
    }

    public static AnimationFunction<Float> defaultSpaceFunction(long duration) {
        return AnimationFunctions.fromTo(duration, 0.0f, 10.0f);
    }

    @Override
    protected void applyEffect(long time) {
        this.label.setText(time == 0L ? " " : this.text);
        this.label.setColor(this.colorFunction.valueAt(time));
        this.label.setScaleX(this.scaleXFunction.valueAt(time).floatValue());
        this.label.setScaleY(this.scaleYFunction.valueAt(time).floatValue());
        this.label.setSpace(this.spaceFunction.valueAt(time).floatValue());
        if (this.isOffsetEnabled()) {
            this.label.setOffsetX(this.offsetFunction.valueAt(time).intValue());
            this.label.setOffsetY(this.offsetFunction.valueAt(time).intValue());
        }
    }

    public boolean isOffsetEnabled() {
        return this.offsetEnabled;
    }

    public void setOffsetEnabled(boolean b) {
        this.offsetEnabled = b;
    }
}

