/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.renderer;

import com.jgoodies.animation.AnimationFunction;
import com.jgoodies.animation.renderer.AbstractTextRenderer;
import java.awt.Color;
import java.awt.Graphics2D;

public final class GlyphRenderer
extends AbstractTextRenderer {
    private final AnimationFunction<Color> colorFunction;
    private final AnimationFunction<Float> scaleFunction;
    private final long glyphDelay;
    private long time;

    public GlyphRenderer(String text, AnimationFunction<Float> scaleFunction, AnimationFunction<Float> translateFunction, AnimationFunction<Color> colorFunction, long glyphDelay) {
        super(text);
        this.scaleFunction = scaleFunction;
        this.colorFunction = colorFunction;
        this.glyphDelay = glyphDelay;
        this.time = 0L;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    private long relativeTime(int glyphIndex) {
        return Math.max(0L, this.time - this.glyphDelay * (long)glyphIndex);
    }

    private float scaleAt(int glyphIndex) {
        return this.scaleFunction.valueAt(this.relativeTime(glyphIndex)).floatValue();
    }

    private Color colorAt(int glyphIndex) {
        return this.colorFunction.valueAt(this.relativeTime(glyphIndex));
    }

    @Override
    public void render(Graphics2D g2, int width, int height) {
        this.ensureValidCache(g2);
        int glyphCount = this.cachedGlyphShapes.length;
        float offsetX = ((float)width - this.cachedTextWidth) / 2.0f;
        float offsetY = ((float)height + this.cachedTextHeight) / 2.0f - this.getAdjustedDescent();
        g2.translate(offsetX, offsetY);
        for (int i = glyphCount - 1; i >= 0; --i) {
            float scale = this.scaleAt(i);
            g2.setColor(this.colorAt(i));
            double glyphX = this.cachedGlyphVector.getGlyphPosition(i).getX();
            double glyphY = this.cachedGlyphVector.getGlyphVisualBounds(i).getBounds2D().getHeight();
            double adjustX = -glyphX * (double)(scale - 1.0f);
            double adjustY = glyphY * (double)(scale - 1.0f) / 2.0;
            g2.translate(adjustX, adjustY);
            g2.scale(scale, scale);
            g2.fill(this.cachedGlyphShapes[i]);
            g2.scale(1.0f / scale, 1.0f / scale);
            g2.translate(-adjustX, -adjustY);
        }
        g2.translate(-offsetX, -offsetY);
    }
}

