/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation;

import com.jgoodies.animation.AbstractAnimation;
import com.jgoodies.animation.Animation;
import com.jgoodies.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class Animations {
    private Animations() {
    }

    public static Animation offset(Animation animation, long beginTime) {
        return new OffsetAnimation(beginTime, animation);
    }

    public static Animation parallel(List<Animation> animations) {
        return new ParallelAnimation(animations);
    }

    public static Animation parallel(Animation ... animations) {
        return Animations.parallel(Arrays.asList(animations));
    }

    public static Animation pause(long duration) {
        return new PauseAnimation(duration);
    }

    public static Animation repeat(Animation animation, float repeatCount) {
        return Animations.repeat(animation, (long)((float)animation.duration() * repeatCount));
    }

    public static Animation repeat(Animation animation, long duration) {
        return new RepeatedAnimation(duration, animation);
    }

    public static Animation reverse(Animation animation) {
        return new ReversedAnimation(animation);
    }

    public static Animation sequential(List<Animation> animations) {
        return new SequencedAnimation(animations);
    }

    public static Animation sequential(Animation ... animations) {
        return Animations.sequential(Arrays.asList(animations));
    }

    private static final class SequencedAnimation
    extends AbstractAnimation {
        private final List<Animation> animations;

        private SequencedAnimation(List<Animation> animations) {
            super(SequencedAnimation.cumulatedDuration(animations), true);
            Preconditions.checkArgument((!animations.isEmpty() ? 1 : 0) != 0, (String)"The list of animations must not be empty.");
            this.animations = Collections.unmodifiableList(animations);
        }

        private static long cumulatedDuration(List<Animation> animations) {
            long cumulatedDuration = 0L;
            for (Animation animation : animations) {
                cumulatedDuration += animation.duration();
            }
            return cumulatedDuration;
        }

        @Override
        protected void applyEffect(long time) {
            long startTime = 0L;
            for (Animation animation : this.animations) {
                long relativeTime = time - startTime;
                if (relativeTime > 0L) {
                    animation.animate(relativeTime);
                }
                startTime += animation.duration();
            }
        }
    }

    private static final class ReversedAnimation
    extends AbstractAnimation {
        private final Animation animation;

        private ReversedAnimation(Animation animation) {
            super(animation.duration(), true);
            this.animation = animation;
        }

        @Override
        protected void applyEffect(long time) {
            long reversedTime = this.duration() - time;
            Preconditions.checkArgument((reversedTime >= 0L ? 1 : 0) != 0, (String)"The time must be in the valid time interval.");
            this.animation.animate(reversedTime);
        }
    }

    private static final class RepeatedAnimation
    extends AbstractAnimation {
        private final Animation animation;
        private final long simpleDuration;

        private RepeatedAnimation(long duration, Animation animation) {
            super(duration, true);
            this.animation = animation;
            this.simpleDuration = animation.duration();
        }

        @Override
        protected void applyEffect(long time) {
            this.animation.animate(time % this.simpleDuration);
        }
    }

    private static final class PauseAnimation
    extends AbstractAnimation {
        PauseAnimation(long duration) {
            super(duration, true);
        }

        @Override
        protected void applyEffect(long time) {
        }
    }

    private static final class ParallelAnimation
    extends AbstractAnimation {
        private final List<Animation> animations;

        private ParallelAnimation(List<Animation> animations) {
            super(ParallelAnimation.maxDuration(animations), true);
            this.animations = Collections.unmodifiableList(animations);
        }

        private static long maxDuration(List<Animation> animations) {
            long maxDuration = 0L;
            for (Animation animation : animations) {
                long duration = animation.duration();
                if (duration <= maxDuration) continue;
                maxDuration = duration;
            }
            return maxDuration;
        }

        @Override
        protected void applyEffect(long time) {
            for (Animation animation : this.animations) {
                animation.animate(time);
            }
        }
    }

    public static abstract class OneTimeAnimation
    extends AbstractAnimation {
        private boolean effectApplied = false;

        public OneTimeAnimation() {
            super(0L, true);
        }

        @Override
        public void animate(long time) {
            if (this.effectApplied) {
                return;
            }
            this.fireAnimationStarted(time);
            this.applyEffect(time);
            this.fireAnimationStopped(time);
            this.effectApplied = true;
        }
    }

    private static final class OffsetAnimation
    extends AbstractAnimation {
        private final Animation animation;
        private final long beginTime;

        private OffsetAnimation(long beginTime, Animation animation) {
            super(beginTime + animation.duration(), true);
            this.animation = animation;
            this.beginTime = beginTime;
        }

        @Override
        protected void applyEffect(long time) {
            long relativeTime = time - this.beginTime;
            if (relativeTime >= 0L) {
                this.animation.animate(relativeTime);
            }
        }
    }
}

