/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation;

import com.jgoodies.animation.AbstractAnimationFunction;
import com.jgoodies.animation.AnimationFunction;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public final class AnimationFunctions {
    public static final AnimationFunction<Float> ONE = AnimationFunctions.constant(Integer.MAX_VALUE, new Float(1.0f));
    public static final AnimationFunction<Float> ZERO = AnimationFunctions.constant(Integer.MAX_VALUE, new Float(0.0f));

    private AnimationFunctions() {
    }

    public static AnimationFunction<Color> alphaColor(AnimationFunction<Integer> f, Color baseColor) {
        return new AlphaColorAnimationFunction(f, baseColor);
    }

    public static <T> AnimationFunction<T> concat(AnimationFunction<T> ... functions) {
        return new SequencedAnimationFunction(Arrays.asList(functions));
    }

    public static <T> AnimationFunction<T> constant(long duration, T value) {
        return AnimationFunctions.discrete(duration, value);
    }

    public static <T> AnimationFunction<T> discrete(long duration, T ... values) {
        return AnimationFunctions.discrete(duration, values, (float[])null);
    }

    public static <T> AnimationFunction<T> discrete(long duration, T[] values, float[] keyTimes) {
        return new InterpolatedAnimationFunction(duration, values, keyTimes, InterpolationMode.DISCRETE);
    }

    public static AnimationFunction<Float> fromBy(long duration, float from, float by) {
        return AnimationFunctions.fromTo(duration, from, from + by);
    }

    public static AnimationFunction<Float> fromTo(long duration, float from, float to) {
        return AnimationFunctions.linear((long)duration, (Number[])new Float[]{Float.valueOf(from), Float.valueOf(to)});
    }

    public static <T extends Number> AnimationFunction<T> linear(long duration, T[] values) {
        return AnimationFunctions.linear((long)duration, values, null);
    }

    public static <T extends Number> AnimationFunction<T> linear(long duration, T[] values, float[] keyTimes) {
        return new InterpolatedAnimationFunction(duration, values, keyTimes, InterpolationMode.LINEAR);
    }

    public static AnimationFunction<Color> linearColors(long duration, Color[] colors, float[] keyTimes) {
        return new ColorFunction(duration, colors, keyTimes);
    }

    public static AnimationFunction<Integer> random(int min, int max, float changeProbability) {
        return new RandomAnimationFunction(min, max, changeProbability);
    }

    public static <T> AnimationFunction<T> repeat(AnimationFunction<T> f, long repeatTime) {
        return new RepeatedAnimationFunction(f, repeatTime);
    }

    public static <T> AnimationFunction<T> reverse(AnimationFunction<T> f) {
        return new ReversedAnimationFunction(f);
    }

    private static final class SequencedAnimationFunction<T>
    implements AnimationFunction<T> {
        private final List<AnimationFunction<T>> functions;

        private SequencedAnimationFunction(List<AnimationFunction<T>> functions) {
            this.functions = Collections.unmodifiableList(functions);
            if (this.functions.isEmpty()) {
                throw new IllegalArgumentException("The list of functions must not be empty.");
            }
        }

        @Override
        public long duration() {
            long cumulatedDuration = 0L;
            for (AnimationFunction<T> f : this.functions) {
                cumulatedDuration += f.duration();
            }
            return cumulatedDuration;
        }

        @Override
        public T valueAt(long time) {
            if (time < 0L) {
                throw new IllegalArgumentException("The time must be positive.");
            }
            long begin = 0L;
            for (AnimationFunction<T> f : this.functions) {
                long end = begin + f.duration();
                if (time < end) {
                    return f.valueAt(time - begin);
                }
                begin = end;
            }
            throw new IllegalArgumentException("The time must be smaller than the total duration.");
        }
    }

    private static final class ReversedAnimationFunction<T>
    extends AbstractAnimationFunction<T> {
        private final AnimationFunction<T> f;

        private ReversedAnimationFunction(AnimationFunction<T> f) {
            super(f.duration());
            this.f = f;
        }

        @Override
        public T valueAt(long time) {
            return this.f.valueAt(this.duration() - time);
        }
    }

    private static final class RepeatedAnimationFunction<T>
    extends AbstractAnimationFunction<T> {
        private final AnimationFunction<T> f;
        private final long simpleDuration;

        private RepeatedAnimationFunction(AnimationFunction<T> f, long repeatTime) {
            super(repeatTime);
            this.f = f;
            this.simpleDuration = f.duration();
        }

        @Override
        public T valueAt(long time) {
            return this.f.valueAt(time % this.simpleDuration);
        }
    }

    private static final class RandomAnimationFunction
    implements AnimationFunction<Integer> {
        private final float changeProbability;
        private final int max;
        private final int min;
        private final Random random = new Random();
        private Integer value;

        private RandomAnimationFunction(int min, int max, float changeProbability) {
            this.min = min;
            this.max = max;
            this.changeProbability = changeProbability;
        }

        @Override
        public long duration() {
            return Integer.MAX_VALUE;
        }

        @Override
        public Integer valueAt(long time) {
            if (this.value == null || this.random.nextFloat() < this.changeProbability) {
                this.value = new Integer(this.min + this.random.nextInt(this.max - this.min));
            }
            return this.value;
        }
    }

    private static final class InterpolatedAnimationFunction<T>
    extends AbstractAnimationFunction<T> {
        private final float[] keyTimes;
        private final InterpolationMode mode;
        private final T[] values;

        private InterpolatedAnimationFunction(long duration, T[] values, float[] keyTimes, InterpolationMode mode) {
            super(duration);
            this.values = values;
            this.keyTimes = keyTimes;
            this.mode = mode;
            InterpolatedAnimationFunction.checkValidKeyTimes(values.length, keyTimes);
        }

        private static void checkValidKeyTimes(int valuesLength, float[] theKeyTimes) {
            if (theKeyTimes == null) {
                return;
            }
            if (valuesLength < 2 || valuesLength != theKeyTimes.length) {
                throw new IllegalArgumentException("The values and key times arrays must be non-empty and must have equal length.");
            }
            for (int index = 0; index < theKeyTimes.length - 2; ++index) {
                if (!(theKeyTimes[index] >= theKeyTimes[index + 1])) continue;
                throw new IllegalArgumentException("The key times must be increasing.");
            }
        }

        private T discreteValueAt(long time) {
            return this.values[this.indexAt(time, this.values.length)];
        }

        private int indexAt(long time, int intervalCount) {
            long duration = this.duration();
            if (this.keyTimes == null) {
                return (int)(time * (long)intervalCount / duration);
            }
            for (int index = this.keyTimes.length - 1; index > 0; --index) {
                if (!((float)time >= (float)duration * this.keyTimes[index])) continue;
                return index;
            }
            return 0;
        }

        private T interpolateLinear(T value1, T value2, long time, long duration) {
            float f1 = ((Number)value1).floatValue();
            float f2 = ((Number)value2).floatValue();
            float value = f1 + (f2 - f1) * (float)time / (float)duration;
            if (value1 instanceof Float) {
                return (T)Float.valueOf(value);
            }
            return (T)Integer.valueOf((int)value);
        }

        private T linearValueAt(long time) {
            int segments = this.values.length - 1;
            int beginIndex = this.indexAt(time, segments);
            int endIndex = beginIndex + 1;
            long lastTime = this.duration() - 1L;
            long beginTime = this.keyTimes == null ? (long)beginIndex * lastTime / (long)segments : (long)(this.keyTimes[beginIndex] * (float)lastTime);
            long endTime = this.keyTimes == null ? (long)endIndex * lastTime / (long)segments : (long)(this.keyTimes[endIndex] * (float)lastTime);
            return this.interpolateLinear(this.values[beginIndex], this.values[endIndex], time - beginTime, endTime - beginTime);
        }

        @Override
        public T valueAt(long time) {
            this.checkTimeRange(time);
            switch (this.mode) {
                case DISCRETE: {
                    return this.discreteValueAt(time);
                }
                case LINEAR: {
                    return this.linearValueAt(time);
                }
            }
            throw new UnsupportedOperationException("Unsupported interpolation mode.");
        }
    }

    public static enum InterpolationMode {
        DISCRETE,
        LINEAR;

    }

    private static final class ColorFunction
    extends AbstractAnimationFunction<Color> {
        private final AnimationFunction<Integer> redFunction;
        private final AnimationFunction<Integer> greenFunction;
        private final AnimationFunction<Integer> blueFunction;
        private final AnimationFunction<Integer> alphaFunction;

        private ColorFunction(long duration, Color[] colors, float[] keyTimes) {
            super(duration);
            Number[] red = new Integer[colors.length];
            Number[] green = new Integer[colors.length];
            Number[] blue = new Integer[colors.length];
            Number[] alpha = new Integer[colors.length];
            for (int i = 0; i < colors.length; ++i) {
                red[i] = colors[i].getRed();
                green[i] = colors[i].getGreen();
                blue[i] = colors[i].getBlue();
                alpha[i] = colors[i].getAlpha();
            }
            this.redFunction = AnimationFunctions.linear((long)duration, (Number[])red, (float[])keyTimes);
            this.greenFunction = AnimationFunctions.linear((long)duration, (Number[])green, (float[])keyTimes);
            this.blueFunction = AnimationFunctions.linear((long)duration, (Number[])blue, (float[])keyTimes);
            this.alphaFunction = AnimationFunctions.linear((long)duration, (Number[])alpha, (float[])keyTimes);
        }

        @Override
        public Color valueAt(long time) {
            this.checkTimeRange(time);
            return new Color(this.redFunction.valueAt(time), this.greenFunction.valueAt(time), this.blueFunction.valueAt(time), this.alphaFunction.valueAt(time));
        }
    }

    private static final class AlphaColorAnimationFunction
    implements AnimationFunction<Color> {
        private final Color baseColor;
        private final AnimationFunction<Integer> fAlpha;

        private AlphaColorAnimationFunction(AnimationFunction<Integer> fAlpha, Color baseColor) {
            this.fAlpha = fAlpha;
            this.baseColor = baseColor;
        }

        @Override
        public long duration() {
            return this.fAlpha.duration();
        }

        @Override
        public Color valueAt(long time) {
            return new Color(this.baseColor.getRed(), this.baseColor.getGreen(), this.baseColor.getBlue(), this.fAlpha.valueAt(time));
        }
    }
}

