/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.util;

import de.proveo.domain.values.datasync.DatasyncMetainfoValue;
import de.proveo.domain.values.datasync.DatasyncResourceValue;
import de.proveo.domain.values.datasync.DatasyncTaskValue;
import de.proveo.domain.values.infoman.MetaInfoKey;
import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.api.RemoteDevice;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.core.util.VersionsCompareUtil;
import de.proveo.idm.remote.server.api.RemoteInfoman;
import de.proveo.idm.remote.server.api.RemoteUpdateAdapter;
import de.proveo.idm.remote.server.gui.TimeResourceSelectorPanel;
import de.proveo.idm.software.archive.api.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.openide.util.NbBundle;

public class RemoteUpdateHandler {
    private static final Logger log = Logger.getLogger(RemoteUpdateHandler.class.getName());
    private static final String HW_PLATFORM_KEY = "GenLoc";

    public static DatasyncTaskValue createDatasyncTask(boolean datasyncAllowed, boolean softwareNeeded, boolean softwareSelectionPossible, RemoteInfoman infoman, String resourceType) throws Exception {
        return RemoteUpdateHandler.createDatasyncTask(datasyncAllowed, softwareNeeded, softwareSelectionPossible, infoman.getUnitId(), infoman.getSerialNumber(), infoman.getSoftwareVersion(), infoman.getDeviceType(), resourceType, infoman.getServer().getRemoteUpdateAdapter(), infoman.getServer().getTimeZoneID(), infoman);
    }

    public static DatasyncTaskValue createDatasyncTask(boolean datasyncAllowed, boolean softwareNeeded, boolean softwareSelectionPossible, long unitId, String infomanSerialNumber, String infomanSoftwareVersion, Device.DeviceType deviceType, String resourceType, RemoteUpdateAdapter remoteUpdateAdapter, String timeZoneId, RemoteDevice remoteDevice) throws Exception {
        DatasyncResourceValue updateResource;
        if (deviceType == null) {
            deviceType = Device.DeviceType.INFOMAN;
        }
        if (softwareNeeded) {
            softwareSelectionPossible = true;
        }
        boolean additionalResourceUploadEnabled = true;
        if (deviceType.equals((Object)Device.DeviceType.INFOMAN)) {
            boolean versionGreaterOrEqualToDatasyncVersion = false;
            if (infomanSoftwareVersion != null) {
                versionGreaterOrEqualToDatasyncVersion = VersionsCompareUtil.isVersionGreaterOrEqual((String)infomanSoftwareVersion, (String)"1.12.0");
            }
            if (!versionGreaterOrEqualToDatasyncVersion) {
                datasyncAllowed = false;
            }
            if (!datasyncAllowed || !versionGreaterOrEqualToDatasyncVersion) {
                additionalResourceUploadEnabled = false;
            }
        }
        if ((updateResource = RemoteUpdateHandler.selectResource(datasyncAllowed, softwareNeeded, softwareSelectionPossible, additionalResourceUploadEnabled, deviceType, resourceType, remoteUpdateAdapter, timeZoneId, null, remoteDevice)) == null) {
            return null;
        }
        long scheduledUpdateTime = updateResource.getValidFrom();
        String resName = updateResource.getResourceName();
        if (resName == null) {
            updateResource = null;
        }
        DatasyncTaskValue task = new DatasyncTaskValue();
        task.setClientId(unitId);
        task.setClientSerialNumber(infomanSerialNumber);
        task.setIdentifier("REMOTE_UPDATE");
        task.setTaskInfo("softwareUpdate");
        task.setValidFrom(scheduledUpdateTime);
        ArrayList<DatasyncResourceValue> taskResources = new ArrayList<DatasyncResourceValue>();
        if (updateResource != null) {
            taskResources.add(updateResource);
        }
        task.setResources(taskResources);
        if (!softwareNeeded || updateResource != null) {
            return task;
        }
        return null;
    }

    public static DatasyncTaskValue createDatasyncTask(RemoteInfoman infoman, String resourceType, DatasyncResourceValue updateResource, long scheduledUpdateTime) throws Exception {
        return RemoteUpdateHandler.createDatasyncTask(infoman.getUnitId(), infoman.getSerialNumber(), resourceType, updateResource, scheduledUpdateTime);
    }

    public static DatasyncTaskValue createDatasyncTask(long unitId, String infomanSerialNumber, String resourceType, DatasyncResourceValue updateResource, long scheduledUpdateTime) throws Exception {
        DatasyncTaskValue task = new DatasyncTaskValue();
        task.setClientId(unitId);
        task.setClientSerialNumber(infomanSerialNumber);
        if ("Telit Modem Firmware".equals(resourceType)) {
            task.setIdentifier("TELIT_MODEM_UPDATE");
            task.setTaskInfo("telitModemFirmwareUpdate");
        } else if ("Software".equals(resourceType)) {
            task.setIdentifier("REMOTE_UPDATE");
            task.setTaskInfo("softwareUpdate");
        } else {
            log.log(Level.WARNING, "Unknown resource type: {0}. Use software identifiers.", resourceType);
            task.setIdentifier("REMOTE_UPDATE");
            task.setTaskInfo("softwareUpdate");
        }
        task.setValidFrom(scheduledUpdateTime);
        ArrayList<DatasyncResourceValue> taskResources = new ArrayList<DatasyncResourceValue>();
        if (updateResource != null) {
            taskResources.add(updateResource);
        }
        task.setResources(taskResources);
        return task;
    }

    public static HardwarePlatformConsistentCheck getHardwarePlatformConsistancy(Collection<RemoteDevice> keySet) {
        String hardwarePlatformCommon = null;
        for (RemoteDevice device : keySet) {
            String hardwarePlatform = RemoteUpdateHandler.getHardwarePlatform(device);
            if (hardwarePlatform == null) {
                return HardwarePlatformConsistentCheck.UNKOWN;
            }
            if (hardwarePlatformCommon == null) {
                hardwarePlatformCommon = hardwarePlatform;
                continue;
            }
            if (hardwarePlatform.equals(hardwarePlatformCommon)) continue;
            return HardwarePlatformConsistentCheck.NOT_CONSISTENT;
        }
        if (hardwarePlatformCommon == null) {
            return HardwarePlatformConsistentCheck.UNKOWN;
        }
        return HardwarePlatformConsistentCheck.CONSISTENT;
    }

    public static DatasyncResourceValue selectResource(boolean datasyncAllowed, boolean softwareNeeded, boolean softwareSelectionPossible, boolean additionalResourceUploadEnabled, Device.DeviceType deviceType, String resourceType, RemoteUpdateAdapter remoteUpdateAdapter, String timeZoneId, DatasyncResourceValue softwareResource) {
        return RemoteUpdateHandler.selectResource(datasyncAllowed, softwareNeeded, softwareSelectionPossible, additionalResourceUploadEnabled, deviceType, resourceType, remoteUpdateAdapter, timeZoneId, softwareResource, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DatasyncResourceValue selectResource(boolean datasyncAllowed, boolean softwareNeeded, boolean softwareSelectionPossible, boolean additionalResourceUploadEnabled, Device.DeviceType deviceType, String resourceType, RemoteUpdateAdapter remoteUpdateAdapter, String timeZoneId, DatasyncResourceValue softwareResource, RemoteDevice remoteDevice) {
        Collection<DatasyncResourceValue> resources;
        if (deviceType == null) {
            deviceType = Device.DeviceType.INFOMAN;
        }
        if (softwareNeeded) {
            softwareSelectionPossible = true;
        }
        TimeResourceSelectorPanel panel = new TimeResourceSelectorPanel(deviceType, resourceType, -1L, timeZoneId);
        panel.setResourceSelectionEnabled(softwareSelectionPossible);
        panel.setResourceSelectionOptional(!softwareNeeded);
        panel.setAdditionalResourceUploadEnabled(additionalResourceUploadEnabled);
        try {
            resources = remoteUpdateAdapter.getAvailableResources(deviceType, resourceType);
        }
        catch (Exception ex) {
            resources = new ArrayList<DatasyncResourceValue>();
        }
        if (deviceType.equals((Object)Device.DeviceType.INFOMAN)) {
            if (datasyncAllowed) {
                if ("Software".equals(resourceType)) {
                    panel.setAcceptedResourceTypes(Resource.ResourceType.INFOMAN_INSTALL_ARCHIVE, Resource.ResourceType.INFOMAN_UPDATE_ARCHIVE);
                } else {
                    if (!"Telit Modem Firmware".equals(resourceType)) throw new UnsupportedOperationException("Unsupported resource type for device type '" + deviceType + "': " + resourceType);
                    panel.setAcceptedResourceTypes(Resource.ResourceType.MODEM_FIRMWARE);
                }
            } else {
                try {
                    resources = remoteUpdateAdapter.getAvailableSoftware();
                }
                catch (Exception ex) {
                    resources = new ArrayList<DatasyncResourceValue>();
                }
                panel.setAdditionalResourceUploadEnabled(false);
            }
        } else {
            if (!deviceType.equals((Object)Device.DeviceType.INFOMAN_EFM)) throw new UnsupportedOperationException("Device type '" + deviceType + "' not supported yet");
            RemoteUpdateHandler.filterResources(resources, remoteDevice);
            if (!"Software".equals(resourceType)) throw new UnsupportedOperationException("Unsupported resource type for device type '" + deviceType + "': " + resourceType);
            panel.setAcceptedResourceTypes(Resource.ResourceType.APPLICATION_BOOT, Resource.ResourceType.APPLICATION);
        }
        panel.addResources(resources);
        if (softwareResource == null) return RemoteUpdateHandler.selectResource(panel);
        panel.setSelectedResource(softwareResource);
        return RemoteUpdateHandler.selectResource(panel);
    }

    private static DatasyncResourceValue selectResource(TimeResourceSelectorPanel panel) {
        long scheduledUpdateTime = 0L;
        DatasyncResourceValue updateResource = null;
        Object option = null;
        do {
            if (!DialogUtil.OK_OPTION.equals(option = DialogUtil.showMessageDialog((Object)panel, (String)NbBundle.getMessage(RemoteUpdateHandler.class, (String)"RemoteUpdateHandler.title", (Object)panel.getResourceType().toLowerCase()), (boolean)true, (int)-1, (int)2))) continue;
            scheduledUpdateTime = panel.getScheduledUpdateTime();
            updateResource = panel.getSelectedResource();
            if (panel.isResourceSelectionOptional() || updateResource != null) break;
            String errorMessage = NbBundle.getMessage(RemoteUpdateHandler.class, (String)"RemoteUpdateHandler.error.nosoftware", (Object)panel.getResourceType().toLowerCase());
            DialogUtil.showErrorDialog((Object)errorMessage);
        } while (DialogUtil.OK_OPTION.equals(option));
        if (!DialogUtil.OK_OPTION.equals(option)) {
            return null;
        }
        if (updateResource == null) {
            if (!panel.isResourceSelectionOptional()) {
                return null;
            }
            updateResource = new DatasyncResourceValue();
        }
        updateResource.setValidFrom(scheduledUpdateTime);
        return updateResource;
    }

    public static Map<Long, DatasyncTaskValue> createDatasyncTasks(boolean softwareNeeded, List<RemoteDevice> infomans, String resourceType, long updateTime) throws Exception {
        HashMap<Long, DatasyncTaskValue> ret = new HashMap<Long, DatasyncTaskValue>();
        for (RemoteDevice infoman : infomans) {
            long unitId = infoman.getUnitId();
            String serialNumber = infoman.getSerialNumber();
            DatasyncTaskValue task = new DatasyncTaskValue();
            task.setClientId(unitId);
            task.setClientSerialNumber(serialNumber);
            if ("Telit Modem Firmware".equals(resourceType)) {
                task.setIdentifier("TELIT_MODEM_UPDATE");
                task.setTaskInfo("telitModemFirmwareUpdate");
            } else if ("Software".equals(resourceType)) {
                task.setIdentifier("REMOTE_UPDATE");
                task.setTaskInfo("softwareUpdate");
            } else {
                log.log(Level.WARNING, "Unknown resource type: {0}. Use software identifiers.", resourceType);
                task.setIdentifier("REMOTE_UPDATE");
                task.setTaskInfo("softwareUpdate");
            }
            task.setValidFrom(updateTime);
            task.setResources(new ArrayList());
            ret.put(unitId, task);
        }
        return ret;
    }

    public static DatasyncTaskValue updateDatasyncTask(DatasyncTaskValue task, RemoteInfoman infoman) throws Exception {
        return RemoteUpdateHandler.updateDatasyncTask(task, infoman.getUnitId(), infoman.getSerialNumber(), infoman.getSoftwareVersion(), infoman.getDeviceType(), infoman.getServer().getRemoteUpdateAdapter(), infoman.getServer().getTimeZoneID());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DatasyncTaskValue updateDatasyncTask(DatasyncTaskValue task, long unitId, String infomanSerialNumber, String infomanSoftwareVersion, Device.DeviceType deviceType, RemoteUpdateAdapter remoteUpdateAdapter, String timeZoneId) throws Exception {
        DatasyncResourceValue updateResource;
        List metaInfos;
        String remoteResourceType;
        if (deviceType == null) {
            deviceType = Device.DeviceType.INFOMAN;
        }
        String taskInfo = task.getTaskInfo();
        List currentResources = task.getResources();
        String resourceType = null;
        DatasyncResourceValue softwareResource = null;
        boolean softwareNeeded = false;
        boolean softwareSelectionPossible = false;
        if (taskInfo == null) throw new UnsupportedOperationException("Cannot update task without TaskInfo!");
        if (taskInfo.equals("telitModemFirmwareUpdate")) {
            resourceType = "Telit Modem Firmware";
            remoteResourceType = deviceType.toString() + StringUtils.remove((String)resourceType, (char)' ');
            softwareNeeded = true;
            softwareSelectionPossible = true;
            for (DatasyncResourceValue value : currentResources) {
                metaInfos = value.getMetainfos();
                for (DatasyncMetainfoValue meta : metaInfos) {
                    if (!meta.getKey().equals(MetaInfoKey.RESOURCE_TYPE.toString()) || !meta.getValue().equals(remoteResourceType)) continue;
                    softwareResource = value;
                    break;
                }
                if (softwareResource == null) continue;
                break;
            }
        } else {
            if (!taskInfo.equals("softwareUpdate")) throw new UnsupportedOperationException("Cannot update '" + taskInfo + "' task!");
            resourceType = "Software";
            remoteResourceType = deviceType.toString() + StringUtils.remove((String)resourceType, (char)' ');
            softwareNeeded = true;
            softwareSelectionPossible = true;
            for (DatasyncResourceValue value : currentResources) {
                metaInfos = value.getMetainfos();
                for (DatasyncMetainfoValue meta : metaInfos) {
                    if (meta.getKey().equals(MetaInfoKey.TYPE.toString()) && meta.getValue().equals("INFOMAN_CONFIG")) {
                        softwareNeeded = false;
                        break;
                    }
                    if (!meta.getKey().equals(MetaInfoKey.RESOURCE_TYPE.toString()) || !meta.getValue().equals(remoteResourceType)) continue;
                    softwareResource = value;
                    break;
                }
                if (softwareNeeded || softwareResource == null) continue;
                break;
            }
        }
        if (softwareNeeded) {
            softwareSelectionPossible = true;
        }
        boolean additionalResourceUploadEnabled = true;
        if (deviceType.equals((Object)Device.DeviceType.INFOMAN)) {
            boolean versionGreaterOrEqualToDatasyncVersion = false;
            if (infomanSoftwareVersion != null) {
                versionGreaterOrEqualToDatasyncVersion = VersionsCompareUtil.isVersionGreaterOrEqual((String)infomanSoftwareVersion, (String)"1.12.0");
            }
            if (!versionGreaterOrEqualToDatasyncVersion) {
                additionalResourceUploadEnabled = false;
            }
        }
        if ((updateResource = RemoteUpdateHandler.selectResource(true, softwareNeeded, softwareSelectionPossible, additionalResourceUploadEnabled, deviceType, resourceType, remoteUpdateAdapter, timeZoneId, softwareResource, null)) == null) {
            return null;
        }
        long scheduledUpdateTime = updateResource.getValidFrom();
        String resName = updateResource.getResourceName();
        if (resName == null) {
            updateResource = null;
        }
        DatasyncTaskValue updatedTask = new DatasyncTaskValue();
        updatedTask.setTaskId(task.getTaskId());
        updatedTask.setClientId(unitId);
        updatedTask.setClientSerialNumber(infomanSerialNumber);
        updatedTask.setIdentifier(task.getIdentifier());
        updatedTask.setTaskInfo(taskInfo);
        updatedTask.setValidFrom(scheduledUpdateTime);
        ArrayList<DatasyncResourceValue> taskResources = new ArrayList<DatasyncResourceValue>();
        if (updateResource != null) {
            taskResources.add(updateResource);
        }
        updatedTask.setResources(taskResources);
        if (softwareNeeded && updateResource == null) return null;
        return updatedTask;
    }

    protected static String getHardwarePlatform(RemoteDevice remoteDevice) {
        SortedMap env;
        if (remoteDevice == null) {
            return null;
        }
        try {
            env = remoteDevice.getEnv();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Runs for " + remoteDevice.getName() + " into", ex);
            return null;
        }
        if (env == null) {
            return null;
        }
        String hwPlatformStr = StringUtils.trimToNull((String)((String)env.get("hardware")));
        if (hwPlatformStr == null) {
            return null;
        }
        return RemoteUpdateHandler.extractHardwarePlatform(hwPlatformStr);
    }

    protected static void filterResources(Collection<DatasyncResourceValue> resources, RemoteDevice remoteDevice) {
        if (remoteDevice == null) {
            return;
        }
        String hardwarePlatform = RemoteUpdateHandler.getHardwarePlatform(remoteDevice);
        if (hardwarePlatform != null) {
            Iterator<DatasyncResourceValue> it = resources.iterator();
            while (it.hasNext()) {
                DatasyncResourceValue resource = it.next();
                String platform = RemoteUpdateHandler.getHardwarePlatformOfFirmware(resource.getResourceName());
                if (hardwarePlatform.equals(platform)) continue;
                it.remove();
            }
        }
    }

    protected static String extractHardwarePlatform(String hardware) {
        String hwPlatform = null;
        int beginIndex = hardware.indexOf(HW_PLATFORM_KEY);
        if (beginIndex > -1) {
            String hardwareReduced = hardware.substring(beginIndex);
            int endIndex = StringUtils.indexOfAny((CharSequence)hardwareReduced, (char[])new char[]{' ', '-'});
            hwPlatform = endIndex > -1 ? hardwareReduced.substring(0, endIndex) : hardwareReduced;
        }
        return hwPlatform;
    }

    protected static String getHardwarePlatformOfFirmware(String softwareFilePath) {
        if (softwareFilePath == null) {
            return null;
        }
        if (softwareFilePath.endsWith("_boot.bin")) {
            return "GenLoc53e";
        }
        if (softwareFilePath.endsWith("_boot_sdram_lzo.bin") || softwareFilePath.endsWith("_boot_sdram_none.bin")) {
            return "GenLoc54e";
        }
        return null;
    }

    public static enum HardwarePlatformConsistentCheck {
        CONSISTENT,
        NOT_CONSISTENT,
        UNKOWN;

    }
}

