/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.userauthentication.api;

import de.proveo.idm.remote.server.userauthentication.api.IDReceivedListener;
import de.proveo.idm.remote.server.userauthentication.api.UserAuthenticationIDListener;
import de.proveo.idm.remote.server.userauthentication.api.UserAuthenticationProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.apache.commons.lang3.ObjectUtils;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class UserAuthenticationFactory {
    public static final String PROP_USER_AUTHENTICATION_TYPE = "userAuthenticationType";
    private static final Object lock = new Object();
    private static UserAuthenticationFactory instance = null;
    private final IDReceivedFromProviderListener providerListener = new IDReceivedFromProviderListener();
    protected final List<UserAuthenticationIDListener> listeners = new ArrayList<UserAuthenticationIDListener>();
    protected UserAuthenticationProvider provider = null;

    private UserAuthenticationFactory() {
        Preferences prefs = NbPreferences.forModule(UserAuthenticationFactory.class);
        String userAuthenticationType = prefs.get(PROP_USER_AUTHENTICATION_TYPE, "");
        this.provider = this.getProviderByName(userAuthenticationType);
        if (this.provider != null) {
            this.provider.registerListener(this.providerListener);
        }
        prefs.addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                if (UserAuthenticationFactory.PROP_USER_AUTHENTICATION_TYPE.equals(evt.getKey())) {
                    UserAuthenticationProvider configured = UserAuthenticationFactory.this.getProviderByName(evt.getNewValue());
                    UserAuthenticationFactory.this.providerChanged(configured);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterListener(UserAuthenticationIDListener l) {
        if (l != null) {
            List<UserAuthenticationIDListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(l);
            }
        }
    }

    public Collection<? extends UserAuthenticationProvider> getAllProviders() {
        return Lookup.getDefault().lookupAll(UserAuthenticationProvider.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserAuthenticationFactory getInstance() {
        Object object = lock;
        synchronized (object) {
            if (instance == null) {
                instance = new UserAuthenticationFactory();
            }
            return instance;
        }
    }

    private UserAuthenticationProvider getProviderByName(String name) {
        Collection<? extends UserAuthenticationProvider> providers = this.getAllProviders();
        for (UserAuthenticationProvider userAuthenticationProvider : providers) {
            if (!userAuthenticationProvider.getName().equals(name)) continue;
            return userAuthenticationProvider;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void providerChanged(UserAuthenticationProvider provider) {
        if (ObjectUtils.notEqual((Object)this.provider, (Object)provider)) {
            List<UserAuthenticationIDListener> list = this.listeners;
            synchronized (list) {
                if (this.provider != null) {
                    this.provider.deregisterListener();
                    this.provider.cleanUp();
                }
                this.provider = provider;
                if (this.provider != null) {
                    this.provider.registerListener(this.providerListener);
                    if (!this.listeners.isEmpty()) {
                        this.provider.init();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(UserAuthenticationIDListener l) {
        if (l != null) {
            List<UserAuthenticationIDListener> list = this.listeners;
            synchronized (list) {
                if (this.listeners.isEmpty() && this.provider != null) {
                    this.provider.init();
                }
                this.listeners.add(l);
            }
        }
    }

    private class IDReceivedFromProviderListener
    implements IDReceivedListener {
        private IDReceivedFromProviderListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receivedId(String id) {
            List<UserAuthenticationIDListener> list = UserAuthenticationFactory.this.listeners;
            synchronized (list) {
                for (UserAuthenticationIDListener l : UserAuthenticationFactory.this.listeners) {
                    l.receivedId(id);
                }
            }
        }
    }
}

