/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.services;

import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.api.EFMServerData;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.NavigationItemManager;
import de.proveo.idm.core.gui.navigation.api.RemoteDevice;
import de.proveo.idm.core.gui.navigation.api.RemoteNavigationItem;
import de.proveo.idm.core.gui.navigation.api.RemoteNavigationManager;
import de.proveo.idm.remote.server.api.EFMServer;
import de.proveo.idm.remote.server.navigation.EFMServerNavigationItem;
import de.proveo.idm.remote.server.navigation.ServersRootNavigationItem;
import de.proveo.idm.remote.server.navigation.nodes.DatasyncTaskNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class RemoteNavigationManagerImpl
implements RemoteNavigationManager {
    private final NavigationItemManager navigationItemManager;
    private static final String PREF_CONFIGURED_SERVERS_KEY = "configuredServers";
    private final List<NavigationItem> server = new ArrayList<NavigationItem>();

    public RemoteNavigationManagerImpl() {
        this.navigationItemManager = (NavigationItemManager)Lookup.getDefault().lookup(NavigationItemManager.class);
    }

    public boolean isAllowedInfomanNode(Node node, Device.DeviceType deviceType) {
        RemoteNavigationItem.Type type;
        EFMServer efmServer;
        if (node instanceof DatasyncTaskNode) {
            return false;
        }
        EFMServerNavigationItem serverItem = (EFMServerNavigationItem)node.getLookup().lookup(EFMServerNavigationItem.class);
        if (serverItem != null && ((efmServer = serverItem.getServerInstance()) == null || efmServer.getIDMCredentials() == null)) {
            return false;
        }
        RemoteNavigationItem item = (RemoteNavigationItem)node.getLookup().lookup(RemoteNavigationItem.class);
        if (item != null && (type = item.getType()) != null && type != RemoteNavigationItem.Type.INSTALLED_DEVICES && type != RemoteNavigationItem.Type.NOT_INSTALLED_DEVICES) {
            return false;
        }
        RemoteDevice remoteInfoman = (RemoteDevice)node.getLookup().lookup(RemoteDevice.class);
        if (remoteInfoman != null) {
            Device.DeviceType devType = remoteInfoman.getDeviceType();
            if (devType == null) {
                devType = Device.DeviceType.INFOMAN;
            }
            if (!(deviceType.equals((Object)Device.DeviceType.ANY) || deviceType.equals((Object)Device.DeviceType.UNKNOWN) || deviceType.equals((Object)devType))) {
                return false;
            }
        }
        return true;
    }

    public void init() {
        ServersRootNavigationItem root = new ServersRootNavigationItem();
        this.navigationItemManager.addTopLevel((NavigationItem)root);
        Preferences preferences = NbPreferences.forModule(RemoteNavigationManagerImpl.class);
        byte[] in = preferences.getByteArray(PREF_CONFIGURED_SERVERS_KEY, null);
        if (in == null) {
            return;
        }
        ArrayList<NavigationItem> favoritesItems = new ArrayList<NavigationItem>(this.load(in));
        for (NavigationItem item : favoritesItems) {
            root.addChild(item);
        }
    }

    protected List<NavigationItem> load(byte[] in) {
        ByteArrayInputStream bArrIn = new ByteArrayInputStream(in);
        List serverData = null;
        this.server.clear();
        try {
            ObjectInputStream objIn = new ObjectInputStream(bArrIn);
            serverData = (List)objIn.readObject();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
        for (EFMServerData data : serverData) {
            EFMServerNavigationItem item = new EFMServerNavigationItem(data);
            this.server.add((NavigationItem)item);
        }
        return this.server;
    }

    public void store() {
        this.server.clear();
        ArrayList<EFMServerData> data = new ArrayList<EFMServerData>();
        List topLevel = this.navigationItemManager.getTopLevelNavigationItems();
        List remoteItems = new ArrayList();
        for (NavigationItem item : topLevel) {
            if (!(item instanceof RemoteNavigationItem)) continue;
            remoteItems = ((RemoteNavigationItem)item).getChildren();
        }
        for (NavigationItem item : remoteItems) {
            if (!(item instanceof EFMServerNavigationItem)) continue;
            try {
                EFMServerNavigationItem serverItem = (EFMServerNavigationItem)item;
                EFMServerData sd = serverItem.getServerData();
                data.add((EFMServerData)sd.clone());
                this.server.add((NavigationItem)serverItem);
            }
            catch (CloneNotSupportedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        ByteArrayOutputStream out = this.store(data);
        Preferences preferences = NbPreferences.forModule(RemoteNavigationManagerImpl.class);
        preferences.putByteArray(PREF_CONFIGURED_SERVERS_KEY, out.toByteArray());
    }

    protected ByteArrayOutputStream store(List<EFMServerData> favoritesItems) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objOut = new ObjectOutputStream(out);
            objOut.writeObject(favoritesItems);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        return out;
    }

    public List<NavigationItem> getServerItems() {
        if (this.server == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.server);
    }
}

